/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.fragments;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageRequest;
import com.polites.android.GestureImageView;
import java.io.FileNotFoundException;
import ru.appsm.inapphelp.IAHHelpDesk;
import ru.appsm.inapphelp.R;
import ru.appsm.inapphelp.fragments.IAHFragmentParent;
import ru.appsm.inapphelp.fragments.NewIssueFragment;
import ru.appsm.inapphelp.logic.IAHUtils;
import ru.appsm.inapphelp.service.DownloadAttachmentUtility;

public class ImageAttachmentDisplayFragment
extends IAHFragmentParent {
    private static final String TAG = ImageAttachmentDisplayFragment.class.getSimpleName();
    public String image_url;
    GestureImageView imageView;
    private RequestQueue queue;
    private static final String LoadImageCancelTag = "DownloadAttachment";
    private View progressView;
    boolean isAttachmentDownloaded = false;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.iah_fragment_image_attachment_display, container, false);
        this.progressView = rootView.findViewById(R.id.progressHolder);
        this.imageView = (GestureImageView)rootView.findViewById(R.id.image);
        this.setHasOptionsMenu(true);
        this.queue = IAHHelpDesk.getInstance().getRequestQueue();
        if (savedInstanceState == null) {
            this.showLoading(true);
            this.loadImage();
        } else {
            this.isAttachmentDownloaded = savedInstanceState.getBoolean("isAttachmentDownloaded");
            if (this.isAttachmentDownloaded) {
                this.showLoading(false);
                this.imageView.setImageBitmap((Bitmap)savedInstanceState.getParcelable("bitmap"));
            } else {
                this.showLoading(true);
                this.loadImage();
            }
        }
        return rootView;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("isAttachmentDownloaded", this.isAttachmentDownloaded);
        outState.putParcelable("bitmap", (Parcelable)((BitmapDrawable)this.imageView.getDrawable()).getBitmap());
    }

    public void onDestroy() {
        this.queue.cancelAll((Object)LoadImageCancelTag);
        super.onDestroy();
    }

    public void showLoading(boolean visible) {
        this.progressView.setVisibility(visible ? 0 : 8);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        inflater.inflate(R.menu.iah_image_attachment_display, menu2);
    }

    public void onPrepareOptionsMenu(Menu menu2) {
        super.onPrepareOptionsMenu(menu2);
        MenuItem downloadItem = menu2.findItem(R.id.menu_download);
        if (this.image_url != null && this.image_url.startsWith("http")) {
            downloadItem.setVisible(true);
        } else {
            downloadItem.setVisible(false);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.menu_download) {
            DownloadAttachmentUtility.downloadAttachment((Context)this.getActivity(), this.image_url, this.getInapphelpActivity().getTitle().toString());
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void loadImage() {
        if (this.image_url.startsWith("http")) {
            this.showLoading(true);
            ImageRequest imgRequest = new ImageRequest(this.image_url, (Response.Listener)new Response.Listener<Bitmap>(){

                public void onResponse(Bitmap response) {
                    ImageAttachmentDisplayFragment.this.imageView.setImageBitmap(response);
                    ImageAttachmentDisplayFragment.this.showLoading(false);
                }
            }, 0, 0, Bitmap.Config.ARGB_8888, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    IAHUtils.showAlertDialog((Context)ImageAttachmentDisplayFragment.this.getActivity(), ImageAttachmentDisplayFragment.this.getResources().getString(R.string.iah_error), ImageAttachmentDisplayFragment.this.getResources().getString(R.string.iah_error_fetching_attachment));
                    ImageAttachmentDisplayFragment.this.showLoading(false);
                }
            });
            imgRequest.setTag((Object)LoadImageCancelTag);
            this.queue.add((Request)imgRequest);
            this.queue.start();
            this.getActivity().invalidateOptionsMenu();
        } else if (this.image_url.startsWith("content")) {
            try {
                Bitmap selectedBitmap = NewIssueFragment.downscaleAndReadBitmap((Context)this.getActivity(), Uri.parse((String)this.image_url));
                this.imageView.setImageBitmap(selectedBitmap);
                this.showLoading(false);
            }
            catch (FileNotFoundException e) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Sorry! could not open attachment, unknown image", (int)1).show();
                this.getActivity().finish();
            }
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)"Sorry! could not open attachment, unknown image", (int)1).show();
            this.getActivity().finish();
        }
    }
}

