/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.fragments;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import ru.appsm.inapphelp.R;
import ru.appsm.inapphelp.activities.EditAttachmentActivity;
import ru.appsm.inapphelp.activities.IAHActivityManager;
import ru.appsm.inapphelp.fragments.IAHFragmentParent;
import ru.appsm.inapphelp.fragments.NewIssueFragment;
import ru.appsm.inapphelp.helper.IAHBaseExpandableListAdapter;
import ru.appsm.inapphelp.logic.IAHSource;
import ru.appsm.inapphelp.logic.IAHUtils;
import ru.appsm.inapphelp.logic.OnFetchedArraySuccessListener;
import ru.appsm.inapphelp.model.IAHAttachment;
import ru.appsm.inapphelp.model.IAHTicketUpdate;
import ru.appsm.inapphelp.model.IAHUser;
import ru.appsm.inapphelp.service.DownloadAttachmentUtility;

public class IssueDetailFragment
extends IAHFragmentParent {
    private final int REQUEST_CODE_PHOTO_PICKER = 100;
    private ExpandableListView mExpandableListView;
    private LocalAdapter mAdapter;
    private ImageView sendButton;
    private EditText replyEditTextView;
    private ImageView mAttachmentButton;
    private IAHUser user;
    private IAHSource gearSource;
    private IAHTicketUpdate[] fetchedUpdates;
    private IAHAttachment selectedAttachment;
    private Boolean updateTicketInProgress = false;
    private Handler updateHandler;
    private int updateInterval = 10000;
    private IAHBaseExpandableListAdapter.OnChildItemClickListener listChildClickListener = new IAHBaseExpandableListAdapter.OnChildItemClickListener(){

        @Override
        public boolean onChildListItemLongClick(int groupPosition, int childPosition, String type, Object map) {
            return false;
        }

        @Override
        public void onChildListItemClick(int groupPosition, int childPosition, String type, Object map) {
            IssueDetailFragment.this.showAttachments(((IAHTicketUpdate)map).getAttachments());
        }

        @Override
        public void onChildCheckedListner(int groupPosition, int childPosition, String type, Object map, boolean checked) {
        }
    };
    private View.OnClickListener attachmentClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (IssueDetailFragment.this.selectedAttachment == null) {
                Intent intent = new Intent((Context)IssueDetailFragment.this.getActivity(), EditAttachmentActivity.class);
                IssueDetailFragment.this.startActivityForResult(intent, 100);
            } else {
                AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)IssueDetailFragment.this.getActivity());
                alertBuilder.setTitle((CharSequence)IssueDetailFragment.this.getResources().getString(R.string.iah_attachment));
                alertBuilder.setIcon(R.drawable.iah_attachment_img);
                CharSequence[] attachmentOptions = new String[]{IssueDetailFragment.this.getResources().getString(R.string.iah_change), IssueDetailFragment.this.getResources().getString(R.string.iah_remove)};
                alertBuilder.setItems(attachmentOptions, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (which == 0) {
                            Intent intent = new Intent((Context)IssueDetailFragment.this.getActivity(), EditAttachmentActivity.class);
                            IssueDetailFragment.this.startActivityForResult(intent, 100);
                        } else if (which == 1) {
                            IssueDetailFragment.this.selectedAttachment = null;
                            IssueDetailFragment.this.resetAttachmentImage();
                        }
                    }
                });
                alertBuilder.create().show();
            }
        }
    };
    private View.OnClickListener sendReplyListener = new View.OnClickListener(){

        public void onClick(View v) {
            String message = IssueDetailFragment.this.replyEditTextView.getText().toString();
            if (message.trim().length() == 0) {
                return;
            }
            IssueDetailFragment.this.getInapphelpActivity().setProgressBarIndeterminateVisibility(true);
            IssueDetailFragment.this.sendButton.setEnabled(false);
            IssueDetailFragment.this.sendButton.setAlpha(0.4f);
            IAHAttachment[] attachmentArray = null;
            if (IssueDetailFragment.this.selectedAttachment != null) {
                attachmentArray = new IAHAttachment[]{IssueDetailFragment.this.selectedAttachment};
            }
            InputMethodManager imm = (InputMethodManager)IssueDetailFragment.this.getActivity().getSystemService("input_method");
            imm.hideSoftInputFromWindow(IssueDetailFragment.this.replyEditTextView.getWindowToken(), 0);
            Long last_message_id = 0L;
            if (IssueDetailFragment.this.fetchedUpdates.length > 0) {
                last_message_id = IssueDetailFragment.this.fetchedUpdates[IssueDetailFragment.this.fetchedUpdates.length - 1].getId();
            }
            IssueDetailFragment.this.gearSource.addReplyOnATicket("REPLY_TO_A_TICKET", message, attachmentArray, last_message_id, IssueDetailFragment.this.user, new OnFetchedArraySuccessListener(){

                @Override
                public void onSuccess(Object[] successObject) {
                    IssueDetailFragment.this.clearFormData();
                    IssueDetailFragment.this.sendButton.setEnabled(true);
                    IssueDetailFragment.this.sendButton.setAlpha(1.0f);
                    if (IssueDetailFragment.this.fetchedUpdates.length > 0) {
                        ArrayList<IAHTicketUpdate> both = new ArrayList<IAHTicketUpdate>(Arrays.asList(IssueDetailFragment.this.fetchedUpdates));
                        both.addAll(Arrays.asList((IAHTicketUpdate[])successObject));
                        IssueDetailFragment.access$102(IssueDetailFragment.this, both.toArray(IssueDetailFragment.this.fetchedUpdates));
                    } else {
                        IssueDetailFragment.access$102(IssueDetailFragment.this, (IAHTicketUpdate[])successObject);
                    }
                    IssueDetailFragment.this.refreshList();
                    IssueDetailFragment.this.getInapphelpActivity().setProgressBarIndeterminateVisibility(false);
                    if (((IAHTicketUpdate[])successObject).length > 0) {
                        IssueDetailFragment.this.scrollListToBottom();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    IAHUtils.showAlertDialog((Context)IssueDetailFragment.this.getActivity(), IssueDetailFragment.this.getResources().getString(R.string.iah_error), IssueDetailFragment.this.getResources().getString(R.string.iah_error_posting_reply));
                    IssueDetailFragment.this.sendButton.setEnabled(true);
                    IssueDetailFragment.this.sendButton.setAlpha(1.0f);
                    IssueDetailFragment.this.getInapphelpActivity().setProgressBarIndeterminateVisibility(false);
                }
            });
        }
    };
    Runnable updateChecker = new Runnable(){

        @Override
        public void run() {
            IssueDetailFragment.this.refreshUpdateFromServer();
        }
    };

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.iah_fragment_issue_detail, null);
        this.replyEditTextView = (EditText)rootView.findViewById(R.id.replyEditText);
        this.sendButton = (ImageView)rootView.findViewById(R.id.button1);
        this.sendButton.setOnClickListener(this.sendReplyListener);
        this.mExpandableListView = (ExpandableListView)rootView.findViewById(R.id.expandableList);
        this.mAttachmentButton = (ImageView)rootView.findViewById(R.id.attachmentbutton);
        this.mAttachmentButton.setOnClickListener(this.attachmentClickListener);
        this.mAdapter = new LocalAdapter((Context)this.getActivity());
        this.mExpandableListView.setAdapter((ExpandableListAdapter)this.mAdapter);
        this.mExpandableListView.setTranscriptMode(2);
        this.gearSource = IAHSource.getInstance((Context)this.getActivity());
        this.replyEditTextView.setText((CharSequence)this.gearSource.getDraftReplyMessage());
        if (this.gearSource.getDraftReplyAttachments() != null && this.gearSource.getDraftReplyAttachments().length > 0) {
            this.selectedAttachment = this.gearSource.getDraftReplyAttachments()[0];
            this.resetAttachmentImage();
        }
        this.mAdapter.setOnChildItemClickListener(this.listChildClickListener);
        this.fetchedUpdates = new IAHTicketUpdate[0];
        this.updateHandler = new Handler();
        this.updateChecker.run();
        return rootView;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState == null) {
            this.refreshUpdateFromServer();
        } else {
            Gson gson = new Gson();
            this.fetchedUpdates = (IAHTicketUpdate[])gson.fromJson(savedInstanceState.getString("updates"), IAHTicketUpdate[].class);
            this.selectedAttachment = (IAHAttachment)savedInstanceState.getSerializable("selectedAttachment");
            this.replyEditTextView.setText((CharSequence)savedInstanceState.getString("replyEditTextView"));
            this.refreshList();
            this.resetAttachmentImage();
            this.refreshUpdateFromServer();
        }
        this.refreshList();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Gson json = new Gson();
        outState.putString("updates", json.toJson((Object)this.fetchedUpdates));
        outState.putSerializable("selectedAttachment", (Serializable)this.selectedAttachment);
        outState.putSerializable("replyEditTextView", (Serializable)((Object)this.replyEditTextView.getText().toString()));
    }

    public void onPause() {
        super.onPause();
        IAHAttachment[] attachmentArray = null;
        if (this.selectedAttachment != null) {
            attachmentArray = new IAHAttachment[]{this.selectedAttachment};
        }
        this.updateHandler.removeCallbacks(this.updateChecker);
        this.gearSource.saveReplyDetailsInDraft(this.replyEditTextView.getText().toString(), attachmentArray);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == 100 && resultCode == -1) {
            Uri selectedImage = Uri.parse((String)intent.getStringExtra("URI"));
            Cursor cursor = this.getActivity().getContentResolver().query(selectedImage, new String[]{"_data", "_display_name", "mime_type"}, null, null, null);
            cursor.moveToFirst();
            String display_name = cursor.getString(cursor.getColumnIndex("_display_name"));
            String mime_type = cursor.getString(cursor.getColumnIndex("mime_type"));
            cursor.close();
            this.selectedAttachment = IAHAttachment.createAttachment(selectedImage.toString(), display_name, mime_type);
            this.resetAttachmentImage();
        }
    }

    public void onDetach() {
        this.updateHandler.removeCallbacks(this.updateChecker);
        this.gearSource.cancelOperation("REPLY_TO_A_TICKET");
        this.gearSource.cancelOperation("ALL_UPDATES");
        super.onDetach();
    }

    private void refreshUpdateFromServer() {
        if (this.updateTicketInProgress.booleanValue()) {
            return;
        }
        this.getInapphelpActivity().setProgressBarIndeterminateVisibility(true);
        this.updateTicketInProgress = true;
        Long last_message_id = 0L;
        if (this.fetchedUpdates.length > 0) {
            last_message_id = this.fetchedUpdates[this.fetchedUpdates.length - 1].getId();
        }
        this.gearSource.requestUpdatesOnTicket("ALL_UPDATES", last_message_id, this.user, new OnFetchedArraySuccessListener(){

            @Override
            public void onSuccess(Object[] successObject) {
                IssueDetailFragment.this.updateTicketInProgress = false;
                if (IssueDetailFragment.this.fetchedUpdates.length > 0) {
                    ArrayList<IAHTicketUpdate> both = new ArrayList<IAHTicketUpdate>(Arrays.asList(IssueDetailFragment.this.fetchedUpdates));
                    both.addAll(Arrays.asList((IAHTicketUpdate[])successObject));
                    IssueDetailFragment.access$102(IssueDetailFragment.this, both.toArray(IssueDetailFragment.this.fetchedUpdates));
                } else {
                    IssueDetailFragment.access$102(IssueDetailFragment.this, (IAHTicketUpdate[])successObject);
                }
                IssueDetailFragment.this.getInapphelpActivity().setProgressBarIndeterminateVisibility(false);
                if (successObject.length > 0) {
                    IssueDetailFragment.this.refreshList();
                    IssueDetailFragment.this.scrollListToBottom();
                }
                IssueDetailFragment.this.updateHandler.postDelayed(IssueDetailFragment.this.updateChecker, (long)IssueDetailFragment.this.updateInterval);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                IssueDetailFragment.this.updateTicketInProgress = false;
                IAHUtils.showAlertDialog((Context)IssueDetailFragment.this.getActivity(), IssueDetailFragment.this.getResources().getString(R.string.iah_error), IssueDetailFragment.this.getResources().getString(R.string.iah_error_fetching_ticket_updates));
                IssueDetailFragment.this.getInapphelpActivity().setProgressBarIndeterminateVisibility(false);
            }
        });
    }

    private void clearFormData() {
        this.replyEditTextView.setText((CharSequence)"");
        this.gearSource.clearReplyDraft();
        this.selectedAttachment = null;
        this.resetAttachmentImage();
    }

    private void expandAll() {
        int count = this.mAdapter.getGroupCount();
        for (int i = 0; i < count; ++i) {
            this.mExpandableListView.expandGroup(i);
        }
    }

    private void refreshList() {
        this.mAdapter.clearAll();
        if (this.fetchedUpdates != null) {
            this.mAdapter.addParent(1, "");
            for (int i = 0; i < this.fetchedUpdates.length; ++i) {
                this.mAdapter.addChild(1, this.fetchedUpdates[i]);
            }
        }
        this.mAdapter.notifyDataSetChanged();
        this.expandAll();
    }

    private void showAttachments(final IAHAttachment[] attachmentsArray) {
        if (attachmentsArray.length == 1) {
            IAHAttachment attachmentToShow = attachmentsArray[0];
            this.openAttachment(attachmentToShow);
            return;
        }
        ArrayList<String> attachments = new ArrayList<String>();
        for (IAHAttachment attachment : attachmentsArray) {
            attachments.add(attachment.getFileName());
        }
        Object[] attachmentNames = attachments.toArray(new String[attachments.size()]);
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.getActivity());
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        View convertView = inflater.inflate(R.layout.iah_attachment_dialog, null);
        alertDialog.setView(convertView);
        alertDialog.setTitle((CharSequence)this.getResources().getString(R.string.iah_attachments));
        final AlertDialog dialog = alertDialog.create();
        ListView lv = (ListView)convertView.findViewById(R.id.listView1);
        ArrayAdapter adapter = new ArrayAdapter((Context)this.getActivity(), 17367043, attachmentNames);
        lv.setAdapter((ListAdapter)adapter);
        lv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                IAHAttachment attachmentToShow = attachmentsArray[position];
                IssueDetailFragment.this.openAttachment(attachmentToShow);
                dialog.dismiss();
            }
        });
        dialog.show();
    }

    private void resetAttachmentImage() {
        if (this.selectedAttachment == null) {
            this.mAttachmentButton.setImageResource(R.drawable.iah_add_attachment);
        } else {
            try {
                Uri uri = Uri.parse((String)this.selectedAttachment.getUrl());
                Bitmap selectedBitmap = NewIssueFragment.downscaleAndReadBitmap((Context)this.getActivity(), uri);
                this.mAttachmentButton.setImageBitmap(selectedBitmap);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void scrollListToBottom() {
        this.mExpandableListView.setSelectedChild(0, this.mAdapter.getChildrenCount(0) - 1, true);
    }

    public IAHUser getUser() {
        return this.user;
    }

    public void setUser(IAHUser user) {
        this.user = user;
    }

    private void openAttachment(IAHAttachment attachment) {
        if (this.knownAttachmentType(attachment)) {
            IAHActivityManager.startImageAttachmentDisplayActivity((Activity)this.getInapphelpActivity(), attachment.getUrl(), attachment.getFileName());
        } else {
            this.downloadAttachment(attachment);
        }
    }

    private boolean knownAttachmentType(IAHAttachment attachment) {
        String mime_type = attachment.getMime_type();
        if (mime_type != null && mime_type.startsWith("image")) {
            return true;
        }
        String file_name = attachment.getFileName();
        return file_name != null && this.isKnowFileNameType(file_name);
    }

    private boolean isKnowFileNameType(String file_name) {
        StringTokenizer strtok = new StringTokenizer(file_name, ".");
        String fileType = null;
        while (strtok.hasMoreTokens()) {
            fileType = strtok.nextToken();
        }
        String[] knownFileType = new String[]{"png", "jpg", "jpeg"};
        return this.containString(knownFileType, fileType.toLowerCase());
    }

    private boolean containString(String[] array, String data) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].contains(data)) continue;
            return true;
        }
        return false;
    }

    public void downloadAttachment(IAHAttachment attachment) {
        DownloadAttachmentUtility.downloadAttachment((Context)this.getActivity(), attachment.getUrl(), attachment.getFileName());
    }

    static /* synthetic */ IAHTicketUpdate[] access$102(IssueDetailFragment x0, IAHTicketUpdate[] x1) {
        x0.fetchedUpdates = x1;
        return x1;
    }

    private class LocalAdapter
    extends IAHBaseExpandableListAdapter {
        public LocalAdapter(Context context) {
            super(context);
        }

        @Override
        public View getChildView(final int groupPosition, final int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
            ChildViewHolder holder;
            if (convertView == null) {
                holder = new ChildViewHolder();
                convertView = this.getChildType(groupPosition, childPosition) == 0 ? this.mLayoutInflater.inflate(R.layout.iah_expandable_child_issue_detail_staff_reply, null) : this.mLayoutInflater.inflate(R.layout.iah_expandable_child_issue_detail_user_reply, null);
                holder.textView1 = (TextView)convertView.findViewById(R.id.textView1);
                holder.nameField = (TextView)convertView.findViewById(R.id.name);
                holder.timeField = (TextView)convertView.findViewById(R.id.time);
                holder.attachmentButton = (ImageView)convertView.findViewById(R.id.attachment_icon);
                holder.textView_no_message = (TextView)convertView.findViewById(R.id.textView_no_message);
                convertView.setTag((Object)holder);
            } else {
                holder = (ChildViewHolder)convertView.getTag();
            }
            final IAHTicketUpdate update = (IAHTicketUpdate)this.getChild(groupPosition, childPosition);
            holder.textView1.setMovementMethod(LinkMovementMethod.getInstance());
            String text = update.getText().trim();
            if (text == null || text.length() == 0) {
                holder.textView_no_message.setVisibility(0);
                holder.textView1.setVisibility(8);
                holder.textView1.setText((CharSequence)"");
            } else {
                holder.textView_no_message.setVisibility(8);
                holder.textView1.setVisibility(0);
                holder.textView1.setText((CharSequence)text);
            }
            if (update.isUserUpdate()) {
                holder.nameField.setText((CharSequence)IssueDetailFragment.this.getResources().getString(R.string.iah_me));
            } else if (update.name != null) {
                holder.nameField.setText((CharSequence)update.name);
            } else {
                holder.nameField.setText((CharSequence)IssueDetailFragment.this.getResources().getString(R.string.iah_staff));
            }
            if (update.isAttachmentEmtpy()) {
                holder.attachmentButton.setVisibility(4);
            } else {
                holder.attachmentButton.setVisibility(0);
                holder.attachmentButton.setFocusable(true);
                holder.attachmentButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        LocalAdapter.this.sendChildClickEvent(groupPosition, childPosition, "attachment", update);
                    }
                });
            }
            Date updatedTime = update.getUpdatedTime();
            String dateString = IAHUtils.convertToHumanReadableTime(updatedTime, Calendar.getInstance().getTimeInMillis());
            holder.timeField.setText((CharSequence)dateString.trim());
            return convertView;
        }

        @Override
        public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
            ParentViewHolder holder;
            if (convertView == null) {
                convertView = this.mLayoutInflater.inflate(R.layout.iah_expandable_parent_issue_detail_default, null);
                holder = new ParentViewHolder();
                holder.parent = convertView;
                convertView.setTag((Object)holder);
            } else {
                holder = (ParentViewHolder)convertView.getTag();
            }
            holder.parent.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
            return convertView;
        }

        public int getChildTypeCount() {
            return 2;
        }

        public int getChildType(int groupPosition, int childPosition) {
            IAHTicketUpdate update = (IAHTicketUpdate)this.getChild(groupPosition, childPosition);
            return update.isStaffUpdate() ? 0 : 1;
        }

        private class ChildViewHolder {
            public TextView textView1;
            public TextView nameField;
            public TextView timeField;
            public ImageView attachmentButton;
            public TextView textView_no_message;

            private ChildViewHolder() {
            }
        }

        private class ParentViewHolder {
            View parent;

            private ParentViewHolder() {
            }
        }
    }
}

