/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.fragments;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.view.MenuItemCompat;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import ru.appsm.inapphelp.R;
import ru.appsm.inapphelp.activities.EditAttachmentActivity;
import ru.appsm.inapphelp.activities.IAHActivityManager;
import ru.appsm.inapphelp.fragments.IAHFragmentParent;
import ru.appsm.inapphelp.logic.IAHSource;
import ru.appsm.inapphelp.logic.IAHUtils;
import ru.appsm.inapphelp.model.IAHAttachment;

public class NewIssueFragment
extends IAHFragmentParent {
    private final int REQUEST_CODE_PHOTO_PICKER = 100;
    public static final int REQUEST_CODE_NEW_TICKET = 1003;
    public static final String EXTRAS_MESSAGE = "message";
    public static final String EXTRAS_ATTACHMENT = "attachment";
    EditText messageField;
    ImageView imageView1;
    IAHAttachment selectedAttachment;
    IAHSource gearSource;
    private View.OnClickListener attachmentClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (NewIssueFragment.this.selectedAttachment == null) {
                Intent intent = new Intent((Context)NewIssueFragment.this.getActivity(), EditAttachmentActivity.class);
                NewIssueFragment.this.startActivityForResult(intent, 100);
            } else {
                AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)NewIssueFragment.this.getActivity());
                alertBuilder.setTitle((CharSequence)NewIssueFragment.this.getResources().getString(R.string.iah_attachment));
                alertBuilder.setIcon(R.drawable.iah_attachment_img);
                CharSequence[] attachmentOptions = new String[]{NewIssueFragment.this.getResources().getString(R.string.iah_change), NewIssueFragment.this.getResources().getString(R.string.iah_remove)};
                alertBuilder.setItems(attachmentOptions, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (which == 0) {
                            Intent intent = new Intent((Context)NewIssueFragment.this.getActivity(), EditAttachmentActivity.class);
                            NewIssueFragment.this.startActivityForResult(intent, 100);
                        } else if (which == 1) {
                            NewIssueFragment.this.selectedAttachment = null;
                            NewIssueFragment.this.resetAttachmentImage();
                        }
                    }
                });
                alertBuilder.create().show();
            }
        }
    };

    public static NewIssueFragment createNewIssueFragment() {
        return new NewIssueFragment();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        View rootView = inflater.inflate(R.layout.iah_fragment_new_issue, container, false);
        this.messageField = (EditText)rootView.findViewById(R.id.messageField);
        this.imageView1 = (ImageView)rootView.findViewById(R.id.imageView1);
        this.imageView1.setOnClickListener(this.attachmentClickListener);
        this.gearSource = IAHSource.getInstance((Context)this.getActivity());
        this.messageField.setText((CharSequence)this.gearSource.getDraftMessage());
        if (this.gearSource.getDraftAttachments() != null && this.gearSource.getDraftAttachments().length > 0) {
            this.selectedAttachment = this.gearSource.getDraftAttachments()[0];
            this.resetAttachmentImage();
        }
        return rootView;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(EXTRAS_MESSAGE, this.messageField.getText().toString());
        outState.putSerializable(EXTRAS_ATTACHMENT, (Serializable)this.selectedAttachment);
    }

    public void onPause() {
        super.onPause();
        IAHAttachment[] attachmentArray = null;
        if (this.selectedAttachment != null) {
            attachmentArray = new IAHAttachment[]{this.selectedAttachment};
        }
        this.gearSource.saveTicketDetailsInDraft(this.messageField.getText().toString(), attachmentArray);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState != null) {
            this.messageField.setText((CharSequence)savedInstanceState.getString(EXTRAS_MESSAGE));
            this.selectedAttachment = (IAHAttachment)savedInstanceState.getSerializable(EXTRAS_ATTACHMENT);
        }
        this.resetAttachmentImage();
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        inflater.inflate(R.menu.iah_issue_menu, menu2);
        MenuItem clearMenu = menu2.findItem(R.id.clearItem);
        MenuItemCompat.setShowAsAction((MenuItem)clearMenu, (int)2);
        MenuItem doneMenu = menu2.findItem(R.id.doneItem);
        doneMenu.setIcon(this.getResources().getDrawable(R.drawable.iah_action_forward));
        doneMenu.setTitle(this.getResources().getText(R.string.iah_next));
        MenuItemCompat.setShowAsAction((MenuItem)doneMenu, (int)2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.doneItem) {
            if (this.getMessage().trim().length() == 0) {
                IAHUtils.showAlertDialog((Context)this.getActivity(), this.getResources().getString(R.string.iah_error), this.getResources().getString(R.string.iah_error_subject_message_empty));
                return false;
            }
            IAHAttachment[] attachmentArray = null;
            if (this.selectedAttachment != null) {
                attachmentArray = new IAHAttachment[]{this.selectedAttachment};
            }
            String formattedBody = this.getMessage();
            IAHActivityManager.startNewUserActivity(this, 1003, formattedBody, attachmentArray);
            return true;
        }
        if (id2 == R.id.clearItem) {
            this.clearFormData();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        switch (requestCode) {
            case 100: {
                if (resultCode == -1) {
                    Uri selectedImage = Uri.parse((String)intent.getStringExtra("URI"));
                    Cursor cursor = this.getActivity().getContentResolver().query(selectedImage, new String[]{"_data", "_display_name", "mime_type"}, null, null, null);
                    cursor.moveToFirst();
                    String display_name = cursor.getString(cursor.getColumnIndex("_display_name"));
                    String mime_type = cursor.getString(cursor.getColumnIndex("mime_type"));
                    cursor.close();
                    this.selectedAttachment = IAHAttachment.createAttachment(selectedImage.toString(), display_name, mime_type);
                    this.resetAttachmentImage();
                    break;
                }
            }
            case 1003: {
                if (resultCode != -1) break;
                IAHActivityManager.sendSuccessSignal((Activity)this.getActivity(), intent);
            }
        }
    }

    public void onDetach() {
        this.gearSource.cancelOperation("NEW_TICKET");
        super.onDetach();
    }

    private void resetAttachmentImage() {
        if (this.selectedAttachment == null) {
            this.imageView1.setImageResource(R.drawable.iah_add_attachment_img);
        } else {
            try {
                Uri uri = Uri.parse((String)this.selectedAttachment.getUrl());
                Bitmap selectedBitmap = NewIssueFragment.downscaleAndReadBitmap((Context)this.getActivity(), uri);
                this.imageView1.setImageBitmap(selectedBitmap);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void clearFormData() {
        this.messageField.setText((CharSequence)"");
        this.selectedAttachment = null;
        this.resetAttachmentImage();
        this.gearSource.clearTicketDraft();
    }

    public String getMessage() {
        return this.messageField.getText().toString();
    }

    public static Bitmap downscaleAndReadBitmap(Context context, Uri selectedImage) throws FileNotFoundException {
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(selectedImage), null, (BitmapFactory.Options)o);
        int REQUIRED_SIZE = 140;
        int width_tmp = o.outWidth;
        int height_tmp = o.outHeight;
        int scale = 1;
        while (width_tmp / 2 >= 140 && height_tmp / 2 >= 140) {
            width_tmp /= 2;
            height_tmp /= 2;
            scale *= 2;
        }
        BitmapFactory.Options o2 = new BitmapFactory.Options();
        o2.inSampleSize = scale;
        return BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(selectedImage), null, (BitmapFactory.Options)o2);
    }
}

