/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.MenuItemCompat;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.Toast;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.google.gson.Gson;
import java.io.Serializable;
import ru.appsm.inapphelp.R;
import ru.appsm.inapphelp.activities.IAHActivityManager;
import ru.appsm.inapphelp.fragments.IAHFragmentParent;
import ru.appsm.inapphelp.logic.IAHSource;
import ru.appsm.inapphelp.logic.IAHUtils;
import ru.appsm.inapphelp.logic.OnFetchedSuccessListener;
import ru.appsm.inapphelp.logic.OnNewTicketFetchedSuccessListener;
import ru.appsm.inapphelp.model.IAHAttachment;
import ru.appsm.inapphelp.model.IAHUser;

public class NewUserFragment
extends IAHFragmentParent {
    private static final String RESULT_USER = "result_user";
    private static final String EXTRAS_MESSAGE = "message";
    private static final String EXTRAS_ATTACHMENT = "attachment";
    private static final String EXTRAS_FIRST_NAME = "first_name";
    private static final String EXTRAS_LAST_NAME = "last_name";
    private static final String EXTRAS_EMAIL = "email";
    private String message;
    private IAHAttachment[] attachmentArray;
    EditText firstNameField;
    EditText lastNameField;
    EditText emailField;
    IAHSource gearSource;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        View rootView = inflater.inflate(R.layout.iah_fragment_new_user, container, false);
        this.firstNameField = (EditText)rootView.findViewById(R.id.firstname);
        this.lastNameField = (EditText)rootView.findViewById(R.id.lastname);
        this.emailField = (EditText)rootView.findViewById(R.id.email);
        return rootView;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(EXTRAS_FIRST_NAME, this.firstNameField.getText().toString());
        outState.putString(EXTRAS_LAST_NAME, this.lastNameField.getText().toString());
        outState.putString(EXTRAS_EMAIL, this.emailField.getText().toString());
        outState.putString(EXTRAS_MESSAGE, this.message);
        if (this.attachmentArray != null) {
            Gson gson = new Gson();
            outState.putString(EXTRAS_ATTACHMENT, gson.toJson((Object)this.attachmentArray));
        }
    }

    public void onPause() {
        super.onPause();
        IAHUser userDetails = IAHUser.createNewUserWithDetails(this.firstNameField.getText().toString(), this.lastNameField.getText().toString(), this.emailField.getText().toString(), null, null);
        this.gearSource.saveUserDetailsInDraft(userDetails);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle args = savedInstanceState;
        if (args == null) {
            args = this.getArguments();
        }
        if (args != null) {
            String email;
            String last_name;
            String first_name;
            this.message = args.getString(EXTRAS_MESSAGE, null);
            if (args.containsKey(EXTRAS_ATTACHMENT)) {
                String json = args.getString(EXTRAS_ATTACHMENT);
                Gson gson = new Gson();
                this.attachmentArray = (IAHAttachment[])gson.fromJson(json, IAHAttachment[].class);
            }
            if ((first_name = args.getString(EXTRAS_FIRST_NAME, null)) != null) {
                this.firstNameField.setText((CharSequence)first_name);
            }
            if ((last_name = args.getString(EXTRAS_LAST_NAME, null)) != null) {
                this.lastNameField.setText((CharSequence)last_name);
            }
            if ((email = args.getString(EXTRAS_EMAIL, null)) != null) {
                this.emailField.setText((CharSequence)email);
            }
        }
        this.gearSource = IAHSource.getInstance((Context)this.getActivity());
        IAHUser draftUser = this.gearSource.getDraftUser();
        if (draftUser != null) {
            this.firstNameField.setText((CharSequence)draftUser.getFirstName());
            this.lastNameField.setText((CharSequence)draftUser.getLastName());
            this.emailField.setText((CharSequence)draftUser.getEmail());
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        inflater.inflate(R.menu.iah_new_issue, menu2);
        MenuItem nextMenu = menu2.findItem(R.id.create_first_ticket_button);
        MenuItemCompat.setShowAsAction((MenuItem)nextMenu, (int)2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.create_first_ticket_button) {
            if (this.getFirstName().trim().length() == 0 || this.getLastName().trim().length() == 0 || this.getEmailAdddress().trim().length() == 0) {
                IAHUtils.showAlertDialog((Context)this.getActivity(), this.getResources().getString(R.string.iah_error), this.getResources().getString(R.string.iah_error_enter_all_fields_to_register));
                return false;
            }
            if (!Patterns.EMAIL_ADDRESS.matcher(this.getEmailAdddress()).matches()) {
                IAHUtils.showAlertDialog((Context)this.getActivity(), this.getResources().getString(R.string.iah_error_invalid_email), this.getResources().getString(R.string.iah_error_enter_valid_email));
                return false;
            }
            this.getInapphelpActivity().setSupportProgressBarIndeterminateVisibility(true);
            this.gearSource.checkForUserDetailsValidity("NEW_USER", this.getFirstName(), this.getLastName(), this.getEmailAdddress(), new OnFetchedSuccessListener(){

                @Override
                public void onSuccess(final Object successObject) {
                    String formattedBody = NewUserFragment.this.message;
                    NewUserFragment.this.gearSource.createNewTicket("NEW_TICKET", (IAHUser)successObject, formattedBody, NewUserFragment.this.attachmentArray, new OnNewTicketFetchedSuccessListener(){

                        @Override
                        public void onSuccess() {
                            NewUserFragment.this.getInapphelpActivity().setSupportProgressBarIndeterminateVisibility(false);
                            NewUserFragment.this.sendSuccessSignal((IAHUser)successObject);
                            NewUserFragment.this.gearSource.clearTicketDraft();
                            Toast.makeText((Context)NewUserFragment.this.getActivity(), (CharSequence)NewUserFragment.this.getResources().getString(R.string.iah_issue_created_raised), (int)1).show();
                        }
                    }, new Response.ErrorListener(){

                        public void onErrorResponse(VolleyError error) {
                            IAHUtils.showAlertDialog((Context)NewUserFragment.this.getActivity(), NewUserFragment.this.getResources().getString(R.string.iah_error_reporting_issue), NewUserFragment.this.getResources().getString(R.string.iah_error_check_network_connection));
                            NewUserFragment.this.getInapphelpActivity().setSupportProgressBarIndeterminateVisibility(false);
                        }
                    });
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    NewUserFragment.this.getInapphelpActivity().setSupportProgressBarIndeterminateVisibility(false);
                }
            });
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onDetach() {
        this.gearSource.cancelOperation("NEW_USER");
        super.onDetach();
    }

    public String getFirstName() {
        return this.firstNameField.getText().toString();
    }

    public String getLastName() {
        return this.lastNameField.getText().toString();
    }

    public String getEmailAdddress() {
        return this.emailField.getText().toString();
    }

    public void sendSuccessSignal(IAHUser user) {
        Intent intent = new Intent();
        intent.putExtra(RESULT_USER, (Serializable)user);
        IAHActivityManager.sendSuccessSignal((Activity)this.getActivity(), intent);
    }
}

