/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.fragments;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.widget.SearchView;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import ru.appsm.inapphelp.R;
import ru.appsm.inapphelp.activities.IAHActivityManager;
import ru.appsm.inapphelp.fragments.IAHFragmentParent;
import ru.appsm.inapphelp.model.IAHKBItem;

public class SearchFragment
extends IAHFragmentParent {
    private View rootView;
    private SearchAdapter searchAdapter;
    private IAHKBItem[] allKbArticles;
    private ListView listView;
    private SearchView searchView;
    private OnReportAnIssueClickListener articleSelecetedListener;
    protected AdapterView.OnItemClickListener listItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            IAHKBItem kbItemClicked = (IAHKBItem)SearchFragment.this.searchAdapter.getItem(position);
            SearchFragment.this.articleClickedOnPosition(kbItemClicked);
        }
    };
    private View.OnClickListener reportIssueClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (SearchFragment.this.articleSelecetedListener != null) {
                SearchFragment.this.articleSelecetedListener.startReportAnIssue();
            }
        }
    };

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.iah_fragment_search, container, false);
        this.setVisibility(false);
        this.listView = (ListView)this.rootView.findViewById(R.id.searchList);
        this.searchAdapter = new SearchAdapter(this.allKbArticles);
        View report_an_issue_view = inflater.inflate(R.layout.iah_expandable_footer_report_issue, null);
        report_an_issue_view.findViewById(R.id.button1).setOnClickListener(this.reportIssueClickListener);
        this.listView.addFooterView(report_an_issue_view);
        this.listView.setAdapter((ListAdapter)this.searchAdapter);
        this.listView.setOnItemClickListener(this.listItemClickListener);
        return this.rootView;
    }

    public void searchStarted() {
        this.searchAdapter.refreshList(this.allKbArticles);
        this.searchAdapter.getFilter().filter((CharSequence)"");
        this.searchAdapter.notifyDataSetChanged();
    }

    public void doSearchForQuery(String q) {
        this.searchAdapter.getFilter().filter((CharSequence)q);
    }

    public boolean isSearchVisible() {
        if (this.rootView == null) {
            return false;
        }
        return this.rootView.getVisibility() == 0;
    }

    public void setVisibility(boolean visible) {
        if (visible) {
            this.rootView.setVisibility(0);
        } else {
            this.rootView.setVisibility(8);
        }
    }

    public void setKBArticleList(IAHKBItem[] fetchedKbArticles) {
        this.allKbArticles = fetchedKbArticles;
        if (this.isSearchVisible()) {
            this.searchAdapter.refreshList(this.allKbArticles);
            this.searchAdapter.getFilter().filter((CharSequence)"");
            this.searchAdapter.notifyDataSetChanged();
        }
    }

    protected void articleClickedOnPosition(IAHKBItem kbItemClicked) {
        if (kbItemClicked.getArticleType() == 0) {
            IAHActivityManager.startArticleActivity(this, kbItemClicked, 1003);
        } else {
            IAHActivityManager.startSectionActivity(this, kbItemClicked, 1003);
        }
    }

    public void addSearchViewInMenuItem(Context context, MenuItem searchItem) {
        MenuItemCompat.setShowAsAction((MenuItem)searchItem, (int)10);
        this.searchView = new SearchView(context);
        MenuItemCompat.setActionView((MenuItem)searchItem, (View)this.searchView);
        this.searchView.setSubmitButtonEnabled(false);
        this.searchView.setOnSearchClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchFragment.this.searchStarted();
            }
        });
        this.searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String q) {
                SearchFragment.this.doSearchForQuery(q);
                return true;
            }

            public boolean onQueryTextChange(String newText) {
                SearchFragment.this.doSearchForQuery(newText);
                return true;
            }
        });
        MenuItemCompat.setOnActionExpandListener((MenuItem)searchItem, (MenuItemCompat.OnActionExpandListener)new MenuItemCompat.OnActionExpandListener(){

            public boolean onMenuItemActionExpand(MenuItem item) {
                SearchFragment.this.setVisibility(true);
                return true;
            }

            public boolean onMenuItemActionCollapse(MenuItem item) {
                SearchFragment.this.setVisibility(false);
                return true;
            }
        });
        if (Build.VERSION.SDK_INT >= 14) {
            // empty if block
        }
    }

    public void setOnReportAnIssueClickListener(OnReportAnIssueClickListener listener) {
        this.articleSelecetedListener = listener;
    }

    private class SearchAdapter
    extends BaseAdapter
    implements Filterable {
        private IAHKBItem[] allKBItems;
        private IAHKBItem[] searchResults;
        private CustomFilter filter;

        public SearchAdapter(IAHKBItem[] list) {
            this.allKBItems = list;
        }

        public void refreshList(IAHKBItem[] list) {
            this.allKBItems = list;
        }

        public int getCount() {
            if (this.searchResults == null) {
                return 0;
            }
            return this.searchResults.length;
        }

        public Object getItem(int position) {
            return this.searchResults[position];
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder = null;
            if (convertView == null) {
                LayoutInflater inflater = SearchFragment.this.getActivity().getLayoutInflater();
                convertView = inflater.inflate(R.layout.iah_sectionlist_article, null);
                holder = new ViewHolder();
                holder.textview = (TextView)convertView.findViewById(R.id.sectionlisttextview);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.textview.setText((CharSequence)this.searchResults[position].getSubject());
            return convertView;
        }

        public Filter getFilter() {
            if (this.filter == null) {
                this.filter = new CustomFilter();
            }
            return this.filter;
        }

        static /* synthetic */ IAHKBItem[] access$602(SearchAdapter x0, IAHKBItem[] x1) {
            x0.searchResults = x1;
            return x1;
        }

        private class CustomFilter
        extends Filter {
            private CustomFilter() {
            }

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                Filter.FilterResults results = new Filter.FilterResults();
                if (constraint == null || constraint.length() == 0) {
                    results.values = SearchAdapter.this.allKBItems;
                    results.count = SearchAdapter.this.allKBItems.length;
                } else {
                    IAHKBItem[] values;
                    ArrayList<IAHKBItem> filterList = new ArrayList<IAHKBItem>();
                    for (IAHKBItem p : SearchAdapter.this.allKBItems) {
                        if (!p.getSubject().toUpperCase().contains(constraint.toString().toUpperCase())) continue;
                        filterList.add(p);
                    }
                    results.values = values = filterList.toArray(new IAHKBItem[filterList.size()]);
                    results.count = filterList.size();
                }
                return results;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                if (results == null) {
                    SearchAdapter.this.notifyDataSetInvalidated();
                } else {
                    SearchAdapter.access$602(SearchAdapter.this, (IAHKBItem[])results.values);
                    SearchAdapter.this.notifyDataSetChanged();
                }
            }
        }

        private class ViewHolder {
            private TextView textview;

            private ViewHolder() {
            }
        }
    }

    public static interface OnReportAnIssueClickListener {
        public void startReportAnIssue();
    }
}

