/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.google.gson.Gson;
import java.io.Serializable;
import ru.appsm.inapphelp.R;
import ru.appsm.inapphelp.activities.IAHActivityManager;
import ru.appsm.inapphelp.fragments.IAHFragmentManager;
import ru.appsm.inapphelp.fragments.IAHFragmentParent;
import ru.appsm.inapphelp.fragments.SearchFragment;
import ru.appsm.inapphelp.logic.IAHSource;
import ru.appsm.inapphelp.logic.IAHUtils;
import ru.appsm.inapphelp.logic.OnFetchedArraySuccessListener;
import ru.appsm.inapphelp.model.IAHKBItem;

public class SectionFragment
extends IAHFragmentParent {
    private static final int REQUEST_CODE_NEW_TICKET = 1003;
    private ListView mListView;
    private SectionAdapter mAdapter;
    private SearchFragment mSearchFragment;
    public IAHKBItem sectionItemToDisplay;
    private IAHSource gearSource;
    private IAHKBItem[] fetchedKbItems;
    protected View.OnClickListener reportIssueClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            SectionFragment.this.gearSource.launchCreateNewTicketScreen(SectionFragment.this, 1003);
        }
    };
    private SearchFragment.OnReportAnIssueClickListener reportAnIssueLisener = new SearchFragment.OnReportAnIssueClickListener(){

        @Override
        public void startReportAnIssue() {
            SectionFragment.this.mSearchFragment.setVisibility(false);
            SectionFragment.this.gearSource.launchCreateNewTicketScreen(SectionFragment.this, 1003);
        }
    };
    protected AdapterView.OnItemClickListener listItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            IAHKBItem kbItemClicked = SectionFragment.this.fetchedKbItems[position];
            SectionFragment.this.articleClickedOnPosition(kbItemClicked);
        }
    };

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.iah_fragment_section, container, false);
        this.mListView = (ListView)rootView.findViewById(R.id.sectionlistview);
        View report_an_issue_view = inflater.inflate(R.layout.iah_expandable_footer_report_issue, null);
        report_an_issue_view.findViewById(R.id.button1).setOnClickListener(this.reportIssueClickListener);
        this.mListView.addFooterView(report_an_issue_view);
        this.mAdapter = new SectionAdapter(this.fetchedKbItems);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener(this.listItemClickListener);
        this.mSearchFragment = new SearchFragment();
        IAHFragmentManager.putFragmentInActivity(this.getInapphelpActivity(), R.id.search_container, this.mSearchFragment, "Search");
        this.mSearchFragment.setOnReportAnIssueClickListener(this.reportAnIssueLisener);
        this.setHasOptionsMenu(true);
        this.gearSource = IAHSource.getInstance((Context)this.getActivity());
        if (savedInstanceState == null) {
            this.initializeView();
        } else {
            String json = savedInstanceState.getString("section_array");
            Gson gson = new Gson();
            this.fetchedKbItems = (IAHKBItem[])gson.fromJson(json, IAHKBItem[].class);
            this.mSearchFragment.setKBArticleList(this.fetchedKbItems);
            this.refreshList();
        }
        return rootView;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1003 && resultCode == -1) {
            IAHActivityManager.sendSuccessSignal((Activity)this.getActivity(), data);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Gson gson = new Gson();
        outState.putSerializable("section_array", (Serializable)((Object)gson.toJson((Object)this.fetchedKbItems)));
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        inflater.inflate(R.menu.iah_search_menu, menu2);
        MenuItem searchItem = menu2.findItem(R.id.search);
        this.mSearchFragment.addSearchViewInMenuItem((Context)this.getActivity(), searchItem);
    }

    public void onDetach() {
        super.onDetach();
        this.gearSource.cancelOperation("SECTION_FAQ");
    }

    private void initializeView() {
        this.getInapphelpActivity().setProgressBarIndeterminateVisibility(true);
        this.gearSource.requestKBArticle("SECTION_FAQ", this.sectionItemToDisplay, new OnFetchedArraySuccessListener(){

            @Override
            public void onSuccess(Object[] successObject) {
                SectionFragment.access$002(SectionFragment.this, (IAHKBItem[])successObject);
                SectionFragment.this.mSearchFragment.setKBArticleList(SectionFragment.this.fetchedKbItems);
                SectionFragment.this.refreshList();
                SectionFragment.this.getInapphelpActivity().setProgressBarIndeterminateVisibility(false);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                IAHUtils.showAlertDialog((Context)SectionFragment.this.getActivity(), SectionFragment.this.getResources().getString(R.string.iah_error), SectionFragment.this.getResources().getString(R.string.iah_error_fetching_articles));
            }
        });
    }

    private void refreshList() {
        this.mAdapter.setKbArticles(this.fetchedKbItems);
    }

    protected void articleClickedOnPosition(IAHKBItem kbItemClicked) {
        if (kbItemClicked.getArticleType() == 0) {
            IAHActivityManager.startArticleActivity(this, kbItemClicked, 1003);
        } else {
            IAHActivityManager.startSectionActivity(this, kbItemClicked, 1003);
        }
    }

    static /* synthetic */ IAHKBItem[] access$002(SectionFragment x0, IAHKBItem[] x1) {
        x0.fetchedKbItems = x1;
        return x1;
    }

    private class SectionAdapter
    extends BaseAdapter {
        IAHKBItem[] kbItems;

        public SectionAdapter(IAHKBItem[] kbItems) {
            this.kbItems = kbItems;
        }

        public void setKbArticles(IAHKBItem[] fetchedKbItems) {
            this.kbItems = fetchedKbItems;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            if (this.kbItems == null) {
                return 0;
            }
            return this.kbItems.length;
        }

        public Object getItem(int position) {
            return this.kbItems[position];
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder = null;
            if (convertView == null) {
                holder = new ViewHolder();
                LayoutInflater inflater = SectionFragment.this.getActivity().getLayoutInflater();
                convertView = inflater.inflate(R.layout.iah_sectionlist_article, null);
                holder.title = (TextView)convertView.findViewById(R.id.sectionlisttextview);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.title.setText((CharSequence)((IAHKBItem)this.getItem(position)).getSubject());
            return convertView;
        }

        private class ViewHolder {
            TextView title;

            private ViewHolder() {
            }
        }
    }
}

