/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.gears;

import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonArrayRequest;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.appsm.inapphelp.logic.IAHGear;
import ru.appsm.inapphelp.logic.OnFetchedArraySuccessListener;
import ru.appsm.inapphelp.logic.OnFetchedSuccessListener;
import ru.appsm.inapphelp.logic.OnNewTicketFetchedSuccessListener;
import ru.appsm.inapphelp.model.IAHAttachment;
import ru.appsm.inapphelp.model.IAHKBItem;
import ru.appsm.inapphelp.model.IAHTicketUpdate;
import ru.appsm.inapphelp.model.IAHUploadAttachment;
import ru.appsm.inapphelp.model.IAHUser;

public class IAHInapphelpGear
extends IAHGear {
    private static final String TAG = IAHInapphelpGear.class.getSimpleName();
    private String company;
    private String app_key;
    private String app_id;
    private String section_id;
    JSONArray allSectionsArray;

    public IAHInapphelpGear(String company, String app_id, String app_key) {
        assert (company != null) : "Company name cannot be null";
        assert (app_id != null) : "App id cannot be null";
        assert (app_key != null) : "App key cannot be null";
        this.company = company;
        this.app_key = app_key;
        this.app_id = app_id;
    }

    @Override
    public String getRefer() {
        return String.format("http://wwww.%s.inapphelp.com/", this.company);
    }

    @Override
    public void fetchKBArticle(String cancelTag, IAHKBItem section, RequestQueue queue, OnFetchedArraySuccessListener success, Response.ErrorListener errorListener) {
        String url = this.getApiUrl().concat("faq/" + this.app_id);
        JsonArrayRequest request = new JsonArrayRequest(url, (Response.Listener)new InapphelpArrayBaseListener<JSONArray>(success, errorListener){

            public void onResponse(JSONArray articlesArray) {
                try {
                    Object[] array = IAHInapphelpGear.this.retrieveArticlesFromArray(articlesArray);
                    this.successCallback.onSuccess(array);
                }
                catch (JSONException e) {
                    this.errorListener.onErrorResponse(new VolleyError("Fail to parse JSON"));
                }
            }
        }, errorListener);
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(3000, 3, 1.0f));
        request.setTag((Object)cancelTag);
        queue.add((Request)request);
        queue.start();
    }

    @Override
    public void registerNewUser(String cancelTag, String firstName, String lastname, String emailAddress, String userId, String userSecret, RequestQueue queue, OnFetchedSuccessListener success, Response.ErrorListener error) {
        IAHUser user = IAHUser.createNewUserWithDetails(firstName, lastname, emailAddress, userId, userSecret);
        success.onSuccess(user);
    }

    @Override
    public void fetchUpdateOnTicket(String cancelTag, Long from_time, IAHUser user, RequestQueue queue, OnFetchedArraySuccessListener success, Response.ErrorListener errorListener) {
        QueryString query = new QueryString();
        query.addToUri("userid", user.getUserId());
        query.addToUri("appid", this.app_id);
        query.addToUri("appkey", this.app_key);
        query.addToUri("from", from_time.toString());
        if (user.getUserSecret() != null) {
            query.addToUri("secretkey", user.getUserSecret());
        }
        String url = this.getApiUrl().concat("chat/updates?" + query.toString());
        JsonArrayRequest request = new JsonArrayRequest(url, (Response.Listener)new InapphelpArrayBaseListener<JSONArray>(success, errorListener){

            public void onResponse(JSONArray updateArray) {
                try {
                    Object[] array = IAHInapphelpGear.this.retrieveTicketUpdateFromArray(updateArray);
                    this.successCallback.onSuccess(array);
                }
                catch (JSONException e) {
                    this.errorListener.onErrorResponse(new VolleyError("Fail to parse JSON"));
                }
            }
        }, errorListener);
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 5, 1.0f));
        request.setTag((Object)cancelTag);
        queue.add((Request)request);
        queue.start();
    }

    @Override
    public void addReplyOnATicket(String cancelTag, String message, Map[] deviceInfo, IAHUploadAttachment[] attachments, String pushToken, Long get_updates_from_time, IAHUser user, RequestQueue queue, OnFetchedArraySuccessListener success, Response.ErrorListener errorListener) {
        Properties properties = new Properties();
        properties.put("name", user.getFullName());
        properties.put("email", user.getEmail());
        properties.put("platform", "android");
        properties.put("userid", user.getUserId());
        properties.put("appid", this.app_id);
        properties.put("appkey", this.app_key);
        if (user.getUserSecret() != null) {
            properties.put("secretkey", user.getUserSecret());
        }
        if (pushToken != null) {
            properties.put("pushtoken", pushToken);
        }
        properties.put("text", message);
        properties.put("from", get_updates_from_time.toString());
        properties.put("info", deviceInfo);
        String url = this.getApiUrl().concat("chat/submit");
        TicketPostRequest request = new TicketPostRequest(url, properties, attachments, (Response.Listener<JSONArray>)new InapphelpArrayBaseListener<JSONArray>(success, errorListener){

            public void onResponse(JSONArray updateArray) {
                try {
                    Object[] array = IAHInapphelpGear.this.retrieveTicketUpdateFromArray(updateArray);
                    this.successCallback.onSuccess(array);
                }
                catch (JSONException e) {
                    this.errorListener.onErrorResponse(new VolleyError("Fail to parse JSON"));
                }
            }
        }, errorListener);
        request.setTag(cancelTag);
        queue.add((Request)request);
        queue.start();
    }

    public String getApiUrl() {
        return "http://" + this.company + ".inapphelp.com/api/";
    }

    private IAHTicketUpdate[] retrieveTicketUpdateFromArray(JSONArray updateArray) throws JSONException {
        ArrayList<IAHTicketUpdate> ticketUpdates = new ArrayList<IAHTicketUpdate>();
        int updateLen = updateArray.length();
        for (int i = 0; i < updateLen; ++i) {
            IAHTicketUpdate update;
            String text;
            Long timestamp;
            JSONObject updateObject = updateArray.getJSONObject(i);
            IAHAttachment[] attachment = null;
            if (!updateObject.isNull("a") && !updateObject.isNull("am")) {
                attachment = new IAHAttachment[]{IAHAttachment.createAttachment(updateObject.getString("a"), "Attachment", updateObject.getString("am"))};
            }
            if (!updateObject.isNull("s")) {
                timestamp = updateObject.getLong("ts");
                text = updateObject.getString("t");
                String s = updateObject.getString("s");
                Date date = new Date(timestamp);
                update = IAHTicketUpdate.createUpdateByStaff(timestamp, s, text, date, attachment);
            } else {
                timestamp = updateObject.getLong("ts");
                text = updateObject.getString("t");
                Date date = new Date(timestamp);
                update = IAHTicketUpdate.createUpdateByUser(timestamp, "me", text, date, attachment);
            }
            if (update == null) continue;
            ticketUpdates.add(update);
        }
        IAHTicketUpdate[] array = new IAHTicketUpdate[]{};
        array = ticketUpdates.toArray(array);
        return array;
    }

    private IAHKBItem[] retrieveArticlesFromArray(JSONArray articlesObject) throws JSONException {
        ArrayList<IAHKBItem> kbArticleArray = new ArrayList<IAHKBItem>();
        for (int j = 0; j < articlesObject.length(); ++j) {
            JSONObject arrayObject = articlesObject.getJSONObject(j);
            IAHKBItem item = IAHKBItem.createForArticle(arrayObject.getString("_id"), arrayObject.getString("title").trim(), arrayObject.getString("text"));
            kbArticleArray.add(item);
        }
        IAHKBItem[] array = new IAHKBItem[]{};
        array = kbArticleArray.toArray(array);
        return array;
    }

    private class TicketPostRequest
    extends Request<JSONArray> {
        protected static final int TIMEOUT_MS = 30000;
        protected static final int MAX_RETRIES = 3;
        protected static final float BACKOFF_MULT = 1.0f;
        private Response.Listener<JSONArray> mListener;
        private MultipartEntity entity;

        public TicketPostRequest(String url, Properties requestProperties, IAHUploadAttachment[] attachments_to_upload, Response.Listener<JSONArray> listener, Response.ErrorListener errorListener) {
            super(1, url, errorListener);
            this.mListener = listener;
            this.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 3, 1.0f));
            this.entity = new MultipartEntity(HttpMultipartMode.STRICT, null, Charset.forName("UTF-8"));
            Enumeration<Object> enumKey = requestProperties.keys();
            while (enumKey.hasMoreElements()) {
                String key = (String)enumKey.nextElement();
                if (key.equals("info")) {
                    Map[] val;
                    int count = 0;
                    for (Map info : val = (Map[])requestProperties.get(key)) {
                        for (Map.Entry entry : info.entrySet()) {
                            String infoKey = (String)entry.getKey();
                            String infoValue = (String)entry.getValue();
                            try {
                                this.entity.addPart(key + "[" + count + "][" + infoKey + "]", (ContentBody)new StringBody(infoValue));
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        }
                        ++count;
                    }
                    continue;
                }
                String val = requestProperties.getProperty(key);
                try {
                    this.entity.addPart(key, (ContentBody)new StringBody(val, Charset.forName("UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if (attachments_to_upload != null) {
                for (int i = 0; i < attachments_to_upload.length; ++i) {
                    try {
                        this.entity.addPart("attachments", (ContentBody)attachments_to_upload[i].generateStreamToUpload());
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        Log.e((String)TAG, (String)"Attachment upload failed");
                        e.printStackTrace();
                    }
                }
            }
        }

        public String getBodyContentType() {
            if (this.entity == null) {
                return super.getBodyContentType();
            }
            return this.entity.getContentType().getValue();
        }

        public byte[] getBody() throws AuthFailureError {
            if (this.entity == null) {
                return super.getBody();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                this.entity.writeTo((OutputStream)bos);
            }
            catch (IOException e) {
                VolleyLog.e((String)"IOException writing to ByteArrayOutputStream", (Object[])new Object[0]);
            }
            return bos.toByteArray();
        }

        protected void deliverResponse(JSONArray response) {
            this.mListener.onResponse((Object)response);
        }

        protected Response<JSONArray> parseNetworkResponse(NetworkResponse response) {
            try {
                String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
                return Response.success((Object)new JSONArray(jsonString), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            }
            catch (UnsupportedEncodingException e) {
                return Response.error((VolleyError)new ParseError((Throwable)e));
            }
            catch (JSONException je) {
                return Response.error((VolleyError)new ParseError((Throwable)je));
            }
        }
    }

    private class QueryString {
        private StringBuilder builder = new StringBuilder();

        private QueryString() {
        }

        public void addToUri(String name, String property) {
            if (this.builder.length() > 0) {
                this.builder.append("&");
            }
            this.builder.append(name).append("=").append(URLEncoder.encode(property));
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    private abstract class CreateNewTicketSuccessListener<T>
    implements Response.Listener<T> {
        protected OnNewTicketFetchedSuccessListener successListener;
        protected Response.ErrorListener errorListener;

        public CreateNewTicketSuccessListener(OnNewTicketFetchedSuccessListener successListener, Response.ErrorListener errorListener) {
            this.successListener = successListener;
            this.errorListener = errorListener;
        }
    }

    private abstract class InapphelpBaseListner<T>
    implements Response.Listener<T> {
        protected OnFetchedSuccessListener successCallback;
        protected Response.ErrorListener errorListener;

        public InapphelpBaseListner(OnFetchedSuccessListener success, Response.ErrorListener errorListener) {
            this.successCallback = success;
            this.errorListener = errorListener;
        }
    }

    private abstract class InapphelpArrayBaseListener<T>
    implements Response.Listener<T> {
        protected OnFetchedArraySuccessListener successCallback;
        protected Response.ErrorListener errorListener;

        public InapphelpArrayBaseListener(OnFetchedArraySuccessListener success, Response.ErrorListener errorListener) {
            this.successCallback = success;
            this.errorListener = errorListener;
        }
    }
}

