/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.helper;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import java.util.ArrayList;

public abstract class IAHBaseExpandableListAdapter
extends BaseExpandableListAdapter {
    ArrayList<Object> childrens = new ArrayList();
    SparseArray<Parent> groups = new SparseArray();
    protected final LayoutInflater mLayoutInflater;
    protected final Context context;
    protected OnChildItemClickListener childlistener;
    protected OnParentItemClickListener parentlistener;

    public IAHBaseExpandableListAdapter(Context context) {
        this.context = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    public void clearAll() {
        this.childrens.clear();
        this.groups.clear();
    }

    public void clearParent(int parentId) {
        if (this.groups.get(parentId) != null) {
            ((Parent)this.groups.get((int)parentId)).childs.clear();
        }
    }

    public void addParent(int parentId, Object parent) {
        assert (parent != null);
        Parent parentholder = new Parent();
        parentholder.id = parentId;
        parentholder.parent = parent;
        this.groups.put(parentId, (Object)parentholder);
    }

    public void addChild(int parentId, Object child) {
        this.childrens.add(child);
        int pos = this.childrens.indexOf(child);
        ((Parent)this.groups.get((int)parentId)).childs.add(pos);
    }

    public void addChildAll(int parentId, ArrayList child) {
        for (Object object : child) {
            this.addChild(parentId, object);
        }
    }

    public Object getChild(int groupPosition, int childPosition) {
        int childPos = ((Parent)this.groups.valueAt((int)groupPosition)).childs.get(childPosition);
        return this.childrens.get(childPos);
    }

    public long getChildId(int groupPosition, int childPosition) {
        int childPos = ((Parent)this.groups.valueAt((int)groupPosition)).childs.get(childPosition);
        return childPos;
    }

    public abstract View getChildView(int var1, int var2, boolean var3, View var4, ViewGroup var5);

    public int getChildrenCount(int groupPosition) {
        Parent mParent = (Parent)this.groups.valueAt(groupPosition);
        if (mParent == null) {
            return 0;
        }
        return mParent.childs.size();
    }

    public Object getGroup(int groupPosition) {
        return ((Parent)this.groups.valueAt((int)groupPosition)).parent;
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getParentId(int groupPosition) {
        return ((Parent)this.groups.valueAt((int)groupPosition)).id;
    }

    public abstract View getGroupView(int var1, boolean var2, View var3, ViewGroup var4);

    public boolean hasStableIds() {
        return true;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    protected void sendChildClickEvent(int groupPosition, int childPosition, String type, Object map) {
        if (this.childlistener != null) {
            this.childlistener.onChildListItemClick(groupPosition, childPosition, type, map);
        }
    }

    protected void sendParentItemClickEvent(int groupPosition, String type, Object obj) {
        if (this.parentlistener != null) {
            this.parentlistener.onParentItemClicked(groupPosition, type, obj);
        }
    }

    protected boolean sendChildLongClickEvent(int groupPosition, int childPosition, String type, Object map) {
        if (this.childlistener != null) {
            return this.childlistener.onChildListItemLongClick(groupPosition, childPosition, type, map);
        }
        return false;
    }

    protected void sendChildCheckedEvent(int groupPosition, int childPosition, String type, Object map, boolean checked) {
        if (this.childlistener != null) {
            this.childlistener.onChildCheckedListner(groupPosition, childPosition, type, map, checked);
        }
    }

    public void setOnChildItemClickListener(OnChildItemClickListener listener) {
        this.childlistener = listener;
    }

    public void setOnParentItemClickListener(OnParentItemClickListener listener) {
        this.parentlistener = listener;
    }

    public static interface OnParentItemClickListener {
        public void onParentItemClicked(int var1, String var2, Object var3);
    }

    public static interface OnChildItemClickListener {
        public void onChildListItemClick(int var1, int var2, String var3, Object var4);

        public void onChildCheckedListner(int var1, int var2, String var3, Object var4, boolean var5);

        public boolean onChildListItemLongClick(int var1, int var2, String var3, Object var4);
    }

    class Parent {
        int id;
        Object parent;
        ArrayList<Integer> childs = new ArrayList();

        Parent() {
        }
    }
}

