/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.logic;

import android.content.Context;
import android.content.res.XmlResourceParser;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParserException;
import ru.appsm.inapphelp.model.IAHKBItem;

public class IAHArticleReader {
    private int articleResourceId;

    public IAHArticleReader(int articlesResourceId) {
        this.articleResourceId = articlesResourceId;
    }

    public IAHKBItem[] readArticlesFromResource(Context context) throws XmlPullParserException, IOException {
        ArrayList<IAHKBItem> articles = new ArrayList<IAHKBItem>();
        XmlResourceParser xpp = context.getResources().getXml(this.articleResourceId);
        while (xpp.getEventType() != 1) {
            if (xpp.getEventType() == 2 && xpp.getName().equals("article")) {
                int attributeCount = xpp.getAttributeCount();
                String subject = null;
                String text = null;
                for (int i = 0; i < attributeCount; ++i) {
                    String attrName = xpp.getAttributeName(i);
                    if (attrName.equals("subject")) {
                        subject = xpp.getAttributeValue(i);
                    }
                    if (!attrName.equals("text")) continue;
                    text = xpp.getAttributeValue(i);
                }
                assert (subject != null) : "Subject was not specified in xml for article @ index " + articles.size() + 1;
                assert (text != null) : "Text was not specified in xml for article @ index " + articles.size() + 1;
                articles.add(new IAHKBItem(null, subject, text));
            }
            xpp.next();
        }
        IAHKBItem[] articleArray = new IAHKBItem[]{};
        articleArray = articles.toArray(articleArray);
        return articleArray;
    }
}

