/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.logic;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;
import ru.appsm.inapphelp.IAHHelpDesk;
import ru.appsm.inapphelp.activities.IAHActivityManager;
import ru.appsm.inapphelp.fragments.IAHFragmentParent;
import ru.appsm.inapphelp.logic.IAHArticleReader;
import ru.appsm.inapphelp.logic.IAHGear;
import ru.appsm.inapphelp.logic.OnFetchedArraySuccessListener;
import ru.appsm.inapphelp.logic.OnFetchedSuccessListener;
import ru.appsm.inapphelp.logic.OnNewTicketFetchedSuccessListener;
import ru.appsm.inapphelp.model.IAHAttachment;
import ru.appsm.inapphelp.model.IAHCachedUser;
import ru.appsm.inapphelp.model.IAHDraft;
import ru.appsm.inapphelp.model.IAHKBItem;
import ru.appsm.inapphelp.model.IAHUploadAttachment;
import ru.appsm.inapphelp.model.IAHUser;

public class IAHSource {
    private static final String TAG = IAHSource.class.getSimpleName();
    private static final String HELPSTACK_DIRECTORY = "helpstack";
    private static final String HELPSTACK_TICKETS_FILE_NAME = "tickets";
    private static final String HELPSTACK_TICKETS_USER_DATA = "user_credential";
    private static final String HELPSTACK_DRAFT = "draft";
    private static IAHSource singletonInstance = null;
    private IAHGear gear;
    private Context mContext;
    private RequestQueue mRequestQueue;
    private String user_id;
    private String user_secret;
    private IAHCachedUser cachedUser;
    private IAHDraft draftObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static IAHSource getInstance(Context context) {
        if (singletonInstance == null) {
            Class<IAHSource> clazz = IAHSource.class;
            // MONITORENTER : ru.appsm.inapphelp.logic.IAHSource.class
            if (singletonInstance == null) {
                Log.d((String)TAG, (String)"New Instance");
                singletonInstance = new IAHSource(context.getApplicationContext());
            }
            // MONITOREXIT : clazz
        }
        singletonInstance.setGear(IAHHelpDesk.getInstance().getGear());
        return singletonInstance;
    }

    private IAHSource(Context context) {
        this.mContext = context;
        this.user_id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        this.user_secret = null;
        this.setGear(IAHHelpDesk.getInstance().getGear());
        this.mRequestQueue = IAHHelpDesk.getInstance().getRequestQueue();
        this.refreshFieldsFromCache();
    }

    public void setUserId(String user_id) {
        this.user_id = user_id;
        if (!(this.cachedUser.getUser() == null || this.cachedUser.getUser().getUserId() != null && this.cachedUser.getUser().getUserId().equals(user_id))) {
            this.doSaveNewUserPropertiesForGearInCache(null);
        }
    }

    public void setUserSecret(String user_secret) {
        this.user_secret = user_secret;
        if (!(this.cachedUser.getUser() == null || this.cachedUser.getUser().getUserSecret() != null && this.cachedUser.getUser().getUserSecret().equals(user_secret))) {
            this.doSaveNewUserPropertiesForGearInCache(null);
        }
    }

    public void requestKBArticle(String cancelTag, IAHKBItem section, OnFetchedArraySuccessListener success, Response.ErrorListener errorListener) {
        if (this.gear.haveImplementedKBFetching()) {
            this.gear.fetchKBArticle(cancelTag, section, this.mRequestQueue, new SuccessWrapper(success){

                @Override
                public void onSuccess(Object[] successObject) {
                    assert (successObject != null) : "It seems requestKBArticle was not implemented in gear";
                    super.onSuccess(successObject);
                }
            }, new ErrorWrapper("Fetching KB articles", errorListener));
        } else {
            try {
                IAHArticleReader reader = new IAHArticleReader(this.gear.getLocalArticleResourceId());
                success.onSuccess(reader.readArticlesFromResource(this.mContext));
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
                IAHSource.throwError(errorListener, "Unable to parse local article XML");
            }
            catch (IOException e) {
                e.printStackTrace();
                IAHSource.throwError(errorListener, "Unable to read local article XML");
            }
        }
    }

    public void checkForUserDetailsValidity(String cancelTag, String firstName, String lastName, String email, OnFetchedSuccessListener success, Response.ErrorListener errorListener) {
        this.gear.registerNewUser(cancelTag, firstName, lastName, email, this.user_id, this.user_secret, this.mRequestQueue, success, new ErrorWrapper("Registering New User", errorListener));
    }

    public void createNewTicket(String cancelTag, IAHUser user, String message, IAHAttachment[] attachments, OnNewTicketFetchedSuccessListener successListener, Response.ErrorListener errorListener) {
        this.gear.addReplyOnATicket(cancelTag, message, IAHSource.getDeviceInformation(this.mContext), this.convertAttachmentArrayToUploadAttachment(attachments), this.cachedUser.getToken(), 0L, user, this.mRequestQueue, new OnFetchedArraySuccessListenerWrapper(successListener, "Creating New Ticket", attachments), new ErrorWrapper("Creating New Ticket", errorListener));
    }

    public void requestUpdatesOnTicket(String cancelTag, Long from_time, IAHUser user, OnFetchedArraySuccessListener success, Response.ErrorListener errorListener) {
        this.gear.fetchUpdateOnTicket(cancelTag, from_time, user, this.mRequestQueue, success, new ErrorWrapper("Fetching updates on Ticket", errorListener));
    }

    public void addReplyOnATicket(String cancelTag, String message, IAHAttachment[] attachments, Long get_updates_from_time, IAHUser user, OnFetchedArraySuccessListener success, Response.ErrorListener errorListener) {
        this.gear.addReplyOnATicket(cancelTag, message, IAHSource.getDeviceInformation(this.mContext), this.convertAttachmentArrayToUploadAttachment(attachments), this.cachedUser.getToken(), get_updates_from_time, user, this.mRequestQueue, success, new ErrorWrapper("Adding reply to a ticket", errorListener));
    }

    public IAHGear getGear() {
        return this.gear;
    }

    private void setGear(IAHGear gear) {
        this.gear = gear;
    }

    public boolean isNewUser() {
        return this.cachedUser.getUser() == null || this.cachedUser.getUser().getUserId() == null || this.cachedUser.getUser().getEmail() == null || this.cachedUser.getUser().getFirstName() == null || this.cachedUser.getUser().getLastName() == null;
    }

    public void refreshUser() {
        this.doReadUserFromCache();
    }

    public IAHUser getUser() {
        return this.cachedUser.getUser();
    }

    public String getPushToken() {
        return this.cachedUser.getToken();
    }

    public void setPushToken(String push_token) {
        this.cachedUser.setToken(push_token);
        this.doSaveNewUserPropertiesForGearInCache(this.cachedUser.getUser());
    }

    public String getDraftMessage() {
        if (this.draftObject != null) {
            return this.draftObject.getMessage();
        }
        return null;
    }

    public IAHUser getDraftUser() {
        if (this.draftObject != null) {
            return this.draftObject.getDraftUser();
        }
        return null;
    }

    public IAHAttachment[] getDraftAttachments() {
        if (this.draftObject != null) {
            return this.draftObject.getAttachments();
        }
        return null;
    }

    public String getDraftReplyMessage() {
        if (this.draftObject != null) {
            return this.draftObject.getDraftReplyMessage();
        }
        return null;
    }

    public IAHAttachment[] getDraftReplyAttachments() {
        if (this.draftObject != null) {
            return this.draftObject.getDraftReplyAttachments();
        }
        return null;
    }

    public void saveTicketDetailsInDraft(String message, IAHAttachment[] attachmentsArray) {
        this.doSaveTicketDraftForGearInCache(message, attachmentsArray);
    }

    public void saveUserDetailsInDraft(IAHUser user) {
        this.doSaveUserDraftForGearInCache(user);
    }

    public void saveReplyDetailsInDraft(String message, IAHAttachment[] attachmentsArray) {
        this.doSaveReplyDraftForGearInCache(message, attachmentsArray);
    }

    public void launchCreateNewTicketScreen(IAHFragmentParent fragment, int requestCode) {
        if (this.isNewUser()) {
            IAHActivityManager.startNewIssueActivity(fragment, null, requestCode);
        } else {
            IAHActivityManager.startIssueDetailActivity((Activity)fragment.getActivity(), this.getUser());
        }
    }

    private static Map<String, String>[] getDeviceInformation(Context activity) {
        ArrayList deviceInfo = new ArrayList();
        HashMap<String, String> appId = new HashMap<String, String>();
        appId.put("k", "Application id");
        try {
            appId.put("v", activity.getPackageManager().getPackageInfo((String)activity.getPackageName(), (int)0).packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            appId.put("v", "Unknown");
        }
        appId.put("t", "Application");
        deviceInfo.add(appId);
        HashMap<String, String> appV = new HashMap<String, String>();
        appV.put("k", "Application version");
        appV.put("t", "Application");
        try {
            String versionName = activity.getPackageManager().getPackageInfo((String)activity.getPackageName(), (int)0).versionName;
            appV.put("v", versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            appV.put("v", "Unknown");
        }
        deviceInfo.add(appV);
        HashMap<String, String> device = new HashMap<String, String>();
        device.put("k", "Device");
        device.put("v", Build.DEVICE);
        device.put("t", "Device");
        deviceInfo.add(device);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("k", "Model");
        model.put("v", Build.MODEL + " (" + Build.PRODUCT + ")");
        model.put("t", "Device");
        deviceInfo.add(model);
        HashMap<String, String> OS = new HashMap<String, String>();
        OS.put("k", "OS");
        OS.put("v", System.getProperty("os.version") + "(" + Build.VERSION.INCREMENTAL + ")");
        OS.put("t", "Device");
        deviceInfo.add(OS);
        HashMap<String, String> language = new HashMap<String, String>();
        language.put("k", "Language");
        language.put("v", Locale.getDefault().getLanguage());
        language.put("t", "Device");
        deviceInfo.add(language);
        HashMap network = new HashMap();
        language.put("k", "Network");
        language.put("v", IAHSource.getNetworkClass(activity));
        language.put("t", "Device");
        deviceInfo.add(network);
        Map<K, V>[] array = new HashMap[deviceInfo.size()];
        array = deviceInfo.toArray(array);
        return array;
    }

    public static String getNetworkClass(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info == null || !info.isConnected()) {
            return "-";
        }
        if (info.getType() == 1) {
            return "WiFi";
        }
        if (info.getType() == 0) {
            int networkType = info.getSubtype();
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
            }
            return "Unknown";
        }
        return "Unknown";
    }

    public void cancelOperation(String cancelTag) {
        this.mRequestQueue.cancelAll((Object)cancelTag);
    }

    public void refreshFieldsFromCache() {
        this.doReadUserFromCache();
        this.doReadDraftFromCache();
    }

    private String readJsonFromFile(File file) {
        if (!file.exists()) {
            return null;
        }
        String json = null;
        try {
            StringBuilder datax = new StringBuilder();
            FileInputStream inputStream = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader(inputStream);
            BufferedReader buffreader = new BufferedReader(isr);
            String readString = buffreader.readLine();
            while (readString != null) {
                datax.append(readString);
                readString = buffreader.readLine();
            }
            isr.close();
            json = datax.toString();
            return json;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void writeJsonIntoFile(File file, String json) {
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            outputStream.write(json.getBytes());
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveNewUserPropertiesForGearInCache(IAHUser user) {
        this.cachedUser.setUser(user);
        Gson gson = new Gson();
        String userjson = gson.toJson((Object)this.cachedUser);
        File userFile = new File(this.getProjectDirectory(), HELPSTACK_TICKETS_USER_DATA);
        this.writeJsonIntoFile(userFile, userjson);
    }

    protected void doReadUserFromCache() {
        File userFile = new File(this.getProjectDirectory(), HELPSTACK_TICKETS_USER_DATA);
        String json = this.readJsonFromFile(userFile);
        if (json == null) {
            this.cachedUser = new IAHCachedUser();
        } else {
            Gson gson = new Gson();
            this.cachedUser = (IAHCachedUser)gson.fromJson(json, IAHCachedUser.class);
        }
    }

    protected void doReadDraftFromCache() {
        File draftFile = new File(this.getProjectDirectory(), HELPSTACK_DRAFT);
        String json = this.readJsonFromFile(draftFile);
        if (json == null) {
            this.draftObject = new IAHDraft();
        } else {
            Gson gson = new Gson();
            this.draftObject = (IAHDraft)gson.fromJson(json, IAHDraft.class);
        }
    }

    protected void doSaveTicketDraftForGearInCache(String message, IAHAttachment[] attachmentsArray) {
        this.draftObject.setDraftMessage(message);
        this.draftObject.setDraftAttachments(attachmentsArray);
        this.writeDraftIntoFile();
    }

    protected void doSaveUserDraftForGearInCache(IAHUser user) {
        this.draftObject.setDraftUSer(user);
        this.writeDraftIntoFile();
    }

    protected void doSaveReplyDraftForGearInCache(String message, IAHAttachment[] attachmentsArray) {
        this.draftObject.setDraftReplyMessage(message);
        this.draftObject.setDraftReplyAttachments(attachmentsArray);
        this.writeDraftIntoFile();
    }

    private void writeDraftIntoFile() {
        Gson gson = new Gson();
        String draftJson = gson.toJson((Object)this.draftObject);
        File draftFile = new File(this.getProjectDirectory(), HELPSTACK_DRAFT);
        this.writeJsonIntoFile(draftFile, draftJson);
    }

    protected File getProjectDirectory() {
        File projDir = new File(this.mContext.getFilesDir(), HELPSTACK_DIRECTORY);
        if (!projDir.exists()) {
            projDir.mkdirs();
        }
        return projDir;
    }

    public void clearTicketDraft() {
        this.saveTicketDetailsInDraft("", null);
    }

    public void clearReplyDraft() {
        this.saveReplyDetailsInDraft("", null);
    }

    protected IAHUploadAttachment[] convertAttachmentArrayToUploadAttachment(IAHAttachment[] attachment) {
        IAHUploadAttachment[] upload_attachments = new IAHUploadAttachment[]{};
        if (attachment != null && attachment.length > 0) {
            int attachmentCount = this.gear.getNumberOfAttachmentGearCanHandle();
            assert (attachmentCount >= attachment.length) : "Gear cannot handle more than " + attachmentCount + " attachmnets";
            upload_attachments = new IAHUploadAttachment[attachment.length];
            for (int i = 0; i < upload_attachments.length; ++i) {
                upload_attachments[i] = new IAHUploadAttachment(this.mContext, attachment[i]);
            }
        }
        return upload_attachments;
    }

    public static void throwError(Response.ErrorListener errorListener, String error) {
        VolleyError volleyError = new VolleyError(error);
        IAHSource.printErrorDescription(null, volleyError);
        errorListener.onErrorResponse(volleyError);
    }

    private static void printErrorDescription(String methodName, VolleyError error) {
        if (methodName == null) {
            Log.e((String)IAHHelpDesk.LOG_TAG, (String)"Error occurred in HelpStack");
        } else {
            Log.e((String)IAHHelpDesk.LOG_TAG, (String)("Error occurred when executing " + methodName));
        }
        Log.e((String)IAHHelpDesk.LOG_TAG, (String)error.toString());
        if (error.getMessage() != null) {
            Log.e((String)IAHHelpDesk.LOG_TAG, (String)error.getMessage());
        }
        if (error.networkResponse != null && error.networkResponse.data != null) {
            try {
                Log.e((String)IAHHelpDesk.LOG_TAG, (String)new String(error.networkResponse.data, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        error.printStackTrace();
    }

    private class ErrorWrapper
    implements Response.ErrorListener {
        private Response.ErrorListener errorListener;
        private String methodName;

        public ErrorWrapper(String methodName, Response.ErrorListener errorListener) {
            this.errorListener = errorListener;
            this.methodName = methodName;
        }

        public void onErrorResponse(VolleyError error) {
            IAHSource.printErrorDescription(this.methodName, error);
            this.errorListener.onErrorResponse(error);
        }
    }

    private class OnFetchedArraySuccessListenerWrapper
    implements OnFetchedArraySuccessListener {
        private OnNewTicketFetchedSuccessListener listener;
        protected String message;
        protected IAHAttachment[] attachments;

        private OnFetchedArraySuccessListenerWrapper(OnNewTicketFetchedSuccessListener listener, String message, IAHAttachment[] attachments) {
            this.listener = listener;
            this.message = message;
            this.attachments = attachments;
        }

        @Override
        public void onSuccess(Object[] successObject) {
            if (this.listener != null) {
                this.listener.onSuccess();
            }
        }
    }

    private class SuccessWrapper
    implements OnFetchedArraySuccessListener {
        private OnFetchedArraySuccessListener lastListner;

        public SuccessWrapper(OnFetchedArraySuccessListener lastListner) {
            this.lastListner = lastListner;
        }

        @Override
        public void onSuccess(Object[] successObject) {
            if (this.lastListner != null) {
                this.lastListner.onSuccess(successObject);
            }
        }
    }

    private class NewTicketSuccessWrapper
    implements OnNewTicketFetchedSuccessListener {
        private OnNewTicketFetchedSuccessListener lastListner;

        public NewTicketSuccessWrapper(OnNewTicketFetchedSuccessListener lastListner) {
            this.lastListner = lastListner;
        }

        @Override
        public void onSuccess() {
            if (this.lastListner != null) {
                this.lastListner.onSuccess();
            }
        }
    }
}

