/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.logic;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class IAHUtils {
    private static final long TIME_MILLIS = 1000L;
    private static final long TIME_MINUTE = 60000L;
    private static final long TIME_HOUR = 3600000L;
    private static final long TIME_DAY = 86400000L;
    public static final String DATE_PATTERN_SHORT = "yyyy-MM-dd";
    public static final String DATE_PATTERN_MEDIUM = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_PATTERN_USER_DISPLAY_SHORT = "dd-MMM, yyyy";

    public static String convertToHumanReadableTime(Date givenDate, long currentTimeLong) {
        Calendar currentTime = Calendar.getInstance();
        currentTime.setTimeZone(TimeZone.getTimeZone("UTC"));
        currentTime.setTimeInMillis(currentTimeLong);
        Calendar givenTime = Calendar.getInstance();
        givenTime.setTimeZone(TimeZone.getTimeZone("UTC"));
        givenTime.setTime(givenDate);
        long timeDiff = currentTime.getTimeInMillis() - givenTime.getTimeInMillis();
        if (timeDiff <= 0L) {
            return "Now";
        }
        String humanString = null;
        if (timeDiff / 86400000L >= 1L) {
            int day = (int)(timeDiff / 86400000L);
            humanString = String.format(Locale.getDefault(), "%dd", day);
        } else {
            humanString = timeDiff / 3600000L >= 1L ? String.format(Locale.getDefault(), "%dh", timeDiff / 3600000L) : (timeDiff / 60000L >= 1L ? String.format(Locale.getDefault(), "%dm", timeDiff / 60000L) : String.format(Locale.getDefault(), "%ds", timeDiff / 1000L));
        }
        return humanString;
    }

    public static void showAlertDialog(Context context, String title, String message) {
        AlertDialog dialog = new AlertDialog.Builder(context).create();
        dialog.setCancelable(true);
        dialog.setMessage((CharSequence)message);
        dialog.setTitle((CharSequence)title);
        dialog.setButton(-1, (CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        dialog.show();
    }
}

