/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.model;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Date;
import ru.appsm.inapphelp.model.IAHAttachment;

public class IAHTicketUpdate
implements Serializable {
    public static final int TYPE_STAFF = 0;
    public static final int TYPE_USER = 1;
    @SerializedName(value="update_id")
    private Long updateId;
    @SerializedName(value="text")
    private String text;
    @SerializedName(value="update_by")
    private int updateBy;
    @SerializedName(value="update_time")
    private Date updateTime;
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="attachments")
    private IAHAttachment[] attachments;

    public static IAHTicketUpdate createUpdateByStaff(Long updateId, String name, String text, Date update_time, IAHAttachment[] attachments) {
        IAHTicketUpdate update = new IAHTicketUpdate();
        update.updateBy = 0;
        update.text = text;
        update.updateId = updateId;
        update.name = name;
        update.updateTime = update_time;
        update.attachments = attachments;
        return update;
    }

    public static IAHTicketUpdate createUpdateByUser(Long updateId, String name, String text, Date update_time, IAHAttachment[] attachments) {
        IAHTicketUpdate update = new IAHTicketUpdate();
        update.updateBy = 1;
        update.text = text;
        update.updateId = updateId;
        update.name = name;
        update.updateTime = update_time;
        update.attachments = attachments;
        return update;
    }

    public boolean isStaffUpdate() {
        return this.updateBy == 0;
    }

    public boolean isUserUpdate() {
        return this.updateBy == 1;
    }

    public String getText() {
        return this.text;
    }

    public Long getId() {
        return this.updateId;
    }

    public Date getUpdatedTime() {
        return this.updateTime;
    }

    public IAHAttachment[] getAttachments() {
        return this.attachments;
    }

    public boolean isAttachmentEmtpy() {
        if (this.attachments == null) {
            return true;
        }
        return this.attachments.length == 0;
    }
}

