/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.service;

import android.app.DownloadManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import ru.appsm.inapphelp.R;

public class AttachmentDownloadReceiver
extends BroadcastReceiver {
    private static final int NOTIFICATION_ID = 1008;
    private static final int PENDING_INTENT_REQUEST_CODE = 108;

    public void onReceive(Context context, Intent intent) {
        String cpackage;
        String action = intent.getAction();
        String package_name = intent.getPackage();
        if (package_name.equals(cpackage = context.getPackageName()) && "android.intent.action.DOWNLOAD_COMPLETE".equals(action)) {
            this.downloadCompleted(context, intent);
        } else if (package_name.equals(cpackage) && "android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED".equals(action)) {
            this.notificationClicked(context, intent);
        }
    }

    private void notificationClicked(Context context, Intent intent) {
        Intent i = new Intent("android.intent.action.VIEW_DOWNLOADS");
        i.setFlags(0x10000000);
        context.startActivity(i);
    }

    private void downloadCompleted(Context context, Intent intent) {
        StringBuilder text = new StringBuilder();
        String filename = context.getString(R.string.iah_attachment);
        String filepath = null;
        String mediaType = null;
        DownloadManager dm = (DownloadManager)context.getSystemService("download");
        long downloadId = intent.getLongExtra("extra_download_id", 0L);
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{downloadId});
        Cursor c = dm.query(query);
        if (c.moveToFirst()) {
            int status = c.getInt(c.getColumnIndex("status"));
            filename = c.getString(c.getColumnIndex("title"));
            filepath = c.getString(c.getColumnIndex("local_uri"));
            mediaType = c.getString(c.getColumnIndex("media_type"));
            if (status == 8) {
                text.append(context.getString(R.string.iah_download_complete));
            } else {
                text.append(context.getString(R.string.iah_error_during_download));
            }
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        NotificationCompat.Builder notificationbuilder = new NotificationCompat.Builder(context);
        notificationbuilder.setAutoCancel(true);
        notificationbuilder.setContentText((CharSequence)text.toString());
        notificationbuilder.setContentTitle((CharSequence)filename);
        notificationbuilder.setSmallIcon(R.drawable.iah_notification_download_light_img);
        notificationbuilder.setDefaults(3);
        notificationbuilder.setContentIntent(this.getPendingIntent(context));
        notificationManager.notify(filename, 1008, notificationbuilder.build());
    }

    public PendingIntent getPendingIntent(Context context, String filename, String mediatype) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setDataAndType(Uri.parse((String)filename), mediatype);
        i.setFlags(0x10000000);
        PendingIntent pendinIntent = PendingIntent.getActivity((Context)context, (int)108, (Intent)Intent.createChooser((Intent)i, (CharSequence)context.getString(R.string.iah_open_with)), (int)0x8000000);
        return pendinIntent;
    }

    public PendingIntent getPendingIntent(Context context) {
        Intent i = new Intent("android.intent.action.VIEW_DOWNLOADS");
        i.setFlags(0x10000000);
        PendingIntent pendinIntent = PendingIntent.getActivity((Context)context, (int)108, (Intent)i, (int)0x8000000);
        return pendinIntent;
    }
}

