/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.exfilepicker;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import java.io.Serializable;
import ru.bartwell.exfilepicker.ui.activity.ExFilePickerActivity;

public class ExFilePicker {
    public static final String EXTRA_RESULT = "RESULT";
    private boolean mCanChooseOnlyOneItem;
    @Nullable
    private String[] mShowOnlyExtensions;
    @Nullable
    private String[] mExceptExtensions;
    private boolean mIsNewFolderButtonDisabled;
    private boolean mIsSortButtonDisabled;
    private boolean mIsQuitButtonEnabled;
    @NonNull
    private ChoiceType mChoiceType = ChoiceType.ALL;
    @NonNull
    private SortingType mSortingType = SortingType.NAME_ASC;
    @Nullable
    private String mStartDirectory;
    private boolean mUseFirstItemAsUpEnabled;
    private boolean mHideHiddenFilesEnabled;

    public void setCanChooseOnlyOneItem(boolean canChooseOnlyOneItem) {
        this.mCanChooseOnlyOneItem = canChooseOnlyOneItem;
    }

    public void setShowOnlyExtensions(String ... extension) {
        this.mShowOnlyExtensions = extension;
    }

    public void setExceptExtensions(String ... extension) {
        this.mExceptExtensions = extension;
    }

    public void setNewFolderButtonDisabled(boolean disabled) {
        this.mIsNewFolderButtonDisabled = disabled;
    }

    public void setSortButtonDisabled(boolean disabled) {
        this.mIsSortButtonDisabled = disabled;
    }

    public void setQuitButtonEnabled(boolean enabled) {
        this.mIsQuitButtonEnabled = enabled;
    }

    public void setChoiceType(@NonNull ChoiceType choiceType) {
        this.mChoiceType = choiceType;
    }

    public void setSortingType(@NonNull SortingType sortingType) {
        this.mSortingType = sortingType;
    }

    public void setStartDirectory(@Nullable String startDirectory) {
        this.mStartDirectory = startDirectory;
    }

    public void setUseFirstItemAsUpEnabled(boolean enabled) {
        this.mUseFirstItemAsUpEnabled = enabled;
    }

    public void setHideHiddenFilesEnabled(boolean enabled) {
        this.mHideHiddenFilesEnabled = enabled;
    }

    public void start(@NonNull Activity activity, int requestCode) {
        activity.startActivityForResult(this.createIntent((Context)activity), requestCode);
    }

    public void start(@NonNull android.support.v4.app.Fragment fragment, int requestCode) {
        fragment.startActivityForResult(this.createIntent(fragment.getContext()), requestCode);
    }

    @RequiresApi(api=11)
    public void start(@NonNull Fragment fragment, int requestCode) {
        Object context = Build.VERSION.SDK_INT >= 23 ? fragment.getContext() : fragment.getActivity();
        fragment.startActivityForResult(this.createIntent((Context)context), requestCode);
    }

    @NonNull
    private Intent createIntent(@NonNull Context context) {
        Intent intent = new Intent(context, ExFilePickerActivity.class);
        intent.putExtra("CAN_CHOOSE_ONLY_ONE_ITEM", this.mCanChooseOnlyOneItem);
        intent.putExtra("SHOW_ONLY_EXTENSIONS", this.mShowOnlyExtensions);
        intent.putExtra("EXCEPT_EXTENSIONS", this.mExceptExtensions);
        intent.putExtra("IS_NEW_FOLDER_BUTTON_DISABLED", this.mIsNewFolderButtonDisabled);
        intent.putExtra("IS_SORT_BUTTON_DISABLED", this.mIsSortButtonDisabled);
        intent.putExtra("IS_QUIT_BUTTON_ENABLED", this.mIsQuitButtonEnabled);
        intent.putExtra("CHOICE_TYPE", (Serializable)((Object)this.mChoiceType));
        intent.putExtra("SORTING_TYPE", (Serializable)((Object)this.mSortingType));
        intent.putExtra("START_DIRECTORY", this.mStartDirectory);
        intent.putExtra("USE_FIRST_ITEM_AS_UP_ENABLED", this.mUseFirstItemAsUpEnabled);
        intent.putExtra("HIDE_HIDDEN_FILES", this.mHideHiddenFilesEnabled);
        return intent;
    }

    public static enum SortingType {
        NAME_ASC,
        NAME_DESC,
        SIZE_ASC,
        SIZE_DESC,
        DATE_ASC,
        DATE_DESC;

    }

    public static enum ChoiceType {
        ALL,
        FILES,
        DIRECTORIES;

    }
}

