/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.exfilepicker.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import ru.bartwell.exfilepicker.ExFilePicker;
import ru.bartwell.exfilepicker.R;
import ru.bartwell.exfilepicker.data.ExFilePickerResult;
import ru.bartwell.exfilepicker.ui.adapter.FilesListAdapter;
import ru.bartwell.exfilepicker.ui.callback.OnListItemClickListener;
import ru.bartwell.exfilepicker.ui.dialog.NewFolderDialog;
import ru.bartwell.exfilepicker.ui.dialog.SortingDialog;
import ru.bartwell.exfilepicker.ui.dialog.StorageDialog;
import ru.bartwell.exfilepicker.ui.view.FilesListToolbar;
import ru.bartwell.exfilepicker.utils.ListUtils;
import ru.bartwell.exfilepicker.utils.Utils;

public class ExFilePickerActivity
extends AppCompatActivity
implements OnListItemClickListener,
Toolbar.OnMenuItemClickListener,
View.OnClickListener,
NewFolderDialog.OnNewFolderNameEnteredListener,
SortingDialog.OnSortingSelectedListener,
StorageDialog.OnStorageSelectedListener {
    public static final String EXTRA_CAN_CHOOSE_ONLY_ONE_ITEM = "CAN_CHOOSE_ONLY_ONE_ITEM";
    public static final String EXTRA_SHOW_ONLY_EXTENSIONS = "SHOW_ONLY_EXTENSIONS";
    public static final String EXTRA_EXCEPT_EXTENSIONS = "EXCEPT_EXTENSIONS";
    public static final String EXTRA_IS_NEW_FOLDER_BUTTON_DISABLED = "IS_NEW_FOLDER_BUTTON_DISABLED";
    public static final String EXTRA_IS_SORT_BUTTON_DISABLED = "IS_SORT_BUTTON_DISABLED";
    public static final String EXTRA_IS_QUIT_BUTTON_ENABLED = "IS_QUIT_BUTTON_ENABLED";
    public static final String EXTRA_CHOICE_TYPE = "CHOICE_TYPE";
    public static final String EXTRA_SORTING_TYPE = "SORTING_TYPE";
    public static final String EXTRA_START_DIRECTORY = "START_DIRECTORY";
    public static final String EXTRA_USE_FIRST_ITEM_AS_UP_ENABLED = "USE_FIRST_ITEM_AS_UP_ENABLED";
    public static final String EXTRA_HIDE_HIDDEN_FILES = "HIDE_HIDDEN_FILES";
    public static final String PERMISSION_READ_EXTERNAL_STORAGE = "android.permission.READ_EXTERNAL_STORAGE";
    private static final int REQUEST_CODE_READ_EXTERNAL_STORAGE = 1;
    private static final int REQUEST_CODE_WRITE_EXTERNAL_STORAGE = 2;
    private static final String TOP_DIRECTORY = "/";
    private boolean mCanChooseOnlyOneItem;
    @Nullable
    private String[] mShowOnlyExtensions;
    @Nullable
    private String[] mExceptExtensions;
    private boolean mIsNewFolderButtonDisabled;
    private boolean mIsSortButtonDisabled;
    private boolean mIsQuitButtonEnabled;
    @NonNull
    private ExFilePicker.ChoiceType mChoiceType = ExFilePicker.ChoiceType.ALL;
    @NonNull
    private ExFilePicker.SortingType mSortingType = ExFilePicker.SortingType.NAME_ASC;
    private File mCurrentDirectory;
    private FilesListToolbar mToolbar;
    private RecyclerView mRecyclerView;
    private View mEmptyView;
    private FilesListAdapter mAdapter;
    private boolean mIsMultiChoiceModeEnabled;
    private boolean mUseFirstItemAsUpEnabled;
    private boolean mHideHiddenFiles;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_ex_file_picker);
        this.handleIntent();
        this.setupViews();
        if (ContextCompat.checkSelfPermission((Context)this, (String)PERMISSION_READ_EXTERNAL_STORAGE) == 0) {
            this.readDirectory(this.mCurrentDirectory);
        } else {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{PERMISSION_READ_EXTERNAL_STORAGE}, (int)1);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 1: {
                this.readDirectory(this.mCurrentDirectory);
                break;
            }
            case 2: {
                this.showNewFolderDialog();
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public void onListItemClick(int position) {
        if (this.mIsMultiChoiceModeEnabled) {
            if (this.mCanChooseOnlyOneItem) {
                this.mAdapter.deselect();
            }
            this.mAdapter.setItemSelected(position, !this.mAdapter.isItemSelected(position));
        } else if (position == -1) {
            this.readUpDirectory();
        } else {
            File item = this.mAdapter.getItem(position);
            if (item.isDirectory()) {
                this.mCurrentDirectory = new File(this.mCurrentDirectory, item.getName());
                this.readDirectory(this.mCurrentDirectory);
            } else {
                this.finishWithResult(this.mCurrentDirectory, item.getName());
            }
        }
    }

    @Override
    public void onListItemLongClick(int position) {
        if (!this.mIsMultiChoiceModeEnabled && position != -1) {
            this.mIsMultiChoiceModeEnabled = true;
            if (this.mChoiceType != ExFilePicker.ChoiceType.FILES || !this.mAdapter.getItem(position).isDirectory()) {
                this.mAdapter.setItemSelected(position, true);
            }
            this.setMultiChoiceModeEnabled(true);
        }
    }

    public boolean onMenuItemClick(@NonNull MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.ok) {
            if (this.mIsMultiChoiceModeEnabled) {
                this.finishWithResult(this.mCurrentDirectory, this.mAdapter.getSelectedItems());
            } else if (this.mChoiceType == ExFilePicker.ChoiceType.DIRECTORIES) {
                if (this.isTopDirectory(this.mCurrentDirectory)) {
                    this.finishWithResult(this.mCurrentDirectory, TOP_DIRECTORY);
                } else {
                    this.finishWithResult(this.mCurrentDirectory.getParentFile(), this.mCurrentDirectory.getName());
                }
            }
        } else if (itemId == R.id.sort) {
            SortingDialog dialog = new SortingDialog((Context)this);
            dialog.setOnSortingSelectedListener(this);
            dialog.show();
        } else if (itemId == R.id.storage) {
            StorageDialog dialog = new StorageDialog((Context)this);
            dialog.setOnStorageSelectedListener(this);
            dialog.show();
        } else if (itemId == R.id.new_folder) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
                this.showNewFolderDialog();
            } else {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)2);
            }
        } else if (itemId == R.id.select_all) {
            this.mAdapter.selectAll();
        } else if (itemId == R.id.deselect) {
            this.mAdapter.deselect();
        } else if (itemId == R.id.invert_selection) {
            this.mAdapter.invertSelection();
        } else if (itemId == R.id.change_view) {
            this.toggleViewMode();
        } else {
            return false;
        }
        return true;
    }

    public void onClick(@NonNull View view) {
        if (this.mIsMultiChoiceModeEnabled) {
            this.setMultiChoiceModeEnabled(false);
            this.setupOkButtonVisibility();
        } else {
            this.finish();
        }
    }

    public boolean dispatchKeyEvent(@NonNull KeyEvent event) {
        if (event.getKeyCode() == 4) {
            if (event.getAction() == 1) {
                if (this.mIsMultiChoiceModeEnabled) {
                    this.setMultiChoiceModeEnabled(false);
                    this.setupOkButtonVisibility();
                } else if (this.isTopDirectory(this.mCurrentDirectory)) {
                    this.finish();
                } else {
                    this.readUpDirectory();
                }
            } else if (event.getAction() == 0 && (event.getFlags() & 0x80) == 128) {
                this.finish();
            }
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    @Override
    public void onNewFolderNameEntered(@NonNull String name) {
        if (name.length() > 0) {
            File file = new File(this.mCurrentDirectory, name);
            if (file.exists()) {
                Toast.makeText((Context)this, (int)R.string.efp__folder_already_exists, (int)0).show();
            } else if (file.mkdir()) {
                this.readDirectory(this.mCurrentDirectory);
                Toast.makeText((Context)this, (int)R.string.efp__folder_created, (int)0).show();
            } else {
                Toast.makeText((Context)this, (int)R.string.efp__folder_not_created, (int)0).show();
            }
        }
    }

    @Override
    public void onSortingSelected(@NonNull ExFilePicker.SortingType sortingType) {
        this.mSortingType = sortingType;
        this.mAdapter.sort(this.mSortingType);
    }

    @Override
    public void onStorageSelected(String path) {
        this.mCurrentDirectory = new File(path);
        this.readDirectory(this.mCurrentDirectory);
    }

    private void readUpDirectory() {
        this.mCurrentDirectory = this.mCurrentDirectory.getParentFile();
        this.readDirectory(this.mCurrentDirectory);
    }

    private void readDirectory(@NonNull File directory) {
        this.setTitle(directory);
        this.mAdapter.setUseFirstItemAsUpEnabled(!this.isTopDirectory(directory) && this.mUseFirstItemAsUpEnabled);
        File[] files = directory.listFiles();
        if (files == null || files.length == 0) {
            if (this.mUseFirstItemAsUpEnabled) {
                this.mRecyclerView.setVisibility(0);
                this.mEmptyView.setVisibility(8);
                this.mAdapter.setItems(new ArrayList<File>(), this.mSortingType);
            } else {
                this.mEmptyView.setVisibility(0);
                this.mRecyclerView.setVisibility(8);
            }
        } else {
            ListUtils.ConditionChecker<File> checker;
            this.mRecyclerView.setVisibility(0);
            this.mEmptyView.setVisibility(8);
            ArrayList<File> list = new ArrayList<File>();
            if (this.mShowOnlyExtensions != null && this.mShowOnlyExtensions.length > 0 && this.mChoiceType != ExFilePicker.ChoiceType.DIRECTORIES) {
                final List<String> showOnlyExtensions = Arrays.asList(this.mShowOnlyExtensions);
                checker = new ListUtils.ConditionChecker<File>(){

                    @Override
                    public boolean check(@NonNull File file) {
                        return file.isDirectory() || showOnlyExtensions.contains(Utils.getFileExtension(file.getName()));
                    }
                };
            } else {
                checker = this.mChoiceType == ExFilePicker.ChoiceType.DIRECTORIES ? new ListUtils.ConditionChecker<File>(){

                    @Override
                    public boolean check(@NonNull File file) {
                        return file.isDirectory();
                    }
                } : null;
            }
            ListUtils.copyListWithCondition(files, list, checker);
            if (this.mExceptExtensions != null && this.mExceptExtensions.length > 0 && this.mChoiceType != ExFilePicker.ChoiceType.DIRECTORIES) {
                final List<String> exceptExtensions = Arrays.asList(this.mExceptExtensions);
                ListUtils.filterList(list, new ListUtils.ConditionChecker<File>(){

                    @Override
                    public boolean check(@NonNull File file) {
                        return !file.isDirectory() && exceptExtensions.contains(Utils.getFileExtension(file.getName()));
                    }
                });
            }
            if (this.mHideHiddenFiles) {
                ListUtils.filterList(list, new ListUtils.ConditionChecker<File>(){

                    @Override
                    public boolean check(@NonNull File file) {
                        return file.isHidden();
                    }
                });
            }
            this.mAdapter.setItems(list, this.mSortingType);
        }
    }

    private void setTitle(@NonNull File directory) {
        if (this.isTopDirectory(directory)) {
            this.mToolbar.setTitle(TOP_DIRECTORY);
        } else {
            this.mToolbar.setTitle(directory.getName());
        }
    }

    private void handleIntent() {
        Intent intent = this.getIntent();
        this.mCanChooseOnlyOneItem = intent.getBooleanExtra(EXTRA_CAN_CHOOSE_ONLY_ONE_ITEM, false);
        this.mShowOnlyExtensions = intent.getStringArrayExtra(EXTRA_SHOW_ONLY_EXTENSIONS);
        this.mExceptExtensions = intent.getStringArrayExtra(EXTRA_EXCEPT_EXTENSIONS);
        this.mIsNewFolderButtonDisabled = intent.getBooleanExtra(EXTRA_IS_NEW_FOLDER_BUTTON_DISABLED, false);
        this.mIsSortButtonDisabled = intent.getBooleanExtra(EXTRA_IS_SORT_BUTTON_DISABLED, false);
        this.mIsQuitButtonEnabled = intent.getBooleanExtra(EXTRA_IS_QUIT_BUTTON_ENABLED, false);
        this.mChoiceType = (ExFilePicker.ChoiceType)((Object)intent.getSerializableExtra(EXTRA_CHOICE_TYPE));
        this.mSortingType = (ExFilePicker.SortingType)((Object)intent.getSerializableExtra(EXTRA_SORTING_TYPE));
        this.mCurrentDirectory = this.getStartDirectory(intent);
        this.mUseFirstItemAsUpEnabled = intent.getBooleanExtra(EXTRA_USE_FIRST_ITEM_AS_UP_ENABLED, false);
        this.mHideHiddenFiles = intent.getBooleanExtra(EXTRA_HIDE_HIDDEN_FILES, false);
    }

    private int calculateGridColumnsCount() {
        return (int)((float)this.getResources().getDisplayMetrics().widthPixels / this.getResources().getDimension(R.dimen.files_grid_item_size));
    }

    private void showNewFolderDialog() {
        NewFolderDialog dialog = new NewFolderDialog((Context)this);
        dialog.setOnNewFolderNameEnteredListener(this);
        dialog.show();
    }

    private void toggleViewMode() {
        MenuItem menuItem = this.mToolbar.getMenu().findItem(R.id.change_view);
        if (this.mAdapter.isGridModeEnabled()) {
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
            menuItem.setIcon(Utils.attrToResId((Context)this, R.attr.efp__ic_action_grid));
            menuItem.setTitle(R.string.efp__action_grid);
            this.mAdapter.setGridModeEnabled(false);
        } else {
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, this.calculateGridColumnsCount()));
            menuItem.setIcon(Utils.attrToResId((Context)this, R.attr.efp__ic_action_list));
            menuItem.setTitle(R.string.efp__action_list);
            this.mAdapter.setGridModeEnabled(true);
        }
        this.setChangeViewIcon(this.mToolbar.getMenu());
    }

    private void setMultiChoiceModeEnabled(boolean enabled) {
        this.mIsMultiChoiceModeEnabled = enabled;
        this.mToolbar.setMultiChoiceModeEnabled(enabled);
        this.mAdapter.setUseFirstItemAsUpEnabled(!enabled && this.mUseFirstItemAsUpEnabled && !this.isTopDirectory(this.mCurrentDirectory));
        this.mAdapter.setMultiChoiceModeEnabled(enabled);
        this.setChangeViewIcon(this.mToolbar.getMenu());
    }

    private boolean isTopDirectory(@Nullable File directory) {
        return directory != null && TOP_DIRECTORY.equals(directory.getAbsolutePath());
    }

    private void setChangeViewIcon(@NonNull Menu menu2) {
        MenuItem item = menu2.findItem(R.id.change_view);
        if (item != null) {
            item.setIcon(Utils.attrToResId((Context)this, this.mAdapter.isGridModeEnabled() ? R.attr.efp__ic_action_list : R.attr.efp__ic_action_grid));
            item.setTitle(this.mAdapter.isGridModeEnabled() ? R.string.efp__action_list : R.string.efp__action_grid);
        }
    }

    private void finishWithResult(@NonNull File path, @NonNull String file) {
        this.finishWithResult(path, new ArrayList<String>(Collections.singletonList(file)));
    }

    private void finishWithResult(@NonNull File path, @NonNull List<String> files) {
        String resultPath = path.getAbsolutePath();
        if (!resultPath.endsWith(TOP_DIRECTORY)) {
            resultPath = resultPath + TOP_DIRECTORY;
        }
        ExFilePickerResult result = new ExFilePickerResult(resultPath, files);
        Intent intent = new Intent();
        intent.putExtra("RESULT", (Parcelable)result);
        this.setResult(-1, intent);
        this.finish();
    }

    private void setupViews() {
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mAdapter = new FilesListAdapter();
        this.mAdapter.setOnListItemClickListener(this);
        this.mAdapter.setCanChooseOnlyFiles(this.mChoiceType == ExFilePicker.ChoiceType.FILES);
        this.mAdapter.setUseFirstItemAsUpEnabled(this.mUseFirstItemAsUpEnabled);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mToolbar = (FilesListToolbar)this.findViewById(R.id.toolbar);
        this.mToolbar.setOnMenuItemClickListener(this);
        this.mToolbar.setNavigationOnClickListener(this);
        this.mToolbar.setQuitButtonEnabled(this.mIsQuitButtonEnabled);
        this.mToolbar.setMultiChoiceModeEnabled(false);
        Menu menu2 = this.mToolbar.getMenu();
        this.setupOkButtonVisibility();
        menu2.findItem(R.id.new_folder).setVisible(!this.mIsNewFolderButtonDisabled);
        menu2.findItem(R.id.sort).setVisible(!this.mIsSortButtonDisabled);
        this.mEmptyView = this.findViewById(R.id.empty_view);
    }

    private void setupOkButtonVisibility() {
        this.mToolbar.getMenu().findItem(R.id.ok).setVisible(this.mChoiceType == ExFilePicker.ChoiceType.DIRECTORIES);
    }

    @NonNull
    private File getStartDirectory(@NonNull Intent intent) {
        LinkedHashMap<String, String> storages;
        File tmp;
        File path = null;
        String startPath = intent.getStringExtra(EXTRA_START_DIRECTORY);
        if (startPath != null && startPath.length() > 0 && (tmp = new File(startPath)).exists() && tmp.isDirectory()) {
            path = tmp;
        }
        if (path == null && (storages = Utils.getExternalStoragePaths((Context)this)).size() > 0) {
            path = new File((String)storages.keySet().toArray()[0]);
        }
        if (path == null) {
            path = new File(TOP_DIRECTORY);
            if (Environment.getExternalStorageState().equals("mounted")) {
                path = Environment.getExternalStorageDirectory();
            }
        }
        return path;
    }
}

