/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.exfilepicker.ui.adapter;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.bartwell.exfilepicker.ExFilePicker;
import ru.bartwell.exfilepicker.R;
import ru.bartwell.exfilepicker.ui.adapter.holder.BaseFilesListHolder;
import ru.bartwell.exfilepicker.ui.adapter.holder.DirectoryFilesListHolder;
import ru.bartwell.exfilepicker.ui.adapter.holder.FileFilesListHolder;
import ru.bartwell.exfilepicker.ui.adapter.holder.UpFilesListHolder;
import ru.bartwell.exfilepicker.ui.callback.OnListItemClickListener;
import ru.bartwell.exfilepicker.utils.ListUtils;
import ru.bartwell.exfilepicker.utils.comparator.FilesListComparatorHelper;

public class FilesListAdapter
extends RecyclerView.Adapter<BaseFilesListHolder> {
    private static final int ITEM_TYPE_LIST_FILE = 0;
    private static final int ITEM_TYPE_GRID_FILE = 1;
    private static final int ITEM_TYPE_LIST_DIRECTORY = 2;
    private static final int ITEM_TYPE_GRID_DIRECTORY = 3;
    private static final int ITEM_TYPE_GRID_UP = 4;
    private static final int ITEM_TYPE_LIST_UP = 5;
    @NonNull
    private List<File> mItems = new ArrayList<File>();
    @NonNull
    private ArrayList<File> mNotFilteredItems = new ArrayList();
    @NonNull
    private List<String> mSelectedItems = new ArrayList<String>();
    @Nullable
    private OnListItemClickListener mListener;
    private boolean mIsMultiChoiceModeEnabled;
    private boolean mIsGridModeEnabled;
    private boolean mCanChooseOnlyFiles;
    private boolean mUseFirstItemAsUpEnabled;

    public BaseFilesListHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                return new FileFilesListHolder(this.inflate(parent, R.layout.layout_files_list_item));
            }
            case 1: {
                return new FileFilesListHolder(this.inflate(parent, R.layout.layout_files_grid_item));
            }
            case 2: {
                return new DirectoryFilesListHolder(this.inflate(parent, R.layout.layout_files_list_item));
            }
            case 5: {
                return new UpFilesListHolder(this.inflate(parent, R.layout.layout_files_list_item));
            }
            case 4: {
                return new UpFilesListHolder(this.inflate(parent, R.layout.layout_files_list_item));
            }
        }
        return new DirectoryFilesListHolder(this.inflate(parent, R.layout.layout_files_grid_item));
    }

    public int getItemViewType(int position) {
        if (this.mUseFirstItemAsUpEnabled && position == 0) {
            return this.mIsGridModeEnabled ? 4 : 5;
        }
        if (this.mIsGridModeEnabled) {
            return this.getItem(position).isDirectory() ? 3 : 1;
        }
        return this.getItem(position).isDirectory() ? 2 : 0;
    }

    public void onBindViewHolder(@NonNull BaseFilesListHolder holder, int position) {
        if (this.getItemViewType(position) == 5 || this.getItemViewType(position) == 4) {
            ((UpFilesListHolder)holder).bind(this.mListener);
        } else {
            holder.bind(this.getItem(position), this.mIsMultiChoiceModeEnabled, this.isItemSelected(position), this.mListener);
        }
    }

    public int getItemCount() {
        if (this.mUseFirstItemAsUpEnabled) {
            return this.mItems.size() + 1;
        }
        return this.mItems.size();
    }

    public void setItems(@NonNull List<File> items, @NonNull ExFilePicker.SortingType sortingType) {
        this.mSelectedItems.clear();
        this.mItems.clear();
        this.mItems.addAll(items);
        this.sort(sortingType);
    }

    @NonNull
    public File getItem(int position) {
        if (this.mUseFirstItemAsUpEnabled) {
            return this.mItems.get(position - 1);
        }
        return this.mItems.get(position);
    }

    public void setOnListItemClickListener(@Nullable OnListItemClickListener listener) {
        this.mListener = listener;
    }

    public void setMultiChoiceModeEnabled(boolean enabled) {
        this.mIsMultiChoiceModeEnabled = enabled;
        if (!this.mIsMultiChoiceModeEnabled) {
            this.mSelectedItems.clear();
        }
        if (this.mCanChooseOnlyFiles) {
            if (enabled) {
                this.mNotFilteredItems = new ArrayList<File>(this.mItems);
                this.removeDirectories(this.mItems);
            } else {
                this.mItems = new ArrayList<File>(this.mNotFilteredItems);
            }
        }
        this.notifyDataSetChanged();
    }

    public void setItemSelected(int position, boolean selected) {
        String name = this.getItem(position).getName();
        if (selected) {
            this.mSelectedItems.add(name);
        } else {
            this.mSelectedItems.remove(name);
        }
        this.notifyItemChanged(position);
    }

    public boolean isItemSelected(int position) {
        return this.mSelectedItems.contains(this.getItem(position).getName());
    }

    public void sort(@NonNull ExFilePicker.SortingType sortingType) {
        Collections.sort(this.mItems, FilesListComparatorHelper.getComparator(sortingType));
        this.notifyDataSetChanged();
    }

    public void selectAll() {
        this.mSelectedItems.clear();
        for (File item : this.mItems) {
            this.mSelectedItems.add(item.getName());
        }
        this.notifyDataSetChanged();
    }

    public void deselect() {
        this.mSelectedItems.clear();
        this.notifyDataSetChanged();
    }

    public void invertSelection() {
        ArrayList<String> selectedItems = new ArrayList<String>();
        for (File item : this.mItems) {
            if (this.mSelectedItems.contains(item.getName())) continue;
            selectedItems.add(item.getName());
        }
        this.mSelectedItems = new ArrayList<String>(selectedItems);
        this.notifyDataSetChanged();
    }

    public boolean isGridModeEnabled() {
        return this.mIsGridModeEnabled;
    }

    public void setGridModeEnabled(boolean enabled) {
        this.mIsGridModeEnabled = enabled;
        this.notifyDataSetChanged();
    }

    @NonNull
    public List<String> getSelectedItems() {
        return this.mSelectedItems;
    }

    public void setCanChooseOnlyFiles(boolean canChooseOnlyFiles) {
        this.mCanChooseOnlyFiles = canChooseOnlyFiles;
    }

    public void setUseFirstItemAsUpEnabled(boolean enabled) {
        this.mUseFirstItemAsUpEnabled = enabled;
    }

    @NonNull
    private View inflate(@NonNull ViewGroup parent, @LayoutRes int layout2) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(layout2, parent, false);
    }

    private void removeDirectories(List<File> items) {
        ListUtils.filterList(items, new ListUtils.ConditionChecker<File>(){

            @Override
            public boolean check(@NonNull File file) {
                return file.isDirectory();
            }
        });
    }
}

