/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.exfilepicker.ui.adapter.holder;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import java.io.File;
import ru.bartwell.exfilepicker.R;
import ru.bartwell.exfilepicker.ui.callback.OnListItemClickListener;

public abstract class BaseFilesListHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener {
    @NonNull
    private final AppCompatTextView mFileName;
    @NonNull
    private final AppCompatCheckBox mCheckBox;
    @Nullable
    private OnListItemClickListener mListener;

    BaseFilesListHolder(@NonNull View itemView) {
        super(itemView);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mFileName = (AppCompatTextView)itemView.findViewById(R.id.filename);
        this.mCheckBox = (AppCompatCheckBox)itemView.findViewById(R.id.checkbox);
    }

    public void bind(@NonNull File file, boolean isMultiChoiceModeEnabled, boolean isSelected, @Nullable OnListItemClickListener listener) {
        this.setOnListItemClickListener(listener);
        this.mFileName.setText((CharSequence)file.getName());
        this.mCheckBox.setVisibility(isMultiChoiceModeEnabled ? 0 : 8);
        this.mCheckBox.setChecked(isSelected);
    }

    void setOnListItemClickListener(@Nullable OnListItemClickListener listener) {
        this.mListener = listener;
    }

    int getItemPosition() {
        return this.getAdapterPosition();
    }

    public void onClick(View view) {
        if (this.mListener != null) {
            this.mListener.onListItemClick(this.getItemPosition());
        }
    }

    public boolean onLongClick(View view) {
        if (this.mListener != null) {
            this.mListener.onListItemLongClick(this.getItemPosition());
        }
        return true;
    }
}

