/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.exfilepicker.ui.adapter.holder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import java.io.File;
import ru.bartwell.exfilepicker.R;
import ru.bartwell.exfilepicker.ui.adapter.holder.BaseFilesListHolder;
import ru.bartwell.exfilepicker.ui.callback.OnListItemClickListener;
import ru.bartwell.exfilepicker.utils.Utils;

public class FileFilesListHolder
extends BaseFilesListHolder {
    @NonNull
    private final Context mContext;
    @Nullable
    private final AppCompatTextView mFileSize;
    @NonNull
    private final AppCompatImageView mThumbnail;

    public FileFilesListHolder(@NonNull View itemView) {
        super(itemView);
        this.mContext = itemView.getContext();
        this.mFileSize = (AppCompatTextView)itemView.findViewById(R.id.filesize);
        this.mThumbnail = (AppCompatImageView)itemView.findViewById(R.id.thumbnail);
    }

    @Override
    public void bind(@NonNull File file, boolean isMultiChoiceModeEnabled, boolean isSelected, @Nullable OnListItemClickListener listener) {
        super.bind(file, isMultiChoiceModeEnabled, isSelected, listener);
        if (this.mFileSize != null) {
            this.mFileSize.setVisibility(0);
            this.mFileSize.setText((CharSequence)Utils.getHumanReadableFileSize(this.mContext, file.length()));
        }
        RequestOptions options = new RequestOptions().error(R.drawable.efp__ic_file);
        Glide.with((Context)this.mContext).load(file).apply(options).into((ImageView)this.mThumbnail);
    }
}

