/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.exfilepicker.ui.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.AttributeSet;
import ru.bartwell.exfilepicker.R;
import ru.bartwell.exfilepicker.utils.Utils;

public class FilesListToolbar
extends Toolbar {
    private boolean mQuitButtonEnabled;
    private CharSequence mTitle;

    public FilesListToolbar(@NonNull Context context) {
        super(context);
    }

    public FilesListToolbar(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public FilesListToolbar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setQuitButtonEnabled(boolean enabled) {
        this.mQuitButtonEnabled = enabled;
    }

    public void setMultiChoiceModeEnabled(boolean enabled) {
        this.getMenu().clear();
        if (enabled) {
            this.inflateMenu(R.menu.files_list_multi_choice);
            this.mTitle = this.getTitle();
            this.setTitle(null);
            this.setNavigationIcon(Utils.attrToResId(this.getContext(), R.attr.efp__ic_action_cancel));
        } else {
            this.inflateMenu(R.menu.files_list_single_choice);
            if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
                this.setTitle(this.mTitle);
            }
            if (this.mQuitButtonEnabled) {
                this.setNavigationIcon(Utils.attrToResId(this.getContext(), R.attr.efp__ic_action_cancel));
            } else {
                this.setNavigationIcon(null);
            }
        }
    }
}

