/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.exfilepicker.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ListUtils {
    public static <T> void copyListWithCondition(@NonNull T[] fromList, @NonNull List<T> toList, @Nullable ConditionChecker<T> checker) {
        ListUtils.copyListWithCondition(Arrays.asList(fromList), toList, checker);
    }

    public static <T> void copyListWithCondition(@NonNull List<T> fromList, @NonNull List<T> toList, @Nullable ConditionChecker<T> checker) {
        if (checker == null) {
            toList.addAll(fromList);
        } else {
            for (T item : fromList) {
                if (!checker.check(item)) continue;
                toList.add(item);
            }
        }
    }

    public static <T> void filterList(@NonNull List<T> list, @NonNull ConditionChecker<T> checker) {
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!checker.check(iterator.next())) continue;
            iterator.remove();
        }
    }

    public static interface ConditionChecker<T> {
        public boolean check(@NonNull T var1);
    }
}

