/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.exfilepicker.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import ru.bartwell.exfilepicker.R;

public class Utils {
    private static final String CACHE_DIR_PATH_PART = "/Android";

    @NonNull
    public static LinkedHashMap<String, String> getExternalStoragePaths(@NonNull Context context) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        ArrayList<File> paths = new ArrayList<File>();
        if (Build.VERSION.SDK_INT >= 19) {
            paths.addAll(Arrays.asList(context.getExternalCacheDirs()));
        } else {
            paths.add(context.getExternalCacheDir());
        }
        for (File dir : paths) {
            String path = dir.getPath().split(CACHE_DIR_PATH_PART)[0];
            result.put(path, new File(path).getName());
        }
        return result;
    }

    @NonNull
    public static String getFileExtension(@NonNull String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1, fileName.length()).toLowerCase(Locale.getDefault());
    }

    @NonNull
    public static String getHumanReadableFileSize(@NonNull Context context, long size) {
        String[] units = context.getResources().getStringArray(R.array.efp__size_units);
        for (int i = units.length - 1; i >= 0; --i) {
            if (!((double)size >= Math.pow(1024.0, i))) continue;
            return Math.round((double)size / Math.pow(1024.0, i)) + " " + units[i];
        }
        return size + " " + units[0];
    }

    public static int attrToResId(@NonNull Context context, @AttrRes int attr2) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        return a.getResourceId(0, 0);
    }
}

