/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.ultradebugger.base.html;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.ArrayList;
import ru.bartwell.ultradebugger.base.html.ContentPart;
import ru.bartwell.ultradebugger.base.html.RawContentPart;
import ru.bartwell.ultradebugger.base.html.Table;

public class Form
extends ContentPart {
    private final Table mTable;
    private int mRow;
    private StringBuilder mHiddens = new StringBuilder();
    private boolean mIsPostMethod = true;
    private String mAction = "";

    public void setPostMethod(boolean isPostMethod) {
        this.mIsPostMethod = isPostMethod;
    }

    public void setAction(String action) {
        this.mAction = action;
    }

    public Form() {
        this.mTable = new Table();
    }

    public void addInputText(@NonNull String label, @NonNull String name, @Nullable String value) {
        if (value == null) {
            value = "";
        }
        this.mTable.add(0, this.mRow, new RawContentPart(label));
        this.mTable.add(1, this.mRow, new RawContentPart("<input type=\"text\" name=\"" + TextUtils.htmlEncode((String)name) + "\" value=\"" + TextUtils.htmlEncode((String)value) + "\">"));
        ++this.mRow;
    }

    public void addHidden(String name, String value) {
        this.mHiddens.append("<input type=\"hidden\" name=\"").append(TextUtils.htmlEncode((String)name)).append("\" value=\"").append(TextUtils.htmlEncode((String)value)).append("\">");
    }

    public void addSelect(String label, String name, ArrayList<String> values) {
        this.mTable.add(0, this.mRow, new RawContentPart(label));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<select name=\"").append(TextUtils.htmlEncode((String)name)).append("\">");
        for (String value : values) {
            stringBuilder.append("<option>").append(value).append("</option>");
        }
        stringBuilder.append("</select>");
        this.mTable.add(1, this.mRow, new RawContentPart(stringBuilder.toString()));
        ++this.mRow;
    }

    public void addSubmit(String label) {
        this.mTable.add(1, this.mRow, new RawContentPart("<input type=\"submit\" value=\"" + TextUtils.htmlEncode((String)label) + "\">"));
        ++this.mRow;
    }

    @Override
    public String toHtml() {
        return "<form action=\"" + this.mAction + "\" method=\"" + (this.mIsPostMethod ? "post" : "get") + "\">" + this.mHiddens.toString() + this.mTable.toHtml() + "</form>";
    }
}

