/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.ultradebugger.base.html;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import ru.bartwell.ultradebugger.base.html.ContentPart;

public class LinksList
extends ContentPart {
    private ArrayList<ListItem> mContent = new ArrayList();

    public void add(@NonNull String url, @NonNull String name) {
        this.add(url, name, null);
    }

    public void add(@NonNull String url, @NonNull String name, @Nullable String description) {
        ListItem listItem = new ListItem(url, name, description);
        this.mContent.add(listItem);
    }

    @Override
    public String toHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ListItem listItem : this.mContent) {
            stringBuilder.append("<a href=\"").append(listItem.getUrl()).append("\">").append(listItem.getName()).append("</a><br/>");
            if (listItem.getDescription() != null) {
                stringBuilder.append(listItem.getDescription()).append("<br/>");
            }
            stringBuilder.append("<br/>");
        }
        return stringBuilder.toString();
    }

    private class ListItem {
        private final String mUrl;
        private final String mName;
        private final String mDescription;

        ListItem(String url, String name, String description) {
            this.mUrl = url;
            this.mName = name;
            this.mDescription = description;
        }

        String getUrl() {
            return this.mUrl;
        }

        String getName() {
            return this.mName;
        }

        String getDescription() {
            return this.mDescription;
        }
    }
}

