/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.ultradebugger.base.html;

import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;
import ru.bartwell.ultradebugger.base.html.ContentPart;

public class Table
extends ContentPart {
    @NonNull
    private Map<CellXY, ContentPart> mContent = new HashMap<CellXY, ContentPart>();
    private int mMaxX;
    private int mMaxY;

    public void add(int x, int y, @NonNull ContentPart part) {
        this.mMaxX = Math.max(this.mMaxX, x);
        this.mMaxY = Math.max(this.mMaxY, y);
        this.mContent.put(new CellXY(x, y), part);
    }

    @Override
    @NonNull
    public String toHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table border=\"#777777\" cellspacing=\"0\" cellpadding=\"5\">");
        for (int y = 0; y < this.mMaxY + 1; ++y) {
            stringBuilder.append("<tr align=\"center\">");
            for (int x = 0; x < this.mMaxX + 1; ++x) {
                stringBuilder.append("<td>");
                ContentPart part = this.mContent.get(new CellXY(x, y));
                if (part != null) {
                    stringBuilder.append(part.toHtml());
                }
                stringBuilder.append("</td>");
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    private class CellXY {
        private final int x;
        private final int y;

        CellXY(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(@NonNull Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CellXY)) {
                return false;
            }
            CellXY key = (CellXY)o;
            return this.x == key.x && this.y == key.y;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            return result;
        }
    }
}

