/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.ultradebugger.base.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class HttpResponse {
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    @NonNull
    private Status mStatus;
    @NonNull
    private String mContentType;
    @Nullable
    private String mContent;
    @Nullable
    private InputStream mStream;
    private long mContentLength;
    @NonNull
    Map<String, String> mHeaders = new HashMap<String, String>();

    public HttpResponse(@NonNull String content) {
        this.mStatus = Status.OK;
        this.mContentType = CONTENT_TYPE_TEXT_HTML;
        this.mContent = content;
    }

    public HttpResponse(@NonNull String contentType, @NonNull InputStream stream, long contentLength) {
        this.mStatus = Status.OK;
        this.mContentType = contentType;
        this.mStream = stream;
        this.mContentLength = contentLength;
    }

    public HttpResponse(@NonNull String contentType, @NonNull InputStream stream) {
        this(contentType, stream, -1L);
    }

    public HttpResponse(@NonNull Status status) {
        this.mStatus = status;
        this.mContentType = CONTENT_TYPE_TEXT_HTML;
    }

    @Nullable
    public String getContent() {
        return this.mContent;
    }

    @NonNull
    public String getContentType() {
        return this.mContentType;
    }

    @NonNull
    public Status getStatus() {
        return this.mStatus;
    }

    @Nullable
    public InputStream getStream() {
        return this.mStream;
    }

    public long getContentLength() {
        return this.mContentLength;
    }

    public void addHeader(@NonNull String name, @NonNull String value) {
        this.mHeaders.put(name, value);
    }

    @NonNull
    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public static enum Status {
        OK(200, "OK"),
        BAD_REQUEST(400, "Bad request"),
        NOT_FOUND(404, "Not found"),
        INTERNAL_SERVER_ERROR(500, "Internal server error");

        private int mCode;
        private String mDescription;

        private Status(int code, String description) {
            this.mCode = code;
            this.mDescription = description;
        }

        public int getCode() {
            return this.mCode;
        }

        public String getDescription() {
            return this.mDescription;
        }
    }
}

