/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.ultradebugger.base.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.reflect.Field;
import java.util.Map;
import ru.bartwell.ultradebugger.base.html.ErrorPage;
import ru.bartwell.ultradebugger.base.model.HttpResponse;

public class CommonUtils {
    public static boolean isNumber(@Nullable String str) {
        return str == null || str.matches("-?\\d+");
    }

    @NonNull
    public static String trimFileExtension(@NonNull String fileName) {
        int dot = fileName.lastIndexOf(".");
        if (dot > 0) {
            return fileName.substring(0, dot);
        }
        return fileName;
    }

    @Nullable
    public static Activity getCurrentActivity() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
            activitiesField.setAccessible(true);
            Map activities = (Map)activitiesField.get(activityThread);
            if (activities == null) {
                return null;
            }
            for (Object activityRecord : activities.values()) {
                Class<?> activityRecordClass = activityRecord.getClass();
                Field pausedField = activityRecordClass.getDeclaredField("paused");
                pausedField.setAccessible(true);
                if (pausedField.getBoolean(activityRecord)) continue;
                Field activityField = activityRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity)activityField.get(activityRecord);
                return activity;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public static HttpResponse requestPermissions(String ... permissions) {
        Activity activity;
        if (Build.VERSION.SDK_INT >= 23 && (activity = CommonUtils.getCurrentActivity()) != null && !CommonUtils.checkSelfPermissions(activity, permissions)) {
            activity.requestPermissions(permissions, 0);
            return new HttpResponse(new ErrorPage("This module require additional permissions. Please allow it on your smartphone and reload this page.").toHtml());
        }
        return null;
    }

    @TargetApi(value=23)
    private static boolean checkSelfPermissions(@NonNull Activity activity, @NonNull String[] permissions) {
        for (String permission : permissions) {
            if (activity.checkSelfPermission(permission) == 0) continue;
            return false;
        }
        return true;
    }
}

