/*
 * Decompiled with CFR 0.152.
 */
package ru.bartwell.ultradebugger.base.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;

public class IpUtils {
    private static final String IPV4_BASIC_PATTERN_STRING = "(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");

    @Nullable
    public static String getIpV4() {
        return IpUtils.getIpAddress(true);
    }

    @Nullable
    public static String getIpV6() {
        return IpUtils.getIpAddress(false);
    }

    @Nullable
    private static String getIpAddress(boolean useIPv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : interfaces) {
                ArrayList<InetAddress> addresses = Collections.list(networkInterface.getInetAddresses());
                for (InetAddress address : addresses) {
                    if (address.isLoopbackAddress()) continue;
                    String resultAddress = address.getHostAddress().toUpperCase();
                    boolean isIPv4 = IpUtils.isIPv4Address(resultAddress);
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return resultAddress;
                    }
                    if (isIPv4) continue;
                    int delimiter = resultAddress.indexOf(37);
                    return delimiter < 0 ? resultAddress : resultAddress.substring(0, delimiter);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean isIPv4Address(@NonNull String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }
}

