/*
 * Decompiled with CFR 0.152.
 */
package ru.blizzed.opensongkick;

import java.io.IOException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import ru.blizzed.opensongkick.ApiCallException;
import ru.blizzed.opensongkick.ApiErrorException;
import ru.blizzed.opensongkick.OpenSongKickContext;
import ru.blizzed.opensongkick.models.Error;

public final class ApiCaller<ResultType> {
    private Call<ResultType> call;

    public ApiCaller(Call<ResultType> call) {
        this.call = call;
    }

    public ResultType execute() throws ApiCallException, ApiErrorException {
        try {
            Response response = this.call.execute();
            if (response.isSuccessful()) {
                return (ResultType)response.body();
            }
            throw new ApiErrorException(this.parseError(response));
        }
        catch (IOException e) {
            throw new ApiCallException(e);
        }
    }

    public void execute(final Listener<ResultType> listener) {
        this.call.enqueue(new Callback<ResultType>(){

            public void onResponse(Call<ResultType> call, Response<ResultType> response) {
                if (response.isSuccessful()) {
                    listener.onComplete(response.body(), ApiCaller.this);
                } else {
                    try {
                        listener.onError(ApiCaller.this.parseError(response), ApiCaller.this);
                    }
                    catch (IOException e) {
                        listener.onFailure(new ApiCallException(e), ApiCaller.this);
                    }
                }
            }

            public void onFailure(Call<ResultType> call, Throwable throwable) {
                listener.onFailure(new ApiCallException(throwable), ApiCaller.this);
            }
        });
    }

    public void cancel() {
        if (!this.call.isCanceled() & !this.call.isExecuted()) {
            this.call.cancel();
        }
    }

    private Error parseError(Response response) throws IOException {
        return OpenSongKickContext.getInstance().parseError(response.errorBody());
    }

    public static interface Listener<ResultType> {
        default public void onComplete(ResultType result, ApiCaller<ResultType> apiCaller) {
        }

        default public void onError(Error error, ApiCaller<ResultType> apiCaller) {
        }

        default public void onFailure(ApiCallException e, ApiCaller<ResultType> apiCaller) {
        }
    }
}

