/*
 * Decompiled with CFR 0.152.
 */
package ru.blizzed.opensongkick;

import java.io.IOException;
import java.lang.annotation.Annotation;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import ru.blizzed.opensongkick.models.Error;

public class OpenSongKickContext {
    private static final String ROOT_URL = "http://api.songkick.com/api/3.0/";
    private static OpenSongKickContext instance;
    private String apiKey;
    private Retrofit retrofit;

    private OpenSongKickContext(String apiKey) {
        this.apiKey = apiKey;
        OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor(chain -> {
            Request request = chain.request();
            HttpUrl url = request.url().newBuilder().addQueryParameter("apikey", apiKey).build();
            request = request.newBuilder().url(url).build();
            return chain.proceed(request);
        }).build();
        this.retrofit = new Retrofit.Builder().baseUrl(ROOT_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(httpClient).build();
    }

    public static OpenSongKickContext getInstance() {
        OpenSongKickContext.checkInit();
        return instance;
    }

    public static void initialize(String apiKey) {
        if (instance == null) {
            instance = new OpenSongKickContext(apiKey);
        }
    }

    public String getApiKey() {
        OpenSongKickContext.checkInit();
        return OpenSongKickContext.instance.apiKey;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public String getRootUrl() {
        OpenSongKickContext.checkInit();
        return ROOT_URL;
    }

    public <T> T createService(Class<T> service) {
        OpenSongKickContext.checkInit();
        return (T)this.retrofit.create(service);
    }

    public Error parseError(ResponseBody responseBody) throws IOException {
        Converter converter = this.retrofit.responseBodyConverter(Error.class, new Annotation[0]);
        return (Error)converter.convert((Object)responseBody);
    }

    private static void checkInit() {
        if (!OpenSongKickContext.isInitialized()) {
            throw new RuntimeException("OpenSongKickContext must be initialized first.");
        }
    }
}

