/*
 * Decompiled with CFR 0.152.
 */
package ru.blizzed.opensongkick;

import ru.blizzed.opensongkick.ApiCaller;
import ru.blizzed.opensongkick.OpenSongKickContext;
import ru.blizzed.opensongkick.methods.EventDetailsCaller;
import ru.blizzed.opensongkick.methods.SimilarArtistsCaller;
import ru.blizzed.opensongkick.methods.VenueDetailsCaller;
import ru.blizzed.opensongkick.methods.calendar.ArtistCalendar;
import ru.blizzed.opensongkick.methods.calendar.ArtistCalendarCaller;
import ru.blizzed.opensongkick.methods.calendar.MetroAreaCalendar;
import ru.blizzed.opensongkick.methods.calendar.MetroAreaCalendarCaller;
import ru.blizzed.opensongkick.methods.calendar.VenueCalendar;
import ru.blizzed.opensongkick.methods.calendar.VenueCalendarCaller;
import ru.blizzed.opensongkick.methods.gigography.ArtistGigography;
import ru.blizzed.opensongkick.methods.gigography.ArtistGigographyCaller;
import ru.blizzed.opensongkick.methods.gigography.UserGigography;
import ru.blizzed.opensongkick.methods.gigography.UserGigographyCaller;
import ru.blizzed.opensongkick.methods.search.ArtistSearch;
import ru.blizzed.opensongkick.methods.search.ArtistSearchCaller;
import ru.blizzed.opensongkick.methods.search.EventSearch;
import ru.blizzed.opensongkick.methods.search.EventSearchCaller;
import ru.blizzed.opensongkick.methods.search.LocationSearch;
import ru.blizzed.opensongkick.methods.search.LocationSearchCaller;
import ru.blizzed.opensongkick.methods.search.VenueSearch;
import ru.blizzed.opensongkick.methods.search.VenueSearchCaller;
import ru.blizzed.opensongkick.models.Artist;
import ru.blizzed.opensongkick.models.Event;
import ru.blizzed.opensongkick.models.Result;
import ru.blizzed.opensongkick.models.ResultsPage;
import ru.blizzed.opensongkick.models.Venue;

public final class SongKickApi {
    private static ArtistSearchCaller artistSearch;
    private static EventSearchCaller eventSearchCaller;
    private static LocationSearchCaller locationSearchCaller;
    private static VenueSearchCaller venueSearchCaller;
    private static ArtistCalendarCaller artistCalendarCaller;
    private static VenueCalendarCaller venueCalendarCaller;
    private static MetroAreaCalendarCaller metroAreaCalendarCaller;
    private static ArtistGigographyCaller artistGigographyCaller;
    private static UserGigographyCaller userGigographyCaller;
    private static EventDetailsCaller eventDetailsCaller;
    private static VenueDetailsCaller venueDetailsCaller;
    private static SimilarArtistsCaller similarArtistsCaller;

    private SongKickApi() {
    }

    public static ArtistSearch artistSearch() {
        if (artistSearch == null) {
            artistSearch = OpenSongKickContext.getInstance().createService(ArtistSearchCaller.class);
        }
        return new ArtistSearch(artistSearch);
    }

    public static EventSearch eventSearch() {
        if (eventSearchCaller == null) {
            eventSearchCaller = OpenSongKickContext.getInstance().createService(EventSearchCaller.class);
        }
        return new EventSearch(eventSearchCaller);
    }

    public static LocationSearch locationSearch() {
        if (locationSearchCaller == null) {
            locationSearchCaller = OpenSongKickContext.getInstance().createService(LocationSearchCaller.class);
        }
        return new LocationSearch(locationSearchCaller);
    }

    public static VenueSearch venueSearch() {
        if (venueSearchCaller == null) {
            venueSearchCaller = OpenSongKickContext.getInstance().createService(VenueSearchCaller.class);
        }
        return new VenueSearch(venueSearchCaller);
    }

    public static ArtistCalendar artistCalendar() {
        if (artistCalendarCaller == null) {
            artistCalendarCaller = OpenSongKickContext.getInstance().createService(ArtistCalendarCaller.class);
        }
        return new ArtistCalendar(artistCalendarCaller);
    }

    public static VenueCalendar venueCalendar() {
        if (venueCalendarCaller == null) {
            venueCalendarCaller = OpenSongKickContext.getInstance().createService(VenueCalendarCaller.class);
        }
        return new VenueCalendar(venueCalendarCaller);
    }

    public static MetroAreaCalendar metroAreaCalendar() {
        if (metroAreaCalendarCaller == null) {
            metroAreaCalendarCaller = OpenSongKickContext.getInstance().createService(MetroAreaCalendarCaller.class);
        }
        return new MetroAreaCalendar(metroAreaCalendarCaller);
    }

    public static ArtistGigography artistGigography() {
        if (artistGigographyCaller == null) {
            artistGigographyCaller = OpenSongKickContext.getInstance().createService(ArtistGigographyCaller.class);
        }
        return new ArtistGigography(artistGigographyCaller);
    }

    public static UserGigography userGigography() {
        if (userGigographyCaller == null) {
            userGigographyCaller = OpenSongKickContext.getInstance().createService(UserGigographyCaller.class);
        }
        return new UserGigography(userGigographyCaller);
    }

    public static ApiCaller<Result<Event>> eventDetails(String eventId) {
        if (eventDetailsCaller == null) {
            eventDetailsCaller = OpenSongKickContext.getInstance().createService(EventDetailsCaller.class);
        }
        return new ApiCaller<Result<Event>>(eventDetailsCaller.byId(eventId));
    }

    public static ApiCaller<Result<Venue>> venueDetails(String venueId) {
        if (venueDetailsCaller == null) {
            venueDetailsCaller = OpenSongKickContext.getInstance().createService(VenueDetailsCaller.class);
        }
        return new ApiCaller<Result<Venue>>(venueDetailsCaller.byId(venueId));
    }

    public static ApiCaller<ResultsPage<Artist>> similarArtists(String artistId) {
        if (similarArtistsCaller == null) {
            similarArtistsCaller = OpenSongKickContext.getInstance().createService(SimilarArtistsCaller.class);
        }
        return new ApiCaller<ResultsPage<Artist>>(similarArtistsCaller.byId(artistId));
    }
}

