/*
 * Decompiled with CFR 0.152.
 */
package ru.blizzed.opensongkick.params;

import java.util.Arrays;
import java.util.Objects;

public class Param<DataType>
implements Cloneable {
    private String name;
    protected DataType[] data;

    public Param(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @SafeVarargs
    public final Param<DataType> of(DataType ... data) {
        Param<DataType> param;
        try {
            param = this.clone();
        }
        catch (CloneNotSupportedException e) {
            param = new Param<DataType>(this.name);
        }
        param.data = data;
        return param;
    }

    public DataType[] getData() {
        return this.data;
    }

    public String toString() {
        if (this.data == null || this.data.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Arrays.stream(this.data).forEach(d -> sb.append(d.toString().toLowerCase()).append(","));
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Param param = (Param)o;
        return Objects.equals(this.name, param.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    protected Param<DataType> clone() throws CloneNotSupportedException {
        return (Param)super.clone();
    }
}

