/*
 * Copyright (c) 2018 BlizzedRu (Ivan Vlasov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ru.blizzed.pixabaylib;

import ru.blizzed.pixabaylib.model.PixabayImage;
import ru.blizzed.pixabaylib.model.PixabayVideo;
import ru.blizzed.pixabaylib.params.CategoryParam.*;
import ru.blizzed.pixabaylib.params.LangParam;
import ru.blizzed.pixabaylib.params.PixabayParams;

public class Launcher {

    public static void main(String[] args) throws PixabayErrorException, PixabayCallException {
        Pixabay.initialize("8747111-af76d80e5e357356f8f5ae4b0", LangParam.Lang.RU);

        Pixabay.search().image(PixabayParams.CATEGORY.of(Category.ANIMALS)).execute().getHits().stream().map(PixabayImage::getImageURL).forEach(videos -> {
            System.out.println(videos);
        });

    }

}
