/*
 * Decompiled with CFR 0.152.
 */
package ru.cian.huawei.publish;

import com.android.build.api.variant.ApplicationVariant;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cian.huawei.publish.BuildFormat;
import ru.cian.huawei.publish.DeployType;
import ru.cian.huawei.publish.HuaweiPublishCliParam;
import ru.cian.huawei.publish.HuaweiPublishConfig;
import ru.cian.huawei.publish.HuaweiPublishExtension;
import ru.cian.huawei.publish.HuaweiPublishExtensionConfig;
import ru.cian.huawei.publish.HuaweiPublishTask;
import ru.cian.huawei.publish.HuaweiPublishTask$WhenMappings;
import ru.cian.huawei.publish.ReleasePhaseConfig;
import ru.cian.huawei.publish.models.request.FileInfoRequest;
import ru.cian.huawei.publish.models.response.AppInfo;
import ru.cian.huawei.publish.models.response.FileInfo;
import ru.cian.huawei.publish.models.response.FileServerOriResultResponse;
import ru.cian.huawei.publish.models.response.SubmitResponse;
import ru.cian.huawei.publish.models.response.UploadFileRsp;
import ru.cian.huawei.publish.models.response.UploadUrlResponse;
import ru.cian.huawei.publish.service.HuaweiService;
import ru.cian.huawei.publish.service.HuaweiServiceImpl;
import ru.cian.huawei.publish.service.MockHuaweiService;
import ru.cian.huawei.publish.utils.BuildFileProvider;
import ru.cian.huawei.publish.utils.ConfigProvider;
import ru.cian.huawei.publish.utils.Logger;
import ru.cian.huawei.publish.utils.ServerPollingExecutor;

@DisableCachingByDefault
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 Q2\u00020\u0001:\u0002QRB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010:\u001a\u00020;H\u0007J8\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020GH\u0002J\u001e\u0010H\u001a\b\u0012\u0004\u0012\u00020J0I2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\rH\u0002J&\u0010N\u001a\u00020;2\u0006\u0010(\u001a\u00020O2\u0006\u0010+\u001a\u00020O2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0PH\u0002R,\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068G@GX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR*\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R*\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0005\u001a\u0004\u0018\u00010\u00138G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R*\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R*\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R*\u0010\u001f\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\u0012R*\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010\u0005\u001a\u0004\u0018\u00010\"8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R*\u0010(\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0010\"\u0004\b*\u0010\u0012R*\u0010+\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0010\"\u0004\b-\u0010\u0012R*\u0010.\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0010\"\u0004\b0\u0010\u0012R*\u00101\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0010\"\u0004\b3\u0010\u0012R*\u00104\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0010\"\u0004\b6\u0010\u0012R*\u00107\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0010\"\u0004\b9\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lru/cian/huawei/publish/HuaweiPublishTask;", "Lorg/gradle/api/DefaultTask;", "variant", "Lcom/android/build/api/variant/ApplicationVariant;", "(Lcom/android/build/api/variant/ApplicationVariant;)V", "<set-?>", "", "apiStub", "getApiStub", "()Ljava/lang/Boolean;", "setApiStub", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "", "buildFile", "getBuildFile", "()Ljava/lang/String;", "setBuildFile", "(Ljava/lang/String;)V", "Lru/cian/huawei/publish/BuildFormat;", "buildFormat", "getBuildFormat", "()Lru/cian/huawei/publish/BuildFormat;", "setBuildFormat", "(Lru/cian/huawei/publish/BuildFormat;)V", "clientId", "getClientId", "setClientId", "clientSecret", "getClientSecret", "setClientSecret", "credentialsPath", "getCredentialsPath", "setCredentialsPath", "Lru/cian/huawei/publish/DeployType;", "deployType", "getDeployType", "()Lru/cian/huawei/publish/DeployType;", "setDeployType", "(Lru/cian/huawei/publish/DeployType;)V", "publishPeriodMs", "getPublishPeriodMs", "setPublishPeriodMs", "publishTimeoutMs", "getPublishTimeoutMs", "setPublishTimeoutMs", "releasePhaseEndTime", "getReleasePhaseEndTime", "setReleasePhaseEndTime", "releasePhasePercent", "getReleasePhasePercent", "setReleasePhasePercent", "releasePhaseStartTime", "getReleasePhaseStartTime", "setReleasePhaseStartTime", "releaseTime", "getReleaseTime", "setReleaseTime", "action", "", "getSubmitResponse", "Lru/cian/huawei/publish/models/response/SubmitResponse;", "releaseType", "Lru/cian/huawei/publish/HuaweiPublishTask$ReleaseType;", "huaweiService", "Lru/cian/huawei/publish/service/HuaweiService;", "config", "Lru/cian/huawei/publish/HuaweiPublishConfig;", "token", "appId", "releasePercent", "", "mapFileInfo", "", "Lru/cian/huawei/publish/models/request/FileInfoRequest;", "fileInfoListResult", "Lru/cian/huawei/publish/models/response/FileServerOriResultResponse;", "buildFileName", "submitReleaseByServerPolling", "", "Lkotlin/Function0;", "Companion", "ReleaseType", "plugin"})
public class HuaweiPublishTask
extends DefaultTask {
    @Nullable
    private DeployType deployType;
    @Nullable
    private String publishTimeoutMs;
    @Nullable
    private String publishPeriodMs;
    @Nullable
    private String credentialsPath;
    @Nullable
    private String clientId;
    @Nullable
    private String clientSecret;
    @Nullable
    private BuildFormat buildFormat;
    @Nullable
    private String buildFile;
    @Nullable
    private String releaseTime;
    @Nullable
    private String releasePhaseStartTime;
    @Nullable
    private String releasePhaseEndTime;
    @Nullable
    private String releasePhasePercent;
    @Nullable
    private Boolean apiStub;
    private final ApplicationVariant variant;
    @NotNull
    public static final String NAME = "publishHuaweiAppGallery";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Internal
    @Nullable
    public final DeployType getDeployType() {
        return this.deployType;
    }

    @Option(option="deployType", description="How to deploy build: 'publish' to all users or create 'draft' without publishing or 'upload-only' without draft creation")
    public final void setDeployType(@Nullable DeployType deployType) {
        this.deployType = deployType;
    }

    @Internal
    @Nullable
    public final String getPublishTimeoutMs() {
        return this.publishTimeoutMs;
    }

    @Option(option="publishTimeoutMs", description="The time in millis during which the plugin periodically tries to publish the build")
    public final void setPublishTimeoutMs(@Nullable String string) {
        this.publishTimeoutMs = string;
    }

    @Internal
    @Nullable
    public final String getPublishPeriodMs() {
        return this.publishPeriodMs;
    }

    @Option(option="publishPeriodMs", description="The period in millis between tries to publish the build")
    public final void setPublishPeriodMs(@Nullable String string) {
        this.publishPeriodMs = string;
    }

    @Internal
    @Nullable
    public final String getCredentialsPath() {
        return this.credentialsPath;
    }

    @Option(option="credentialsPath", description="File path with AppGallery credentials params ('client_id' and 'client_secret')")
    public final void setCredentialsPath(@Nullable String string) {
        this.credentialsPath = string;
    }

    @Internal
    @Nullable
    public final String getClientId() {
        return this.clientId;
    }

    @Option(option="clientId", description="'client_id' param from AppGallery credentials. The key more priority than value from 'credentialsPath'")
    public final void setClientId(@Nullable String string) {
        this.clientId = string;
    }

    @Internal
    @Nullable
    public final String getClientSecret() {
        return this.clientSecret;
    }

    @Option(option="clientSecret", description="'client_secret' param from AppGallery credentials. The key more priority than value from 'credentialsPath'")
    public final void setClientSecret(@Nullable String string) {
        this.clientSecret = string;
    }

    @Internal
    @Nullable
    public final BuildFormat getBuildFormat() {
        return this.buildFormat;
    }

    @Option(option="buildFormat", description="'apk' or 'aab' for corresponding build format")
    public final void setBuildFormat(@Nullable BuildFormat buildFormat) {
        this.buildFormat = buildFormat;
    }

    @Internal
    @Nullable
    public final String getBuildFile() {
        return this.buildFile;
    }

    @Option(option="buildFile", description="Path to build file. 'null' means use standard path for 'apk' and 'aab' files.")
    public final void setBuildFile(@Nullable String string) {
        this.buildFile = string;
    }

    @Internal
    @Nullable
    public final String getReleaseTime() {
        return this.releaseTime;
    }

    @Option(option="releaseTime", description="Release time in UTC format. The format is yyyy-MM-dd'T'HH:mm:ssZZ.")
    public final void setReleaseTime(@Nullable String string) {
        this.releaseTime = string;
    }

    @Internal
    @Nullable
    public final String getReleasePhaseStartTime() {
        return this.releasePhaseStartTime;
    }

    @Option(option="releasePhaseStartTime", description="Start release time after review in UTC format. The format is yyyy-MM-dd'T'HH:mm:ssZZ.")
    public final void setReleasePhaseStartTime(@Nullable String string) {
        this.releasePhaseStartTime = string;
    }

    @Internal
    @Nullable
    public final String getReleasePhaseEndTime() {
        return this.releasePhaseEndTime;
    }

    @Option(option="releasePhaseEndTime", description="End release time after review in UTC format. The format is yyyy-MM-dd'T'HH:mm:ssZZ.")
    public final void setReleasePhaseEndTime(@Nullable String string) {
        this.releasePhaseEndTime = string;
    }

    @Internal
    @Nullable
    public final String getReleasePhasePercent() {
        return this.releasePhasePercent;
    }

    @Option(option="releasePhasePercent", description="Percentage of target users of release by phase. The integer or decimal value from 0 to 100.")
    public final void setReleasePhasePercent(@Nullable String string) {
        this.releasePhasePercent = string;
    }

    @Internal
    @Nullable
    public final Boolean getApiStub() {
        return this.apiStub;
    }

    @Option(option="apiStub", description="Use RestAPI stub instead of real RestAPI requests")
    public final void setApiStub(@Nullable Boolean bl) {
        this.apiStub = bl;
    }

    @TaskAction
    public final void action() {
        Object v3;
        String buildTypeName;
        HuaweiService huaweiService;
        block12: {
            huaweiService = Intrinsics.areEqual((Object)this.apiStub, (Object)true) ? (HuaweiService)new MockHuaweiService() : (HuaweiService)new HuaweiServiceImpl();
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Object object = project.getExtensions().findByName("huaweiPublish");
            if (!(object instanceof HuaweiPublishExtension)) {
                object = null;
            }
            HuaweiPublishExtension huaweiPublishExtension = (HuaweiPublishExtension)object;
            if (huaweiPublishExtension == null) {
                throw (Throwable)new IllegalArgumentException("Plugin extension 'huaweiPublish' is not available at build.gradle of the application module");
            }
            HuaweiPublishExtension huaweiPublishExtension2 = huaweiPublishExtension;
            buildTypeName = this.variant.getName();
            Iterable iterable = (Iterable)huaweiPublishExtension2.getInstances();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                HuaweiPublishExtensionConfig it = (HuaweiPublishExtensionConfig)t;
                boolean bl3 = false;
                if (!StringsKt.equals((String)it.getName(), (String)buildTypeName, (boolean)true)) continue;
                v3 = t;
                break block12;
            }
            v3 = null;
        }
        HuaweiPublishExtensionConfig huaweiPublishExtensionConfig = v3;
        if (huaweiPublishExtensionConfig == null) {
            throw (Throwable)new IllegalArgumentException("Plugin extension 'huaweiPublish' " + "instance with name '" + buildTypeName + "' is not available");
        }
        HuaweiPublishExtensionConfig extension = huaweiPublishExtensionConfig;
        HuaweiPublishCliParam cli = new HuaweiPublishCliParam(this.deployType, this.publishTimeoutMs, this.publishPeriodMs, this.credentialsPath, this.clientId, this.clientSecret, this.buildFormat, this.buildFile, this.releaseTime, this.releasePhaseStartTime, this.releasePhaseEndTime, this.releasePhasePercent, this.apiStub);
        Logger.Companion.i("Generate Config");
        BuildFileProvider buildFileProvider = new BuildFileProvider(this.variant);
        HuaweiPublishConfig config = new ConfigProvider(extension, cli, buildFileProvider).getConfig();
        Logger.Companion.i("Found build file: `" + config.getArtifactFile().getName() + '`');
        Logger.Companion.i("Get Access Token");
        String token = huaweiService.getToken(config.getCredentials().getClientId(), config.getCredentials().getClientSecret());
        Logger.Companion.i("Get App ID");
        Object object = this.variant.getApplicationId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant.applicationId.get()");
        String applicationId = (String)object;
        AppInfo appInfo = huaweiService.getAppID(config.getCredentials().getClientId(), token, applicationId);
        Logger.Companion.i("Get Upload Url");
        UploadUrlResponse uploadUrl = huaweiService.getUploadingBuildUrl(config.getCredentials().getClientId(), token, appInfo.getValue(), config.getArtifactFormat().getFileExtension());
        Logger.Companion.i("Upload build file '" + config.getArtifactFile().getPath() + '\'');
        FileServerOriResultResponse fileInfoListResult = huaweiService.uploadBuildFile(uploadUrl.getUploadUrl(), uploadUrl.getAuthCode(), config.getArtifactFile());
        if (config.getDeployType() != DeployType.UPLOAD_ONLY) {
            Logger.Companion.i("Update App File Info");
            String string = config.getArtifactFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.artifactFile.name");
            List<FileInfoRequest> fileInfoRequestList = this.mapFileInfo(fileInfoListResult, string);
            String appId = appInfo.getValue();
            ReleasePhaseConfig releasePhaseConfig = config.getReleasePhase();
            double releasePercent = releasePhaseConfig != null ? releasePhaseConfig.getPercent() : 100.0;
            ReleaseType releaseType = releasePercent == 100.0 ? ReleaseType.FULL : ReleaseType.PHASE;
            huaweiService.updateAppFileInformation(config.getCredentials().getClientId(), token, appId, releaseType.getType(), fileInfoRequestList);
            if (config.getDeployType() == DeployType.PUBLISH) {
                Logger.Companion.i("Submit Review");
                Function0 submitRequestFunction2 = (Function0)new Function0<SubmitResponse>(this, releaseType, huaweiService, config, token, appId, releasePercent){
                    final /* synthetic */ HuaweiPublishTask this$0;
                    final /* synthetic */ ReleaseType $releaseType;
                    final /* synthetic */ HuaweiService $huaweiService;
                    final /* synthetic */ HuaweiPublishConfig $config;
                    final /* synthetic */ String $token;
                    final /* synthetic */ String $appId;
                    final /* synthetic */ double $releasePercent;

                    @NotNull
                    public final SubmitResponse invoke() {
                        return HuaweiPublishTask.access$getSubmitResponse(this.this$0, this.$releaseType, this.$huaweiService, this.$config, this.$token, this.$appId, this.$releasePercent);
                    }
                    {
                        this.this$0 = huaweiPublishTask;
                        this.$releaseType = releaseType;
                        this.$huaweiService = huaweiService;
                        this.$config = huaweiPublishConfig;
                        this.$token = string;
                        this.$appId = string2;
                        this.$releasePercent = d;
                        super(0);
                    }
                };
                switch (HuaweiPublishTask$WhenMappings.$EnumSwitchMapping$0[config.getArtifactFormat().ordinal()]) {
                    case 1: {
                        ((SubmitResponse)submitRequestFunction2.invoke()).getRet();
                        break;
                    }
                    case 2: {
                        this.submitReleaseByServerPolling(config.getPublishPeriodMs(), config.getPublishTimeoutMs(), (Function0<Unit>)((Function0)new Function0<Unit>(submitRequestFunction2){
                            final /* synthetic */ Function0 $submitRequestFunction;

                            public final void invoke() {
                                ((SubmitResponse)this.$submitRequestFunction.invoke()).getRet();
                            }
                            {
                                this.$submitRequestFunction = function0;
                                super(0);
                            }
                        }));
                    }
                }
                Logger.Companion.i("Upload build file with submit on " + releasePercent + "% users - Successfully Done!");
            } else {
                Logger.Companion.i("Upload build file draft without submit on users - Successfully Done!");
            }
        } else {
            Logger.Companion.i("Upload build file without draft and submit on users - Successfully Done!");
        }
    }

    private final SubmitResponse getSubmitResponse(ReleaseType releaseType, HuaweiService huaweiService, HuaweiPublishConfig config, String token, String appId, double releasePercent) {
        SubmitResponse submitResponse;
        switch (HuaweiPublishTask$WhenMappings.$EnumSwitchMapping$1[releaseType.ordinal()]) {
            case 1: {
                submitResponse = huaweiService.submitReviewImmediately(config.getCredentials().getClientId(), token, appId, config.getReleaseTime());
                break;
            }
            case 2: {
                ReleasePhaseConfig releasePhaseConfig = config.getReleasePhase();
                ReleasePhaseConfig releasePhaseConfig2 = config.getReleasePhase();
                submitResponse = huaweiService.submitReviewWithReleasePhase(config.getCredentials().getClientId(), token, appId, releasePhaseConfig != null ? releasePhaseConfig.getStartTime() : null, releasePhaseConfig2 != null ? releasePhaseConfig2.getEndTime() : null, releasePercent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return submitResponse;
    }

    private final void submitReleaseByServerPolling(long publishPeriodMs, long publishTimeoutMs, Function0<Unit> action2) {
        new ServerPollingExecutor().run(publishPeriodMs, publishTimeoutMs, (Function0<Unit>)((Function0)new Function0<Unit>(action2){
            final /* synthetic */ Function0 $action;

            public final void invoke() {
                this.$action.invoke();
            }
            {
                this.$action = function0;
                super(0);
            }
        }), (Function2<? super Long, ? super Exception, Unit>)((Function2)submitReleaseByServerPolling.2.INSTANCE), (Function0<Unit>)((Function0)submitReleaseByServerPolling.3.INSTANCE), (Function1<? super Exception, Unit>)((Function1)submitReleaseByServerPolling.4.INSTANCE));
    }

    private final List<FileInfoRequest> mapFileInfo(FileServerOriResultResponse fileInfoListResult, String buildFileName) {
        UploadFileRsp uploadFileRsp = fileInfoListResult.getResult().getUploadFileRsp();
        List<FileInfo> fileInfoList = uploadFileRsp != null ? uploadFileRsp.getFileInfoList() : null;
        boolean bl = false;
        List fileInfoRequestList = new ArrayList();
        List<FileInfo> list = fileInfoList;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileInfo it = (FileInfo)element$iv;
                boolean bl2 = false;
                fileInfoRequestList.add(new FileInfoRequest(buildFileName, it.getFileDestUlr(), it.getSize()));
            }
        }
        return fileInfoRequestList;
    }

    @Inject
    public HuaweiPublishTask(@NotNull ApplicationVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.variant = variant;
        this.setGroup("publishing");
        this.setDescription("Upload and publish application build file " + "to Huawei AppGallery Store for " + this.variant.getName() + " buildType");
        this.apiStub = false;
    }

    public static final /* synthetic */ SubmitResponse access$getSubmitResponse(HuaweiPublishTask $this, ReleaseType releaseType, HuaweiService huaweiService, HuaweiPublishConfig config, String token, String appId, double releasePercent) {
        return $this.getSubmitResponse(releaseType, huaweiService, config, token, appId, releasePercent);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lru/cian/huawei/publish/HuaweiPublishTask$ReleaseType;", "", "type", "", "(Ljava/lang/String;II)V", "getType", "()I", "FULL", "PHASE", "plugin"})
    public static final class ReleaseType
    extends Enum<ReleaseType> {
        public static final /* enum */ ReleaseType FULL;
        public static final /* enum */ ReleaseType PHASE;
        private static final /* synthetic */ ReleaseType[] $VALUES;
        private final int type;

        static {
            ReleaseType[] releaseTypeArray = new ReleaseType[2];
            ReleaseType[] releaseTypeArray2 = releaseTypeArray;
            releaseTypeArray[0] = FULL = new ReleaseType(1);
            releaseTypeArray[1] = PHASE = new ReleaseType(3);
            $VALUES = releaseTypeArray;
        }

        public final int getType() {
            return this.type;
        }

        private ReleaseType(int type2) {
            this.type = type2;
        }

        public static ReleaseType[] values() {
            return (ReleaseType[])$VALUES.clone();
        }

        public static ReleaseType valueOf(String string) {
            return Enum.valueOf(ReleaseType.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/cian/huawei/publish/HuaweiPublishTask$Companion;", "", "()V", "NAME", "", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

