/*
 * Decompiled with CFR 0.152.
 */
package ru.cian.huawei.publish.service;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cian.huawei.publish.models.HuaweiHttpResponseException;
import ru.cian.huawei.publish.models.request.AccessTokenRequest;
import ru.cian.huawei.publish.models.request.FileInfoRequest;
import ru.cian.huawei.publish.models.request.PhasedReleaseRequest;
import ru.cian.huawei.publish.models.request.UpdateAppFileInfoRequest;
import ru.cian.huawei.publish.models.response.AccessTokenResponse;
import ru.cian.huawei.publish.models.response.AppIdResponse;
import ru.cian.huawei.publish.models.response.AppInfo;
import ru.cian.huawei.publish.models.response.FileServerOriResultResponse;
import ru.cian.huawei.publish.models.response.SubmitResponse;
import ru.cian.huawei.publish.models.response.UpdateAppFileInfoResponse;
import ru.cian.huawei.publish.models.response.UploadUrlResponse;
import ru.cian.huawei.publish.service.HttpClientHelper;
import ru.cian.huawei.publish.service.HuaweiService;
import ru.cian.huawei.publish.utils.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0016J:\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J*\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J<\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020!H\u0016J6\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lru/cian/huawei/publish/service/HuaweiServiceImpl;", "Lru/cian/huawei/publish/service/HuaweiService;", "()V", "gson", "Lcom/google/gson/Gson;", "httpClient", "Lru/cian/huawei/publish/service/HttpClientHelper;", "getAppID", "Lru/cian/huawei/publish/models/response/AppInfo;", "clientId", "", "token", "packageName", "getSubmissionCompletedResponse", "Lru/cian/huawei/publish/models/response/SubmitResponse;", "submitResponse", "appId", "releaseTime", "getToken", "clientSecret", "getUploadingBuildUrl", "Lru/cian/huawei/publish/models/response/UploadUrlResponse;", "suffix", "submitReview", "releaseType", "", "requestBody", "Lokhttp3/RequestBody;", "submitReviewImmediately", "submitReviewWithReleasePhase", "startRelease", "endRelease", "releasePercent", "", "updateAppFileInformation", "Lru/cian/huawei/publish/models/response/UpdateAppFileInfoResponse;", "fileInfoRequestList", "", "Lru/cian/huawei/publish/models/request/FileInfoRequest;", "uploadBuildFile", "Lru/cian/huawei/publish/models/response/FileServerOriResultResponse;", "uploadUrl", "authCode", "buildFile", "Ljava/io/File;", "plugin"})
public final class HuaweiServiceImpl
implements HuaweiService {
    private final Gson gson = new Gson();
    private final HttpClientHelper httpClient = new HttpClientHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getToken(@NotNull String clientId, @NotNull String clientSecret) {
        Object object;
        void body$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        AccessTokenRequest bodyRequest = new AccessTokenRequest(clientId, clientSecret, "client_credentials");
        HttpClientHelper httpClientHelper = this.httpClient;
        String string = "https://connect-api.cloud.huawei.com/api/oauth2/v1/token";
        String string2 = this.gson.toJson((Object)bodyRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gson.toJson(bodyRequest)");
        RequestBody requestBody = RequestBody.Companion.create(string2, HttpClientHelper.Companion.getMEDIA_TYPE_JSON());
        Object var8_7 = null;
        boolean $i$f$post = false;
        void var10_9 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().post((RequestBody)body$iv);
        boolean $i$f$execute = false;
        try {
            void url$iv;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Object object2 = requestBuilder$iv$iv.url((String)url$iv);
            boolean bl = false;
            boolean bl2 = false;
            Request.Builder $this$apply$iv$iv = object2;
            boolean bl3 = false;
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            bl = false;
            bl2 = false;
            Throwable throwable = null;
            try {
                void this_$iv$iv;
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl4 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw (Throwable)new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                Object object3 = HttpClientHelper.access$getGson$p((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, AccessTokenResponse.class);
                if (object3 == null) {
                    throw (Throwable)new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            Logger.Companion.e((Exception)((Object)e$iv$iv));
            throw (Throwable)new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)object;
        String string3 = accessTokenResponse.getAccessToken();
        if (string3 == null) {
            throw (Throwable)new IllegalStateException("Can't get `accessToken`. Reason: '" + accessTokenResponse.getRet() + '\'');
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AppInfo getAppID(@NotNull String clientId, @NotNull String token, @NotNull String packageName) {
        Object object;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        boolean bl = false;
        Map headers = new LinkedHashMap();
        headers.put("Authorization", "Bearer " + token);
        headers.put("client_id", clientId);
        HttpClientHelper httpClientHelper = this.httpClient;
        String string = "https://connect-api.cloud.huawei.com/api/publish/v2/appid-list?packageName=" + packageName;
        boolean $i$f$get = false;
        void var9_10 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().get();
        boolean $i$f$execute = false;
        try {
            void url$iv;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Object object2 = requestBuilder$iv$iv.url((String)url$iv);
            boolean bl2 = false;
            boolean bl3 = false;
            Request.Builder $this$apply$iv$iv = object2;
            boolean bl4 = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv$iv$iv;
            boolean bl5 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl6 = false;
                $this$apply$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            bl2 = false;
            bl3 = false;
            Throwable throwable = null;
            try {
                void this_$iv$iv;
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl7 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw (Throwable)new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                Object object3 = HttpClientHelper.access$getGson$p((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, AppIdResponse.class);
                if (object3 == null) {
                    throw (Throwable)new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            Logger.Companion.e((Exception)((Object)e$iv$iv));
            throw (Throwable)new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        AppIdResponse appIdResponse = (AppIdResponse)object;
        if (appIdResponse.getAppids().isEmpty()) {
            throw (Throwable)new IllegalStateException("`appids` must not be empty");
        }
        return appIdResponse.getAppids().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UploadUrlResponse getUploadingBuildUrl(@NotNull String clientId, @NotNull String token, @NotNull String appId, @NotNull String suffix) {
        Object object;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        boolean bl = false;
        Map headers = new LinkedHashMap();
        headers.put("Authorization", "Bearer " + token);
        headers.put("client_id", clientId);
        HttpClientHelper httpClientHelper = this.httpClient;
        String string = "https://connect-api.cloud.huawei.com/api/publish/v2/upload-url?appId=" + appId + "&suffix=" + suffix;
        boolean $i$f$get = false;
        void var9_10 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().get();
        boolean $i$f$execute = false;
        try {
            void url$iv;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Object object2 = requestBuilder$iv$iv.url((String)url$iv);
            boolean bl2 = false;
            boolean bl3 = false;
            Request.Builder $this$apply$iv$iv = object2;
            boolean bl4 = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv$iv$iv;
            boolean bl5 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl6 = false;
                $this$apply$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            bl2 = false;
            bl3 = false;
            Throwable throwable = null;
            try {
                void this_$iv$iv;
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl7 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw (Throwable)new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                Object object3 = HttpClientHelper.access$getGson$p((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, UploadUrlResponse.class);
                if (object3 == null) {
                    throw (Throwable)new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            Logger.Companion.e((Exception)((Object)e$iv$iv));
            throw (Throwable)new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        return (UploadUrlResponse)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FileServerOriResultResponse uploadBuildFile(@NotNull String uploadUrl, @NotNull String authCode, @NotNull File buildFile) {
        Object object;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)uploadUrl, (String)"uploadUrl");
        Intrinsics.checkNotNullParameter((Object)authCode, (String)"authCode");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        RequestBody fileBody = RequestBody.Companion.create(buildFile, HttpClientHelper.Companion.getMEDIA_TYPE_AAB());
        MultipartBody requestBody = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM).addFormDataPart("file", buildFile.getName(), fileBody).addFormDataPart("authCode", authCode).addFormDataPart("fileCount", "1").addFormDataPart("parseType", "1").build();
        boolean bl = false;
        Map headers = new LinkedHashMap();
        headers.put("accept", "application/json");
        HttpClientHelper httpClientHelper = this.httpClient;
        boolean $i$f$post = false;
        void var10_11 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().post((RequestBody)requestBody);
        boolean $i$f$execute = false;
        try {
            OkHttpClient client$iv$iv = new OkHttpClient();
            Object object2 = requestBuilder$iv$iv.url(uploadUrl);
            boolean bl2 = false;
            boolean bl3 = false;
            Request.Builder $this$apply$iv$iv = object2;
            boolean bl4 = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv$iv$iv;
            boolean bl5 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl6 = false;
                $this$apply$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            bl2 = false;
            bl3 = false;
            Throwable throwable = null;
            try {
                void this_$iv$iv;
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl7 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw (Throwable)new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                Object object3 = HttpClientHelper.access$getGson$p((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, FileServerOriResultResponse.class);
                if (object3 == null) {
                    throw (Throwable)new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            Logger.Companion.e((Exception)((Object)e$iv$iv));
            throw (Throwable)new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        FileServerOriResultResponse result = (FileServerOriResultResponse)object;
        if (result.getResult().getResultCode() != 0) {
            throw (Throwable)new IllegalStateException("Build file uploading is failed!");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UpdateAppFileInfoResponse updateAppFileInformation(@NotNull String clientId, @NotNull String token, @NotNull String appId, int releaseType, @NotNull List<FileInfoRequest> fileInfoRequestList) {
        Object object;
        void body$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(fileInfoRequestList, (String)"fileInfoRequestList");
        boolean bl = false;
        Map headers = new LinkedHashMap();
        headers.put("Authorization", "Bearer " + token);
        headers.put("client_id", clientId);
        UpdateAppFileInfoRequest bodyRequest = new UpdateAppFileInfoRequest(5, fileInfoRequestList);
        HttpClientHelper httpClientHelper = this.httpClient;
        String string = "https://connect-api.cloud.huawei.com/api/publish/v2/app-file-info?appId=" + appId + "&releaseType=" + releaseType;
        String string2 = this.gson.toJson((Object)bodyRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gson.toJson(bodyRequest)");
        RequestBody requestBody = RequestBody.Companion.create(string2, HttpClientHelper.Companion.getMEDIA_TYPE_JSON());
        boolean $i$f$put = false;
        void var13_13 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().put((RequestBody)body$iv);
        boolean $i$f$execute = false;
        try {
            void url$iv;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Object object2 = requestBuilder$iv$iv.url((String)url$iv);
            boolean bl2 = false;
            boolean bl3 = false;
            Request.Builder $this$apply$iv$iv = object2;
            boolean bl4 = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv$iv$iv;
            boolean bl5 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl6 = false;
                $this$apply$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            bl2 = false;
            bl3 = false;
            Throwable throwable = null;
            try {
                void this_$iv$iv;
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl7 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw (Throwable)new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                Object object3 = HttpClientHelper.access$getGson$p((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, UpdateAppFileInfoResponse.class);
                if (object3 == null) {
                    throw (Throwable)new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            Logger.Companion.e((Exception)((Object)e$iv$iv));
            throw (Throwable)new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        UpdateAppFileInfoResponse result = (UpdateAppFileInfoResponse)object;
        if (result.getRet().getCode() != 0) {
            throw (Throwable)new IllegalStateException("Update App File Info is failed. Response: " + result);
        }
        return result;
    }

    @Override
    @NotNull
    public SubmitResponse submitReviewImmediately(@NotNull String clientId, @NotNull String token, @NotNull String appId, @Nullable String releaseTime) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        SubmitResponse submitResponse = this.submitReview(clientId, token, appId, 1, releaseTime, RequestBody.Companion.create("", HttpClientHelper.Companion.getMEDIA_TYPE_JSON()));
        return this.getSubmissionCompletedResponse(submitResponse, clientId, token, appId, releaseTime);
    }

    private final SubmitResponse getSubmissionCompletedResponse(SubmitResponse submitResponse, String clientId, String token, String appId, String releaseTime) {
        SubmitResponse submitResponse2;
        if (submitResponse.getRet().getCode() == 0) {
            submitResponse2 = submitResponse;
        } else if (submitResponse.getRet().getCode() == 204144660 && StringsKt.contains$default((CharSequence)submitResponse.getRet().getMsg(), (CharSequence)"It may take 2-5 minutes", (boolean)false, (int)2, null)) {
            SubmitResponse submissionResult;
            Logger.Companion.i("Build is currently processing, waiting for 3 minutes before submitting again...");
            Thread.sleep(180000L);
            submitResponse2 = submissionResult = this.submitReview(clientId, token, appId, 1, releaseTime, RequestBody.Companion.create("", HttpClientHelper.Companion.getMEDIA_TYPE_JSON()));
        } else {
            throw (Throwable)new HuaweiHttpResponseException(submitResponse.toString());
        }
        return submitResponse2;
    }

    @Override
    @NotNull
    public SubmitResponse submitReviewWithReleasePhase(@NotNull String clientId, @NotNull String token, @NotNull String appId, @Nullable String startRelease, @Nullable String endRelease, double releasePercent) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        String string = startRelease;
        Intrinsics.checkNotNull((Object)string);
        String string2 = endRelease;
        Intrinsics.checkNotNull((Object)string2);
        String string3 = "%.2f";
        Object[] objectArray = new Object[]{releasePercent};
        boolean bl = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(this, *args)");
        PhasedReleaseRequest bodyRequest = new PhasedReleaseRequest(string, string2, string4, "Release on " + releasePercent + "% from " + startRelease + " to " + endRelease);
        String string5 = this.gson.toJson((Object)bodyRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"gson.toJson(bodyRequest)");
        return this.submitReview(clientId, token, appId, 3, null, RequestBody.Companion.create(string5, HttpClientHelper.Companion.getMEDIA_TYPE_JSON()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final SubmitResponse submitReview(String clientId, String token, String appId, int releaseType, String releaseTime, RequestBody requestBody) {
        Object object;
        void this_$iv;
        boolean bl = false;
        Map headers = new LinkedHashMap();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        headers.put("Authorization", "Bearer " + token);
        headers.put("client_id", clientId);
        HttpUrl.Builder uriBuilder = HttpUrl.Companion.get("https://connect-api.cloud.huawei.com/api/publish/v2/app-submit").newBuilder().addQueryParameter("appId", appId).addQueryParameter("releaseType", String.valueOf(releaseType));
        if (releaseTime != null) {
            uriBuilder.addQueryParameter("releaseTime", releaseTime);
        }
        String string = uriBuilder.build().url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.build().toUrl().toString()");
        String url = string;
        HttpClientHelper httpClientHelper = this.httpClient;
        boolean $i$f$post = false;
        void var13_13 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().post(requestBody);
        boolean $i$f$execute = false;
        try {
            OkHttpClient client$iv$iv = new OkHttpClient();
            Object object2 = requestBuilder$iv$iv.url(url);
            boolean bl2 = false;
            boolean bl3 = false;
            Request.Builder $this$apply$iv$iv = object2;
            boolean bl4 = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv$iv$iv;
            boolean bl5 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl6 = false;
                $this$apply$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            bl2 = false;
            bl3 = false;
            Throwable throwable = null;
            try {
                void this_$iv$iv;
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl7 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw (Throwable)new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                Object object3 = HttpClientHelper.access$getGson$p((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, SubmitResponse.class);
                if (object3 == null) {
                    throw (Throwable)new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            Logger.Companion.e((Exception)((Object)e$iv$iv));
            throw (Throwable)new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        SubmitResponse result = (SubmitResponse)object;
        return result;
    }
}

