/*
 * Decompiled with CFR 0.152.
 */
package ru.cian.huawei.publish.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cian.huawei.publish.BuildFormat;
import ru.cian.huawei.publish.Credentials;
import ru.cian.huawei.publish.DeployType;
import ru.cian.huawei.publish.HuaweiPublishCliParam;
import ru.cian.huawei.publish.HuaweiPublishConfig;
import ru.cian.huawei.publish.HuaweiPublishExtensionConfig;
import ru.cian.huawei.publish.ReleasePhaseConfig;
import ru.cian.huawei.publish.ReleasePhaseExtension;
import ru.cian.huawei.publish.models.Credential;
import ru.cian.huawei.publish.utils.BuildFileProvider;
import ru.cian.huawei.publish.utils.CredentialHelper;
import ru.cian.huawei.publish.utils.KotlinExtensionsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lru/cian/huawei/publish/utils/ConfigProvider;", "", "extension", "Lru/cian/huawei/publish/HuaweiPublishExtensionConfig;", "cli", "Lru/cian/huawei/publish/HuaweiPublishCliParam;", "buildFileProvider", "Lru/cian/huawei/publish/utils/BuildFileProvider;", "(Lru/cian/huawei/publish/HuaweiPublishExtensionConfig;Lru/cian/huawei/publish/HuaweiPublishCliParam;Lru/cian/huawei/publish/utils/BuildFileProvider;)V", "checkReleasePhaseData", "", "releasePhase", "Lru/cian/huawei/publish/ReleasePhaseConfig;", "getBuildFile", "Ljava/io/File;", "customBuildFilePath", "", "artifactFormat", "Lru/cian/huawei/publish/BuildFormat;", "getConfig", "Lru/cian/huawei/publish/HuaweiPublishConfig;", "getCredentialsConfig", "Lru/cian/huawei/publish/Credentials;", "getReleasePhaseConfig", "plugin"})
public final class ConfigProvider {
    private final HuaweiPublishExtensionConfig extension;
    private final HuaweiPublishCliParam cli;
    private final BuildFileProvider buildFileProvider;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final HuaweiPublishConfig getConfig() {
        BuildFormat buildFormat;
        File artifactFile;
        Credentials credentialsConfig;
        ReleasePhaseConfig releasePhase;
        String releaseTime;
        long publishPeriodMs;
        long publishTimeoutMs;
        DeployType deployType;
        block12: {
            String artifactFileExtension;
            String string;
            String customBuildFilePath;
            String string2;
            BuildFormat artifactFormat;
            BuildFormat buildFormat2;
            long l;
            long l2;
            DeployType deployType2 = this.cli.getDeployType();
            if (deployType2 == null) {
                deployType2 = this.extension.getDeployType();
            }
            deployType = deployType2;
            String string3 = this.cli.getPublishTimeoutMs();
            if (string3 != null) {
                String string4 = string3;
                boolean bl = false;
                l2 = Long.parseLong(string4);
            } else {
                l2 = this.extension.getPublishTimeoutMs();
            }
            publishTimeoutMs = l2;
            String string5 = this.cli.getPublishPeriodMs();
            if (string5 != null) {
                String string6 = string5;
                boolean bl = false;
                l = Long.parseLong(string6);
            } else {
                l = publishPeriodMs = this.extension.getPublishPeriodMs();
            }
            if ((buildFormat2 = this.cli.getBuildFormat()) == null) {
                buildFormat2 = artifactFormat = this.extension.getBuildFormat();
            }
            if ((string2 = this.cli.getBuildFile()) == null) {
                string2 = customBuildFilePath = this.extension.getBuildFile();
            }
            if ((string = this.cli.getReleaseTime()) == null) {
                string = this.extension.getReleaseTime();
            }
            releaseTime = string;
            releasePhase = this.getReleasePhaseConfig();
            credentialsConfig = this.getCredentialsConfig();
            artifactFile = this.getBuildFile(customBuildFilePath, artifactFormat);
            String string7 = artifactFileExtension = FilesKt.getExtension((File)artifactFile);
            switch (string7.hashCode()) {
                case 96322: {
                    if (!string7.equals("aab")) throw (Throwable)new IllegalArgumentException("Not allowed artifact file extension: `" + artifactFileExtension + "`. " + "It should be `apk` or `aab`. ");
                    break;
                }
                case 96796: {
                    if (!string7.equals("apk")) throw (Throwable)new IllegalArgumentException("Not allowed artifact file extension: `" + artifactFileExtension + "`. " + "It should be `apk` or `aab`. ");
                    buildFormat = BuildFormat.APK;
                    break block12;
                }
            }
            buildFormat = BuildFormat.AAB;
            break block12;
            throw (Throwable)new IllegalArgumentException("Not allowed artifact file extension: `" + artifactFileExtension + "`. " + "It should be `apk` or `aab`. ");
        }
        BuildFormat actualArtifactFormat = buildFormat;
        return new HuaweiPublishConfig(credentialsConfig, deployType, actualArtifactFormat, artifactFile, publishTimeoutMs, publishPeriodMs, releaseTime, releasePhase);
    }

    @NotNull
    public final File getBuildFile(@Nullable String customBuildFilePath, @NotNull BuildFormat artifactFormat) {
        File artifactFile;
        Intrinsics.checkNotNullParameter((Object)((Object)artifactFormat), (String)"artifactFormat");
        File file = artifactFile = customBuildFilePath != null ? new File(customBuildFilePath) : this.buildFileProvider.getBuildFile(artifactFormat);
        if (artifactFile == null || !artifactFile.exists()) {
            throw (Throwable)new FileNotFoundException(artifactFile + " (No such file or directory). Application build file is not found. " + "Please run `assemble` or `bundle` task to build the application file before current task.");
        }
        if (Intrinsics.areEqual((Object)artifactFormat.getFileExtension(), (Object)FilesKt.getExtension((File)artifactFile)) ^ true) {
            throw (Throwable)new IllegalArgumentException("Build file " + artifactFile.getAbsolutePath() + " has wrong file extension " + "that doesn't match with announced buildFormat(" + (Object)((Object)artifactFormat) + ") plugin extension param.");
        }
        return artifactFile;
    }

    @NotNull
    public final Credentials getCredentialsConfig() {
        String string = this.cli.getCredentialsPath();
        if (string == null) {
            string = this.extension.getCredentialsPath();
        }
        String credentialsFilePath = string;
        String clientIdPriority = this.cli.getClientId();
        String clientSecretPriority = this.cli.getClientSecret();
        Lazy credentials2 = LazyKt.lazy((Function0)((Function0)new Function0<Credential>(this, credentialsFilePath){
            final /* synthetic */ ConfigProvider this$0;
            final /* synthetic */ String $credentialsFilePath;

            @NotNull
            public final Credential invoke() {
                CharSequence charSequence = this.$credentialsFilePath;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    throw (Throwable)new FileNotFoundException(ConfigProvider.access$getExtension$p(this.this$0) + " (File path for credentials is null or empty. " + "See the `credentialsPath` param description.");
                }
                File credentialsFile = new File(this.$credentialsFilePath);
                if (!credentialsFile.exists()) {
                    throw (Throwable)new FileNotFoundException(ConfigProvider.access$getExtension$p(this.this$0) + " (File (" + credentialsFile.getAbsolutePath() + ") " + "with 'client_id' and 'client_secret' for access to Huawei Publish API is not found)");
                }
                return CredentialHelper.INSTANCE.getCredentials(credentialsFile);
            }
            {
                this.this$0 = configProvider;
                this.$credentialsFilePath = string;
                super(0);
            }
        }));
        String string2 = clientIdPriority;
        if (string2 == null) {
            string2 = KotlinExtensionsKt.nullIfBlank(((Credential)credentials2.getValue()).getClientId());
        }
        if (string2 == null) {
            throw (Throwable)new IllegalArgumentException("(Huawei credential `clientId` param is null or empty). Please check your credentials file content or as single parameter.");
        }
        String clientId = string2;
        String string3 = clientSecretPriority;
        if (string3 == null) {
            string3 = KotlinExtensionsKt.nullIfBlank(((Credential)credentials2.getValue()).getClientSecret());
        }
        if (string3 == null) {
            throw (Throwable)new IllegalArgumentException("(Huawei credential `clientSecret` param is null or empty). Please check your credentials file content or as single parameter.");
        }
        String clientSecret = string3;
        return new Credentials(clientId, clientSecret);
    }

    @Nullable
    public final ReleasePhaseConfig getReleasePhaseConfig() {
        ReleasePhaseConfig releasePhase;
        ReleasePhaseConfig releasePhaseConfig;
        Double releasePhasePercent;
        Double d;
        String string;
        String releasePhaseStartTime;
        String string2 = this.cli.getReleasePhaseStartTime();
        if (string2 == null) {
            ReleasePhaseExtension releasePhaseExtension = this.extension.getReleasePhase();
            string2 = releasePhaseStartTime = releasePhaseExtension != null ? releasePhaseExtension.getStartTime() : null;
        }
        if ((string = this.cli.getReleasePhaseEndTime()) == null) {
            ReleasePhaseExtension releasePhaseExtension = this.extension.getReleasePhase();
            string = releasePhaseExtension != null ? releasePhaseExtension.getEndTime() : null;
        }
        String releasePhaseEndTime = string;
        String string3 = this.cli.getReleasePhasePercent();
        if (string3 != null) {
            String string4 = string3;
            boolean bl = false;
            d = Double.parseDouble(string4);
        } else {
            ReleasePhaseExtension releasePhaseExtension = this.extension.getReleasePhase();
            d = releasePhasePercent = releasePhaseExtension != null ? releasePhaseExtension.getPercent() : null;
        }
        if (releasePhaseStartTime != null || releasePhaseEndTime != null || releasePhasePercent != null) {
            if (releasePhaseStartTime == null) {
                throw (Throwable)new IllegalArgumentException("The `startTime` param must not be null if you choose publishing with Release Phase.");
            }
            if (releasePhaseEndTime == null) {
                throw (Throwable)new IllegalArgumentException("The `endTime` param must not be null if you choose publishing with Release Phase.");
            }
            if (releasePhasePercent == null) {
                throw (Throwable)new IllegalArgumentException("The `percent` param must not be null if you choose publishing with Release Phase.");
            }
            releasePhaseConfig = new ReleasePhaseConfig(releasePhaseStartTime, releasePhaseEndTime, releasePhasePercent);
        } else {
            releasePhaseConfig = releasePhase = null;
        }
        if (releasePhase != null) {
            this.checkReleasePhaseData(releasePhase);
        }
        return releasePhase;
    }

    private final void checkReleasePhaseData(ReleasePhaseConfig releasePhase) {
        Calendar startCalendar;
        Calendar endCalendar;
        if (releasePhase.getPercent() <= 0.0 && releasePhase.getPercent() > (double)100) {
            throw (Throwable)new IllegalArgumentException("Wrong percent release phase value = '" + releasePhase.getPercent() + "'. " + "Allowed values between 0 and 100 with up to two decimal places.");
        }
        Calendar nowCalendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ", Locale.getDefault());
        Calendar calendar = endCalendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"endCalendar");
        calendar.setTime(sdf.parse(releasePhase.getEndTime()));
        if (endCalendar.before(nowCalendar)) {
            throw (Throwable)new IllegalArgumentException("Wrong endTime release phase value = '" + releasePhase.getEndTime() + "'. It less than current moment.");
        }
        Calendar calendar2 = startCalendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"startCalendar");
        calendar2.setTime(sdf.parse(releasePhase.getStartTime()));
        if (startCalendar.after(endCalendar)) {
            throw (Throwable)new IllegalArgumentException("Wrong startTime release phase value = '" + releasePhase.getStartTime() + "'. " + "It bigger than endTime = '" + releasePhase.getEndTime() + "'.");
        }
    }

    public ConfigProvider(@NotNull HuaweiPublishExtensionConfig extension, @NotNull HuaweiPublishCliParam cli, @NotNull BuildFileProvider buildFileProvider) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)cli, (String)"cli");
        Intrinsics.checkNotNullParameter((Object)buildFileProvider, (String)"buildFileProvider");
        this.extension = extension;
        this.cli = cli;
        this.buildFileProvider = buildFileProvider;
    }

    public static final /* synthetic */ HuaweiPublishExtensionConfig access$getExtension$p(ConfigProvider $this) {
        return $this.extension;
    }
}

