/*
 * Decompiled with CFR 0.152.
 */
package ru.cian.huawei.publish.utils;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.BuiltArtifact;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cian.huawei.publish.BuildFormat;
import ru.cian.huawei.publish.utils.BuildFileProvider;
import ru.cian.huawei.publish.utils.BuildFileProvider$WhenMappings;
import ru.cian.huawei.publish.utils.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lru/cian/huawei/publish/utils/BuildFileProvider;", "", "variant", "Lcom/android/build/api/variant/ApplicationVariant;", "logger", "Lru/cian/huawei/publish/utils/Logger;", "(Lcom/android/build/api/variant/ApplicationVariant;Lru/cian/huawei/publish/utils/Logger;)V", "getBuildFile", "Ljava/io/File;", "buildFormat", "Lru/cian/huawei/publish/BuildFormat;", "getFinalApkArtifactCompat", "", "getFinalBundleArtifactCompat", "plugin"})
public final class BuildFileProvider {
    private final ApplicationVariant variant;
    private final Logger logger;

    @Nullable
    public final File getBuildFile(@NotNull BuildFormat buildFormat) {
        File file;
        Intrinsics.checkNotNullParameter((Object)((Object)buildFormat), (String)"buildFormat");
        switch (BuildFileProvider$WhenMappings.$EnumSwitchMapping$0[buildFormat.ordinal()]) {
            case 1: {
                file = (File)CollectionsKt.singleOrNull(this.getFinalApkArtifactCompat(this.variant));
                break;
            }
            case 2: {
                file = (File)CollectionsKt.singleOrNull(this.getFinalBundleArtifactCompat(this.variant));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getFinalApkArtifactCompat(ApplicationVariant variant) {
        List list;
        Object object = variant.getArtifacts().get((SingleArtifact)SingleArtifact.APK.INSTANCE).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant.artifacts.get(SingleArtifact.APK).get()");
        Directory apkDirectory = (Directory)object;
        this.logger.v("Build File Directory: " + apkDirectory);
        Object object2 = variant.getArtifacts().getBuiltArtifactsLoader().load(apkDirectory);
        if (object2 != null && (object2 = object2.getElements()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void element;
                BuiltArtifact builtArtifact = (BuiltArtifact)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file = new File(element.getOutputFile());
                collection.add(file);
            }
            list = (List)destination$iv$iv;
        } else {
            Object object3;
            String it;
            Collection collection;
            FileTree fileTree = apkDirectory.getAsFileTree().matching((Action)getFinalApkArtifactCompat.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"apkDirectory.asFileTree.\u2026hing { include(\"*.apk\") }");
            Iterable $this$map$iv = (Iterable)fileTree;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File element = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                object3 = v4.getAbsolutePath();
                collection.add(object3);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object3 = new File(it);
                collection.add(object3);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final List<File> getFinalBundleArtifactCompat(ApplicationVariant variant) {
        Object object = variant.getArtifacts().get((SingleArtifact)SingleArtifact.BUNDLE.INSTANCE).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant.artifacts.get(SingleArtifact.BUNDLE).get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"variant.artifacts.get(Si\u2026fact.BUNDLE).get().asFile");
        File aabFile = file;
        return CollectionsKt.listOf((Object)aabFile);
    }

    public BuildFileProvider(@NotNull ApplicationVariant variant, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.variant = variant;
        this.logger = logger2;
    }
}

