/*
 * Decompiled with CFR 0.152.
 */
package ru.cian.huawei.publish;

import com.android.build.api.variant.ApplicationVariant;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cian.huawei.publish.BuildFormat;
import ru.cian.huawei.publish.DeployType;
import ru.cian.huawei.publish.HuaweiPublishCliParam;
import ru.cian.huawei.publish.HuaweiPublishConfig;
import ru.cian.huawei.publish.HuaweiPublishExtension;
import ru.cian.huawei.publish.HuaweiPublishExtensionConfig;
import ru.cian.huawei.publish.HuaweiPublishTask;
import ru.cian.huawei.publish.ReleaseNotesConfig;
import ru.cian.huawei.publish.ReleaseNotesDescriptionsConfig;
import ru.cian.huawei.publish.ReleasePhaseConfig;
import ru.cian.huawei.publish.models.request.FileInfoRequest;
import ru.cian.huawei.publish.models.response.AppInfo;
import ru.cian.huawei.publish.models.response.FileInfo;
import ru.cian.huawei.publish.models.response.FileServerOriResultResponse;
import ru.cian.huawei.publish.models.response.SubmitResponse;
import ru.cian.huawei.publish.models.response.UpdateAppBasicInfoResponse;
import ru.cian.huawei.publish.models.response.UpdateAppFileInfoResponse;
import ru.cian.huawei.publish.models.response.UploadFileRsp;
import ru.cian.huawei.publish.models.response.UploadUrlResponse;
import ru.cian.huawei.publish.service.HuaweiService;
import ru.cian.huawei.publish.service.HuaweiServiceImpl;
import ru.cian.huawei.publish.service.MockHuaweiService;
import ru.cian.huawei.publish.utils.BuildFileProvider;
import ru.cian.huawei.publish.utils.ConfigProvider;
import ru.cian.huawei.publish.utils.FileWrapper;
import ru.cian.huawei.publish.utils.KotlinExtensionsKt;
import ru.cian.huawei.publish.utils.Logger;
import ru.cian.huawei.publish.utils.ServerPollingExecutor;

@DisableCachingByDefault
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 c2\u00020\u0001:\u0002cdB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010L\u001a\u00020MH\u0007J8\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\r2\u0006\u0010W\u001a\u00020\r2\u0006\u0010X\u001a\u00020YH\u0002J\u001e\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\rH\u0002J&\u0010`\u001a\u00020M2\u0006\u00103\u001a\u00020a2\u0006\u00106\u001a\u00020a2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0bH\u0002R,\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068G@GX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR0\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R*\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R*\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u00188G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR*\u0010\u001e\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R*\u0010!\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0012\"\u0004\b#\u0010\u0014R*\u0010$\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010\u0014R*\u0010(\u001a\u0004\u0018\u00010'2\b\u0010\u0005\u001a\u0004\u0018\u00010'8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001b\u0010-\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b/\u00100R*\u00103\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0012\"\u0004\b5\u0010\u0014R*\u00106\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0012\"\u0004\b8\u0010\u0014R0\u00109\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b:\u0010\u0010\u001a\u0004\b;\u0010\u0012\"\u0004\b<\u0010\u0014R*\u0010=\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0012\"\u0004\b?\u0010\u0014R*\u0010@\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u0012\"\u0004\bB\u0010\u0014R*\u0010C\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0012\"\u0004\bE\u0010\u0014R*\u0010F\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u0012\"\u0004\bH\u0010\u0014R,\u0010I\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068G@GX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\bJ\u0010\t\"\u0004\bK\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lru/cian/huawei/publish/HuaweiPublishTask;", "Lorg/gradle/api/DefaultTask;", "variant", "Lcom/android/build/api/variant/ApplicationVariant;", "(Lcom/android/build/api/variant/ApplicationVariant;)V", "<set-?>", "", "apiStub", "getApiStub", "()Ljava/lang/Boolean;", "setApiStub", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "", "appBasicInfo", "getAppBasicInfo$annotations", "()V", "getAppBasicInfo", "()Ljava/lang/String;", "setAppBasicInfo", "(Ljava/lang/String;)V", "buildFile", "getBuildFile", "setBuildFile", "Lru/cian/huawei/publish/BuildFormat;", "buildFormat", "getBuildFormat", "()Lru/cian/huawei/publish/BuildFormat;", "setBuildFormat", "(Lru/cian/huawei/publish/BuildFormat;)V", "clientId", "getClientId", "setClientId", "clientSecret", "getClientSecret", "setClientSecret", "credentialsPath", "getCredentialsPath", "setCredentialsPath", "Lru/cian/huawei/publish/DeployType;", "deployType", "getDeployType", "()Lru/cian/huawei/publish/DeployType;", "setDeployType", "(Lru/cian/huawei/publish/DeployType;)V", "logger", "Lru/cian/huawei/publish/utils/Logger;", "getLogger", "()Lru/cian/huawei/publish/utils/Logger;", "logger$delegate", "Lkotlin/Lazy;", "publishPeriodMs", "getPublishPeriodMs", "setPublishPeriodMs", "publishTimeoutMs", "getPublishTimeoutMs", "setPublishTimeoutMs", "releaseNotes", "getReleaseNotes$annotations", "getReleaseNotes", "setReleaseNotes", "releasePhaseEndTime", "getReleasePhaseEndTime", "setReleasePhaseEndTime", "releasePhasePercent", "getReleasePhasePercent", "setReleasePhasePercent", "releasePhaseStartTime", "getReleasePhaseStartTime", "setReleasePhaseStartTime", "releaseTime", "getReleaseTime", "setReleaseTime", "removeHtmlTags", "getRemoveHtmlTags", "setRemoveHtmlTags", "action", "", "getSubmitResponse", "Lru/cian/huawei/publish/models/response/SubmitResponse;", "releaseType", "Lru/cian/huawei/publish/HuaweiPublishTask$ReleaseType;", "huaweiService", "Lru/cian/huawei/publish/service/HuaweiService;", "config", "Lru/cian/huawei/publish/HuaweiPublishConfig;", "token", "appId", "releasePercent", "", "mapFileInfo", "", "Lru/cian/huawei/publish/models/request/FileInfoRequest;", "fileInfoListResult", "Lru/cian/huawei/publish/models/response/FileServerOriResultResponse;", "buildFileName", "submitReleaseByServerPolling", "", "Lkotlin/Function0;", "Companion", "ReleaseType", "plugin"})
@SourceDebugExtension(value={"SMAP\nHuaweiPublishTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuaweiPublishTask.kt\nru/cian/huawei/publish/HuaweiPublishTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,421:1\n1#2:422\n1864#3,3:423\n1855#3,2:426\n*S KotlinDebug\n*F\n+ 1 HuaweiPublishTask.kt\nru/cian/huawei/publish/HuaweiPublishTask\n*L\n248#1:423,3\n399#1:426,2\n*E\n"})
public class HuaweiPublishTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationVariant variant;
    @NotNull
    private final Lazy logger$delegate;
    @Nullable
    private DeployType deployType;
    @Nullable
    private String publishTimeoutMs;
    @Nullable
    private String publishPeriodMs;
    @Nullable
    private String credentialsPath;
    @Nullable
    private String clientId;
    @Nullable
    private String clientSecret;
    @Nullable
    private BuildFormat buildFormat;
    @Nullable
    private String buildFile;
    @Nullable
    private String releaseTime;
    @Nullable
    private String releasePhaseStartTime;
    @Nullable
    private String releasePhaseEndTime;
    @Nullable
    private String releasePhasePercent;
    @Nullable
    private String releaseNotes;
    @Nullable
    private Boolean removeHtmlTags;
    @Nullable
    private Boolean apiStub;
    @Nullable
    private String appBasicInfo;
    @NotNull
    public static final String TASK_NAME = "publishHuaweiAppGallery";
    private static final double FULL_USER_SUBMISSION_PERCENT = 100.0;

    @Inject
    public HuaweiPublishTask(@NotNull ApplicationVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.variant = variant;
        this.setGroup("publishing");
        this.setDescription("Upload and publish application build file to Huawei AppGallery Store for " + this.variant.getName() + " buildType");
        this.logger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ HuaweiPublishTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Logger invoke() {
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return new Logger(project);
            }
        }));
        this.apiStub = false;
    }

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    @Internal
    @Nullable
    public final DeployType getDeployType() {
        return this.deployType;
    }

    @Option(option="deployType", description="How to deploy build: 'publish' to all users or create 'draft' without publishing or 'upload-only' without draft creation")
    public final void setDeployType(@Nullable DeployType deployType) {
        this.deployType = deployType;
    }

    @Internal
    @Nullable
    public final String getPublishTimeoutMs() {
        return this.publishTimeoutMs;
    }

    @Option(option="publishTimeoutMs", description="The time in millis during which the plugin periodically tries to publish the build")
    public final void setPublishTimeoutMs(@Nullable String string) {
        this.publishTimeoutMs = string;
    }

    @Internal
    @Nullable
    public final String getPublishPeriodMs() {
        return this.publishPeriodMs;
    }

    @Option(option="publishPeriodMs", description="The period in millis between tries to publish the build")
    public final void setPublishPeriodMs(@Nullable String string) {
        this.publishPeriodMs = string;
    }

    @Internal
    @Nullable
    public final String getCredentialsPath() {
        return this.credentialsPath;
    }

    @Option(option="credentialsPath", description="File path with AppGallery credentials params ('client_id' and 'client_secret')")
    public final void setCredentialsPath(@Nullable String string) {
        this.credentialsPath = string;
    }

    @Internal
    @Nullable
    public final String getClientId() {
        return this.clientId;
    }

    @Option(option="clientId", description="'client_id' param from AppGallery credentials. The key more priority than value from 'credentialsPath'")
    public final void setClientId(@Nullable String string) {
        this.clientId = string;
    }

    @Internal
    @Nullable
    public final String getClientSecret() {
        return this.clientSecret;
    }

    @Option(option="clientSecret", description="'client_secret' param from AppGallery credentials. The key more priority than value from 'credentialsPath'")
    public final void setClientSecret(@Nullable String string) {
        this.clientSecret = string;
    }

    @Internal
    @Nullable
    public final BuildFormat getBuildFormat() {
        return this.buildFormat;
    }

    @Option(option="buildFormat", description="'apk' or 'aab' for corresponding build format")
    public final void setBuildFormat(@Nullable BuildFormat buildFormat) {
        this.buildFormat = buildFormat;
    }

    @Internal
    @Nullable
    public final String getBuildFile() {
        return this.buildFile;
    }

    @Option(option="buildFile", description="Path to build file. 'null' means use standard path for 'apk' and 'aab' files.")
    public final void setBuildFile(@Nullable String string) {
        this.buildFile = string;
    }

    @Internal
    @Nullable
    public final String getReleaseTime() {
        return this.releaseTime;
    }

    @Option(option="releaseTime", description="Release time in UTC format. The format is yyyy-MM-dd'T'HH:mm:ssZZ.")
    public final void setReleaseTime(@Nullable String string) {
        this.releaseTime = string;
    }

    @Internal
    @Nullable
    public final String getReleasePhaseStartTime() {
        return this.releasePhaseStartTime;
    }

    @Option(option="releasePhaseStartTime", description="Start release time after review in UTC format. The format is yyyy-MM-dd'T'HH:mm:ssZZ.")
    public final void setReleasePhaseStartTime(@Nullable String string) {
        this.releasePhaseStartTime = string;
    }

    @Internal
    @Nullable
    public final String getReleasePhaseEndTime() {
        return this.releasePhaseEndTime;
    }

    @Option(option="releasePhaseEndTime", description="End release time after review in UTC format. The format is yyyy-MM-dd'T'HH:mm:ssZZ.")
    public final void setReleasePhaseEndTime(@Nullable String string) {
        this.releasePhaseEndTime = string;
    }

    @Internal
    @Nullable
    public final String getReleasePhasePercent() {
        return this.releasePhasePercent;
    }

    @Option(option="releasePhasePercent", description="Percentage of target users of release by phase. The integer or decimal value from 0 to 100.")
    public final void setReleasePhasePercent(@Nullable String string) {
        this.releasePhasePercent = string;
    }

    @Internal
    @Nullable
    public final String getReleaseNotes() {
        return this.releaseNotes;
    }

    @Option(option="releaseNotes", description="Release Notes. Format: '<lang_1>:<releaseNotes_FilePath_1>;<lang_2>:<releaseNotes_FilePath_2>'. See https://developer.huawei.com/consumer/en/doc/development/AppGallery-connect-References/agcapi-reference-langtype-0000001158245079 to choose `lang` param")
    public final void setReleaseNotes(@Nullable String string) {
        this.releaseNotes = string;
    }

    public static /* synthetic */ void getReleaseNotes$annotations() {
    }

    @Internal
    @Nullable
    public final Boolean getRemoveHtmlTags() {
        return this.removeHtmlTags;
    }

    @Option(option="removeHtmlTags", description="EXPERIMENTAL (Default: False). True - if needs to remove html tags from provided release notes. For example, to support Google Play release notes.")
    public final void setRemoveHtmlTags(@Nullable Boolean bl) {
        this.removeHtmlTags = bl;
    }

    @Internal
    @Nullable
    public final Boolean getApiStub() {
        return this.apiStub;
    }

    @Option(option="apiStub", description="Use RestAPI stub instead of real RestAPI requests")
    public final void setApiStub(@Nullable Boolean bl) {
        this.apiStub = bl;
    }

    @Internal
    @Nullable
    public final String getAppBasicInfo() {
        return this.appBasicInfo;
    }

    @Option(option="appBasicInfo", description="path to json file. See https://developer.huawei.com/consumer/en/doc/development/AppGallery-connect-References/agcapi-app-info-update-0000001111685198#section17512144171520")
    public final void setAppBasicInfo(@Nullable String string) {
        this.appBasicInfo = string;
    }

    public static /* synthetic */ void getAppBasicInfo$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        Object v1;
        String buildTypeName;
        HuaweiService huaweiService;
        block13: {
            huaweiService = Intrinsics.areEqual((Object)this.apiStub, (Object)true) ? (HuaweiService)new MockHuaweiService() : (HuaweiService)new HuaweiServiceImpl(this.getLogger());
            Object object = this.getProject().getExtensions().findByName("huaweiPublish");
            HuaweiPublishExtension huaweiPublishExtension = object instanceof HuaweiPublishExtension ? (HuaweiPublishExtension)object : null;
            if (huaweiPublishExtension == null) {
                throw new IllegalArgumentException("Plugin extension 'huaweiPublish' is not available at build.gradle of the application module");
            }
            HuaweiPublishExtension huaweiPublishExtension2 = huaweiPublishExtension;
            buildTypeName = this.variant.getName();
            Iterable iterable = (Iterable)huaweiPublishExtension2.getInstances();
            for (Object t : iterable) {
                HuaweiPublishExtensionConfig it = (HuaweiPublishExtensionConfig)t;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getName(), (String)buildTypeName, (boolean)true)) continue;
                v1 = t;
                break block13;
            }
            v1 = null;
        }
        HuaweiPublishExtensionConfig huaweiPublishExtensionConfig = v1;
        if (huaweiPublishExtensionConfig == null) {
            throw new IllegalArgumentException("Plugin extension 'huaweiPublish' instance with name '" + buildTypeName + "' is not available");
        }
        HuaweiPublishExtensionConfig extension = huaweiPublishExtensionConfig;
        HuaweiPublishCliParam cli = new HuaweiPublishCliParam(this.deployType, this.publishTimeoutMs, this.publishPeriodMs, this.credentialsPath, this.clientId, this.clientSecret, this.buildFormat, this.buildFile, this.releaseTime, this.releasePhaseStartTime, this.releasePhaseEndTime, this.releasePhasePercent, this.releaseNotes, this.removeHtmlTags, this.apiStub, this.appBasicInfo);
        this.getLogger().i("extension=" + extension);
        this.getLogger().i("cli=" + cli);
        this.getLogger().v("Prepare input config");
        BuildFileProvider buildFileProvider = new BuildFileProvider(this.variant, this.getLogger());
        HuaweiPublishConfig config = new ConfigProvider(extension, cli, buildFileProvider, new FileWrapper()).getConfig();
        this.getLogger().i("config=" + config);
        this.getLogger().v("Found build file: `" + config.getArtifactFile().getName() + "`");
        this.getLogger().v("Get Access Token");
        String token = huaweiService.getToken(config.getCredentials().getClientId(), config.getCredentials().getClientSecret());
        this.getLogger().i("token=" + token);
        this.getLogger().v("Get App ID");
        Object object = this.variant.getApplicationId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant.applicationId.get()");
        String applicationId = (String)object;
        AppInfo appInfo = huaweiService.getAppID(config.getCredentials().getClientId(), token, applicationId);
        this.getLogger().i("appInfo=" + appInfo);
        this.getLogger().v("Get Upload Url");
        UploadUrlResponse uploadUrl = huaweiService.getUploadingBuildUrl(config.getCredentials().getClientId(), token, appInfo.getValue(), config.getArtifactFormat().getFileExtension());
        this.getLogger().i("uploadUrl=" + uploadUrl);
        this.getLogger().v("Upload build file '" + config.getArtifactFile().getPath() + "'");
        FileServerOriResultResponse fileInfoListResult = huaweiService.uploadBuildFile(uploadUrl.getUploadUrl(), uploadUrl.getAuthCode(), config.getArtifactFile());
        this.getLogger().i("fileInfoListResult=" + fileInfoListResult);
        ReleaseNotesConfig releaseNotesConfig = config.getReleaseNotes();
        Collection collection = releaseNotesConfig != null ? releaseNotesConfig.getDescriptions() : null;
        if (!(collection == null || collection.isEmpty())) {
            Object object2 = config.getReleaseNotes();
            if (object2 != null && (object2 = ((ReleaseNotesConfig)object2).getDescriptions()) != null) {
                Iterable $this$forEachIndexed$iv = (Iterable)object2;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void releaseNote;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ReleaseNotesDescriptionsConfig releaseNotesDescriptionsConfig = (ReleaseNotesDescriptionsConfig)item$iv;
                    int index = n;
                    boolean bl = false;
                    String newFeatures = releaseNote.getNewFeatures();
                    this.getLogger().v("Upload release notes: " + (index + 1) + "/" + config.getReleaseNotes().getDescriptions().size() + ", lang=" + releaseNote.getLang());
                    this.getLogger().i("Upload release notes: " + (index + 1) + "/" + config.getReleaseNotes().getDescriptions().size() + ", lang=" + releaseNote.getLang() + ", removeHtmlTags=" + config.getReleaseNotes().getRemoveHtmlTags() + ", features=" + newFeatures);
                    huaweiService.updateReleaseNotes(config.getCredentials().getClientId(), token, appInfo.getValue(), releaseNote.getLang(), newFeatures);
                }
            }
        } else {
            this.getLogger().v("Skip release notes uploading");
        }
        if (config.getDeployType() != DeployType.UPLOAD_ONLY) {
            this.getLogger().v("Update App File Info");
            String string = config.getArtifactFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.artifactFile.name");
            List<FileInfoRequest> fileInfoRequestList = this.mapFileInfo(fileInfoListResult, string);
            String appId = appInfo.getValue();
            ReleasePhaseConfig releasePhaseConfig = config.getReleasePhase();
            double releasePercent = releasePhaseConfig != null ? releasePhaseConfig.getPercent() : 100.0;
            ReleaseType releaseType = releasePercent == 100.0 ? ReleaseType.FULL : ReleaseType.PHASE;
            this.getLogger().i("fileInfoRequestList=" + fileInfoRequestList);
            UpdateAppFileInfoResponse updateAppFileInformation = huaweiService.updateAppFileInformation(config.getCredentials().getClientId(), token, appId, releaseType.getType(), fileInfoRequestList);
            this.getLogger().i("updateAppFileInformation=" + updateAppFileInformation);
            if (config.getAppBasicInfoFile() != null) {
                UpdateAppBasicInfoResponse updateAppInformation = huaweiService.updateAppBasicInfo(config.getCredentials().getClientId(), token, appId, releaseType.getType(), FilesKt.readText$default((File)config.getAppBasicInfoFile(), null, (int)1, null));
                this.getLogger().i("updateAppInformation=" + updateAppInformation);
            }
            if (config.getDeployType() == DeployType.PUBLISH) {
                this.getLogger().v("Submit Review");
                Function0 submitRequestFunction2 = (Function0)new Function0<SubmitResponse>(this, releaseType, huaweiService, config, token, appId, releasePercent){
                    final /* synthetic */ HuaweiPublishTask this$0;
                    final /* synthetic */ ReleaseType $releaseType;
                    final /* synthetic */ HuaweiService $huaweiService;
                    final /* synthetic */ HuaweiPublishConfig $config;
                    final /* synthetic */ String $token;
                    final /* synthetic */ String $appId;
                    final /* synthetic */ double $releasePercent;
                    {
                        this.this$0 = $receiver;
                        this.$releaseType = $releaseType;
                        this.$huaweiService = $huaweiService;
                        this.$config = $config;
                        this.$token = $token;
                        this.$appId = $appId;
                        this.$releasePercent = $releasePercent;
                        super(0);
                    }

                    @NotNull
                    public final SubmitResponse invoke() {
                        return HuaweiPublishTask.access$getSubmitResponse(this.this$0, this.$releaseType, this.$huaweiService, this.$config, this.$token, this.$appId, this.$releasePercent);
                    }
                };
                this.submitReleaseByServerPolling(config.getPublishPeriodMs(), config.getPublishTimeoutMs(), (Function0<Unit>)((Function0)new Function0<Unit>((Function0<SubmitResponse>)submitRequestFunction2, this){
                    final /* synthetic */ Function0<SubmitResponse> $submitRequestFunction;
                    final /* synthetic */ HuaweiPublishTask this$0;
                    {
                        this.$submitRequestFunction = $submitRequestFunction;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        SubmitResponse submitResponse = (SubmitResponse)this.$submitRequestFunction.invoke();
                        HuaweiPublishTask.access$getLogger(this.this$0).i("submitResponse=" + submitResponse);
                        submitResponse.getRet();
                    }
                }));
                this.getLogger().v("Upload build file with submit on " + releasePercent + "% users - Successfully Done!");
            } else {
                this.getLogger().v("Upload build file draft without submit on users - Successfully Done!");
            }
        } else {
            this.getLogger().v("Upload build file without draft and submit on users - Successfully Done!");
        }
    }

    private final SubmitResponse getSubmitResponse(ReleaseType releaseType, HuaweiService huaweiService, HuaweiPublishConfig config, String token, String appId, double releasePercent) {
        return switch (WhenMappings.$EnumSwitchMapping$0[releaseType.ordinal()]) {
            case 1 -> huaweiService.submitReviewImmediately(config.getCredentials().getClientId(), token, appId, config.getReleaseTime());
            case 2 -> {
                ReleasePhaseConfig v1 = config.getReleasePhase();
                ReleasePhaseConfig v2 = config.getReleasePhase();
                yield huaweiService.submitReviewWithReleasePhase(config.getCredentials().getClientId(), token, appId, v1 != null ? v1.getStartTime() : null, v2 != null ? v2.getEndTime() : null, releasePercent);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void submitReleaseByServerPolling(long publishPeriodMs, long publishTimeoutMs, Function0<Unit> action2) {
        new ServerPollingExecutor().run(publishPeriodMs, publishTimeoutMs, (Function0<Unit>)((Function0)new Function0<Unit>(action2){
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$action = $action;
                super(0);
            }

            public final void invoke() {
                this.$action.invoke();
            }
        }), (Function2<? super Long, ? super Exception, Unit>)((Function2)new Function2<Long, Exception, Unit>(this){
            final /* synthetic */ HuaweiPublishTask this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(long timeLeft, @NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                HuaweiPublishTask.access$getLogger(this.this$0).v("Action failed! Reason: '" + exception + "'. Timeout left '" + KotlinExtensionsKt.toHumanPrettyFormatInterval(timeLeft) + "'.");
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ HuaweiPublishTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                HuaweiPublishTask.access$getLogger(this.this$0).v("Uploading successfully finished");
            }
        }), (Function1<? super Exception, Unit>)((Function1)submitReleaseByServerPolling.4.INSTANCE));
    }

    private final List<FileInfoRequest> mapFileInfo(FileServerOriResultResponse fileInfoListResult, String buildFileName) {
        List fileInfoRequestList;
        block1: {
            UploadFileRsp uploadFileRsp = fileInfoListResult.getResult().getUploadFileRsp();
            List<FileInfo> fileInfoList = uploadFileRsp != null ? uploadFileRsp.getFileInfoList() : null;
            fileInfoRequestList = new ArrayList();
            List<FileInfo> list = fileInfoList;
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileInfo it = (FileInfo)element$iv;
                boolean bl = false;
                fileInfoRequestList.add(new FileInfoRequest(buildFileName, it.getFileDestUlr(), it.getSize()));
            }
        }
        return fileInfoRequestList;
    }

    public static final /* synthetic */ SubmitResponse access$getSubmitResponse(HuaweiPublishTask $this, ReleaseType releaseType, HuaweiService huaweiService, HuaweiPublishConfig config, String token, String appId, double releasePercent) {
        return $this.getSubmitResponse(releaseType, huaweiService, config, token, appId, releasePercent);
    }

    public static final /* synthetic */ Logger access$getLogger(HuaweiPublishTask $this) {
        return $this.getLogger();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lru/cian/huawei/publish/HuaweiPublishTask$Companion;", "", "()V", "FULL_USER_SUBMISSION_PERCENT", "", "TASK_NAME", "", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lru/cian/huawei/publish/HuaweiPublishTask$ReleaseType;", "", "type", "", "(Ljava/lang/String;II)V", "getType", "()I", "FULL", "PHASE", "plugin"})
    public static final class ReleaseType
    extends Enum<ReleaseType> {
        private final int type;
        public static final /* enum */ ReleaseType FULL = new ReleaseType(1);
        public static final /* enum */ ReleaseType PHASE = new ReleaseType(3);
        private static final /* synthetic */ ReleaseType[] $VALUES;

        private ReleaseType(int type2) {
            this.type = type2;
        }

        public final int getType() {
            return this.type;
        }

        public static ReleaseType[] values() {
            return (ReleaseType[])$VALUES.clone();
        }

        public static ReleaseType valueOf(String value) {
            return Enum.valueOf(ReleaseType.class, value);
        }

        static {
            $VALUES = releaseTypeArray = new ReleaseType[]{ReleaseType.FULL, ReleaseType.PHASE};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReleaseType.values().length];
            try {
                nArray[ReleaseType.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReleaseType.PHASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

