/*
 * Decompiled with CFR 0.152.
 */
package ru.cian.huawei.publish.service;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cian.huawei.publish.models.HuaweiHttpResponseException;
import ru.cian.huawei.publish.models.request.AccessTokenRequest;
import ru.cian.huawei.publish.models.request.FileInfoRequest;
import ru.cian.huawei.publish.models.request.PhasedReleaseRequest;
import ru.cian.huawei.publish.models.request.UpdateAppFileInfoRequest;
import ru.cian.huawei.publish.models.request.UpdateReleaseNotesRequest;
import ru.cian.huawei.publish.models.response.AccessTokenResponse;
import ru.cian.huawei.publish.models.response.AppIdResponse;
import ru.cian.huawei.publish.models.response.AppInfo;
import ru.cian.huawei.publish.models.response.FileServerOriResultResponse;
import ru.cian.huawei.publish.models.response.SubmitResponse;
import ru.cian.huawei.publish.models.response.UpdateAppBasicInfoResponse;
import ru.cian.huawei.publish.models.response.UpdateAppFileInfoResponse;
import ru.cian.huawei.publish.models.response.UpdateReleaseNotesResponse;
import ru.cian.huawei.publish.models.response.UploadUrlResponse;
import ru.cian.huawei.publish.service.HttpClientHelper;
import ru.cian.huawei.publish.service.HuaweiService;
import ru.cian.huawei.publish.utils.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0016J:\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J<\u0010 \u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\f2\b\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020$H\u0016J0\u0010%\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\fH\u0016J6\u0010(\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J0\u0010-\u001a\u00020.2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\fH\u0016J \u00101\u001a\u0002022\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u000206H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lru/cian/huawei/publish/service/HuaweiServiceImpl;", "Lru/cian/huawei/publish/service/HuaweiService;", "logger", "Lru/cian/huawei/publish/utils/Logger;", "(Lru/cian/huawei/publish/utils/Logger;)V", "gson", "Lcom/google/gson/Gson;", "httpClient", "Lru/cian/huawei/publish/service/HttpClientHelper;", "getAppID", "Lru/cian/huawei/publish/models/response/AppInfo;", "clientId", "", "accessToken", "packageName", "getSubmissionCompletedResponse", "Lru/cian/huawei/publish/models/response/SubmitResponse;", "submitResponse", "token", "appId", "releaseTime", "getToken", "clientSecret", "getUploadingBuildUrl", "Lru/cian/huawei/publish/models/response/UploadUrlResponse;", "suffix", "submitReview", "releaseType", "", "requestBody", "Lokhttp3/RequestBody;", "submitReviewImmediately", "submitReviewWithReleasePhase", "startRelease", "endRelease", "releasePercent", "", "updateAppBasicInfo", "Lru/cian/huawei/publish/models/response/UpdateAppBasicInfoResponse;", "appBasicInfo", "updateAppFileInformation", "Lru/cian/huawei/publish/models/response/UpdateAppFileInfoResponse;", "fileInfoRequestList", "", "Lru/cian/huawei/publish/models/request/FileInfoRequest;", "updateReleaseNotes", "Lru/cian/huawei/publish/models/response/UpdateReleaseNotesResponse;", "lang", "newFeatures", "uploadBuildFile", "Lru/cian/huawei/publish/models/response/FileServerOriResultResponse;", "uploadUrl", "authCode", "buildFile", "Ljava/io/File;", "plugin"})
@SourceDebugExtension(value={"SMAP\nHuaweiServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuaweiServiceImpl.kt\nru/cian/huawei/publish/service/HuaweiServiceImpl\n+ 2 HttpClientHelper.kt\nru/cian/huawei/publish/service/HttpClientHelper\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,325:1\n21#2,12:326\n33#2,16:341\n18#2,15:357\n33#2,16:375\n18#2,15:391\n33#2,16:409\n21#2,12:425\n33#2,16:440\n24#2,9:456\n33#2,16:468\n24#2,9:484\n33#2,16:496\n24#2,9:512\n33#2,16:524\n21#2,12:540\n33#2,16:555\n1#3:338\n1#3:372\n1#3:406\n1#3:437\n1#3:465\n1#3:493\n1#3:521\n1#3:552\n215#4,2:339\n215#4,2:373\n215#4,2:407\n215#4,2:438\n215#4,2:466\n215#4,2:494\n215#4,2:522\n215#4,2:553\n*S KotlinDebug\n*F\n+ 1 HuaweiServiceImpl.kt\nru/cian/huawei/publish/service/HuaweiServiceImpl\n*L\n54#1:326,12\n54#1:341,16\n73#1:357,15\n73#1:375,16\n94#1:391,15\n94#1:409,16\n118#1:425,12\n118#1:440,16\n148#1:456,9\n148#1:468,16\n178#1:484,9\n178#1:496,16\n280#1:512,9\n280#1:524,16\n316#1:540,12\n316#1:555,16\n54#1:338\n73#1:372\n94#1:406\n118#1:437\n148#1:465\n178#1:493\n280#1:521\n316#1:552\n54#1:339,2\n73#1:373,2\n94#1:407,2\n118#1:438,2\n148#1:466,2\n178#1:494,2\n280#1:522,2\n316#1:553,2\n*E\n"})
public final class HuaweiServiceImpl
implements HuaweiService {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Gson gson;
    @NotNull
    private final HttpClientHelper httpClient;

    public HuaweiServiceImpl(@NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
        this.gson = new Gson();
        this.httpClient = new HttpClientHelper(this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getToken(@NotNull String clientId, @NotNull String clientSecret) {
        Object object;
        void this_$iv$iv;
        void body$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        AccessTokenRequest bodyRequest = new AccessTokenRequest(clientId, clientSecret, "client_credentials");
        HttpClientHelper httpClientHelper = this.httpClient;
        String string = "https://connect-api.cloud.huawei.com/api/oauth2/v1/token";
        String string2 = this.gson.toJson((Object)bodyRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gson.toJson(bodyRequest)");
        RequestBody requestBody = RequestBody.Companion.create(string2, HttpClientHelper.Companion.getMEDIA_TYPE_JSON());
        Object var8_7 = null;
        boolean $i$f$post = false;
        void var10_9 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().post((RequestBody)body$iv);
        boolean $i$f$execute = false;
        try {
            void url$iv;
            Object object2;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Request.Builder $this$execute_u24lambda_u241$iv$iv = object2 = requestBuilder$iv$iv.url((String)url$iv);
            boolean bl = false;
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            Throwable throwable = null;
            try {
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl2 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                Object object3 = HttpClientHelper.access$getGson((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, AccessTokenResponse.class);
                if (object3 == null) {
                    throw new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            HttpClientHelper.access$getLogger$p((HttpClientHelper)this_$iv$iv).e((Exception)((Object)e$iv$iv));
            throw new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)object;
        String string3 = accessTokenResponse.getAccessToken();
        if (string3 == null) {
            throw new IllegalStateException("Can't get `accessToken`. Reason: '" + accessTokenResponse.getRet() + "'");
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AppInfo getAppID(@NotNull String clientId, @NotNull String accessToken, @NotNull String packageName) {
        Object object;
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Map headers = new LinkedHashMap();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("client_id", clientId);
        HttpClientHelper httpClientHelper = this.httpClient;
        String string = "https://connect-api.cloud.huawei.com/api/publish/v2/appid-list?packageName=" + packageName;
        boolean $i$f$get = false;
        void var9_8 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().get();
        boolean $i$f$execute = false;
        try {
            void url$iv;
            Object object2;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Request.Builder $this$execute_u24lambda_u241$iv$iv = object2 = requestBuilder$iv$iv.url((String)url$iv);
            boolean bl = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Object object3 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = object3.next();
                boolean bl2 = false;
                $this$execute_u24lambda_u241$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            Throwable throwable = null;
            try {
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl3 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                object3 = HttpClientHelper.access$getGson((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, AppIdResponse.class);
                if (object3 == null) {
                    throw new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            HttpClientHelper.access$getLogger$p((HttpClientHelper)this_$iv$iv).e((Exception)((Object)e$iv$iv));
            throw new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        AppIdResponse appIdResponse = (AppIdResponse)object;
        if (appIdResponse.getAppids().isEmpty()) {
            throw new IllegalStateException("`appids` must not be empty");
        }
        return appIdResponse.getAppids().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UploadUrlResponse getUploadingBuildUrl(@NotNull String clientId, @NotNull String accessToken, @NotNull String appId, @NotNull String suffix) {
        Object object;
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Map headers = new LinkedHashMap();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("client_id", clientId);
        HttpClientHelper httpClientHelper = this.httpClient;
        String string = "https://connect-api.cloud.huawei.com/api/publish/v2/upload-url?appId=" + appId + "&suffix=" + suffix;
        boolean $i$f$get = false;
        void var9_9 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().get();
        boolean $i$f$execute = false;
        try {
            void url$iv;
            Object object2;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Request.Builder $this$execute_u24lambda_u241$iv$iv = object2 = requestBuilder$iv$iv.url((String)url$iv);
            boolean bl = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Object object3 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = object3.next();
                boolean bl2 = false;
                $this$execute_u24lambda_u241$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            Throwable throwable = null;
            try {
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl3 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                object3 = HttpClientHelper.access$getGson((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, UploadUrlResponse.class);
                if (object3 == null) {
                    throw new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            HttpClientHelper.access$getLogger$p((HttpClientHelper)this_$iv$iv).e((Exception)((Object)e$iv$iv));
            throw new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        return (UploadUrlResponse)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FileServerOriResultResponse uploadBuildFile(@NotNull String uploadUrl, @NotNull String authCode, @NotNull File buildFile) {
        Object object;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uploadUrl, (String)"uploadUrl");
        Intrinsics.checkNotNullParameter((Object)authCode, (String)"authCode");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        RequestBody fileBody = RequestBody.Companion.create(buildFile, HttpClientHelper.Companion.getMEDIA_TYPE_AAB());
        MultipartBody requestBody = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM).addFormDataPart("file", buildFile.getName(), fileBody).addFormDataPart("authCode", authCode).addFormDataPart("fileCount", "1").addFormDataPart("parseType", "1").build();
        Map headers = new LinkedHashMap();
        headers.put("accept", "application/json");
        HttpClientHelper this_$iv = this.httpClient;
        boolean $i$f$post = false;
        HttpClientHelper httpClientHelper = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().post((RequestBody)requestBody);
        boolean $i$f$execute = false;
        try {
            Object object2;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Request.Builder $this$execute_u24lambda_u241$iv$iv = object2 = requestBuilder$iv$iv.url(uploadUrl);
            boolean bl = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Object object3 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = object3.next();
                boolean bl2 = false;
                $this$execute_u24lambda_u241$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            Throwable throwable = null;
            try {
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl3 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                object3 = HttpClientHelper.access$getGson((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, FileServerOriResultResponse.class);
                if (object3 == null) {
                    throw new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            HttpClientHelper.access$getLogger$p((HttpClientHelper)this_$iv$iv).e((Exception)((Object)e$iv$iv));
            throw new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        FileServerOriResultResponse result = (FileServerOriResultResponse)object;
        if (result.getResult().getResultCode() != 0) {
            throw new IllegalStateException("Build file uploading is failed!");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UpdateAppFileInfoResponse updateAppFileInformation(@NotNull String clientId, @NotNull String accessToken, @NotNull String appId, int releaseType, @NotNull List<FileInfoRequest> fileInfoRequestList) {
        Object object;
        void this_$iv$iv;
        void body$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(fileInfoRequestList, (String)"fileInfoRequestList");
        Map headers = new LinkedHashMap();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("client_id", clientId);
        UpdateAppFileInfoRequest bodyRequest = new UpdateAppFileInfoRequest(5, fileInfoRequestList);
        HttpClientHelper httpClientHelper = this.httpClient;
        String string = "https://connect-api.cloud.huawei.com/api/publish/v2/app-file-info?appId=" + appId + "&releaseType=" + releaseType;
        String string2 = this.gson.toJson((Object)bodyRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gson.toJson(bodyRequest)");
        RequestBody requestBody = RequestBody.Companion.create(string2, HttpClientHelper.Companion.getMEDIA_TYPE_JSON());
        boolean $i$f$put = false;
        void var13_12 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().put((RequestBody)body$iv);
        boolean $i$f$execute = false;
        try {
            void url$iv;
            Object object2;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Request.Builder $this$execute_u24lambda_u241$iv$iv = object2 = requestBuilder$iv$iv.url((String)url$iv);
            boolean bl = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Object object3 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = object3.next();
                boolean bl2 = false;
                $this$execute_u24lambda_u241$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            Throwable throwable = null;
            try {
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl3 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                object3 = HttpClientHelper.access$getGson((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, UpdateAppFileInfoResponse.class);
                if (object3 == null) {
                    throw new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            HttpClientHelper.access$getLogger$p((HttpClientHelper)this_$iv$iv).e((Exception)((Object)e$iv$iv));
            throw new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        UpdateAppFileInfoResponse result = (UpdateAppFileInfoResponse)object;
        if (result.getRet().getCode() != 0) {
            throw new IllegalStateException("Update App File Info is failed. Response: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UpdateReleaseNotesResponse updateReleaseNotes(@NotNull String clientId, @NotNull String accessToken, @NotNull String appId, @NotNull String lang, @NotNull String newFeatures) {
        Object object;
        void this_$iv$iv;
        void body$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)newFeatures, (String)"newFeatures");
        Map headers = new LinkedHashMap();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("client_id", clientId);
        UpdateReleaseNotesRequest bodyRequest = new UpdateReleaseNotesRequest(lang, newFeatures);
        HttpClientHelper httpClientHelper = this.httpClient;
        String string = "https://connect-api.cloud.huawei.com/api/publish/v2/app-language-info?appId=" + appId;
        String string2 = this.gson.toJson((Object)bodyRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gson.toJson(bodyRequest)");
        RequestBody requestBody = RequestBody.Companion.create(string2, HttpClientHelper.Companion.getMEDIA_TYPE_JSON());
        boolean $i$f$put = false;
        void var13_14 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().put((RequestBody)body$iv);
        boolean $i$f$execute = false;
        try {
            void url$iv;
            Object object2;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Request.Builder $this$execute_u24lambda_u241$iv$iv = object2 = requestBuilder$iv$iv.url((String)url$iv);
            boolean bl = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Object object3 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = object3.next();
                boolean bl2 = false;
                $this$execute_u24lambda_u241$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            Throwable throwable = null;
            try {
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl3 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                object3 = HttpClientHelper.access$getGson((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, UpdateReleaseNotesResponse.class);
                if (object3 == null) {
                    throw new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            HttpClientHelper.access$getLogger$p((HttpClientHelper)this_$iv$iv).e((Exception)((Object)e$iv$iv));
            throw new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        UpdateReleaseNotesResponse result = (UpdateReleaseNotesResponse)object;
        if (!(result.getRet().getCode() == 0)) {
            boolean bl = false;
            String string3 = "Update Release Notes for '" + lang + "' is failed. Response: " + result;
            throw new IllegalArgumentException(string3.toString());
        }
        return result;
    }

    @Override
    @NotNull
    public SubmitResponse submitReviewImmediately(@NotNull String clientId, @NotNull String accessToken, @NotNull String appId, @Nullable String releaseTime) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        SubmitResponse submitResponse = this.submitReview(clientId, accessToken, appId, 1, releaseTime, RequestBody.Companion.create("", HttpClientHelper.Companion.getMEDIA_TYPE_JSON()));
        return this.getSubmissionCompletedResponse(submitResponse, clientId, accessToken, appId, releaseTime);
    }

    private final SubmitResponse getSubmissionCompletedResponse(SubmitResponse submitResponse, String clientId, String token, String appId, String releaseTime) {
        SubmitResponse submitResponse2;
        if (submitResponse.getRet().getCode() == 0) {
            submitResponse2 = submitResponse;
        } else if (submitResponse.getRet().getCode() == 204144660 && StringsKt.contains$default((CharSequence)submitResponse.getRet().getMsg(), (CharSequence)"It may take 2-5 minutes", (boolean)false, (int)2, null)) {
            SubmitResponse submissionResult;
            this.logger.v("Build is currently processing, waiting for 3 minutes before submitting again...");
            Thread.sleep(180000L);
            submitResponse2 = submissionResult = this.submitReview(clientId, token, appId, 1, releaseTime, RequestBody.Companion.create("", HttpClientHelper.Companion.getMEDIA_TYPE_JSON()));
        } else {
            throw new HuaweiHttpResponseException(submitResponse.toString());
        }
        return submitResponse2;
    }

    @Override
    @NotNull
    public SubmitResponse submitReviewWithReleasePhase(@NotNull String clientId, @NotNull String accessToken, @NotNull String appId, @Nullable String startRelease, @Nullable String endRelease, double releasePercent) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        String string = startRelease;
        Intrinsics.checkNotNull((Object)string);
        String string2 = endRelease;
        Intrinsics.checkNotNull((Object)string2);
        String string3 = "%.2f";
        Object[] objectArray = new Object[]{releasePercent};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(this, *args)");
        PhasedReleaseRequest bodyRequest = new PhasedReleaseRequest(string, string2, string4, "Release on " + releasePercent + "% from " + startRelease + " to " + endRelease);
        String string5 = this.gson.toJson((Object)bodyRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"gson.toJson(bodyRequest)");
        return this.submitReview(clientId, accessToken, appId, 3, null, RequestBody.Companion.create(string5, HttpClientHelper.Companion.getMEDIA_TYPE_JSON()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UpdateAppBasicInfoResponse updateAppBasicInfo(@NotNull String clientId, @NotNull String accessToken, @NotNull String appId, int releaseType, @NotNull String appBasicInfo) {
        Object object;
        void this_$iv$iv;
        void body$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)appBasicInfo, (String)"appBasicInfo");
        Map headers = new LinkedHashMap();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("client_id", clientId);
        HttpClientHelper httpClientHelper = this.httpClient;
        String string = "https://connect-api.cloud.huawei.com/api/publish/v2/app-info?appId=" + appId + "&releaseType=" + releaseType;
        RequestBody requestBody = RequestBody.Companion.create(appBasicInfo, HttpClientHelper.Companion.getMEDIA_TYPE_JSON());
        boolean $i$f$put = false;
        void var12_11 = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().put((RequestBody)body$iv);
        boolean $i$f$execute = false;
        try {
            void url$iv;
            Object object2;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Request.Builder $this$execute_u24lambda_u241$iv$iv = object2 = requestBuilder$iv$iv.url((String)url$iv);
            boolean bl = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Object object3 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = object3.next();
                boolean bl2 = false;
                $this$execute_u24lambda_u241$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            Throwable throwable = null;
            try {
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl3 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                object3 = HttpClientHelper.access$getGson((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, UpdateAppBasicInfoResponse.class);
                if (object3 == null) {
                    throw new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            HttpClientHelper.access$getLogger$p((HttpClientHelper)this_$iv$iv).e((Exception)((Object)e$iv$iv));
            throw new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        UpdateAppBasicInfoResponse result = (UpdateAppBasicInfoResponse)object;
        if (result.getRet().getCode() != 0) {
            throw new IllegalStateException("Update AppBasicInfo is failed for " + appBasicInfo + ". Response: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final SubmitResponse submitReview(String clientId, String token, String appId, int releaseType, String releaseTime, RequestBody requestBody) {
        Object object;
        void this_$iv$iv;
        Map headers = new LinkedHashMap();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        headers.put("Authorization", "Bearer " + token);
        headers.put("client_id", clientId);
        HttpUrl.Builder uriBuilder = HttpUrl.Companion.get("https://connect-api.cloud.huawei.com/api/publish/v2/app-submit").newBuilder().addQueryParameter("appId", appId).addQueryParameter("releaseType", String.valueOf(releaseType));
        if (releaseTime != null) {
            uriBuilder.addQueryParameter("releaseTime", releaseTime);
        }
        String string = uriBuilder.build().url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.build().toUrl().toString()");
        String url = string;
        HttpClientHelper this_$iv = this.httpClient;
        boolean $i$f$post = false;
        HttpClientHelper httpClientHelper = this_$iv;
        Request.Builder requestBuilder$iv$iv = new Request.Builder().post(requestBody);
        boolean $i$f$execute = false;
        try {
            Object object2;
            OkHttpClient client$iv$iv = new OkHttpClient();
            Request.Builder $this$execute_u24lambda_u241$iv$iv = object2 = requestBuilder$iv$iv.url(url);
            boolean bl = false;
            Map $this$forEach$iv$iv$iv = headers;
            boolean $i$f$forEach = false;
            Object object3 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry element$iv$iv$iv;
                Map.Entry it$iv$iv = element$iv$iv$iv = object3.next();
                boolean bl2 = false;
                $this$execute_u24lambda_u241$iv$iv.header((String)it$iv$iv.getKey(), (String)it$iv$iv.getValue());
            }
            Request request$iv$iv = object2.build();
            object2 = (Closeable)client$iv$iv.newCall(request$iv$iv).execute();
            Throwable throwable = null;
            try {
                Response httpResponse$iv$iv = (Response)object2;
                boolean bl3 = false;
                int statusCode$iv$iv = httpResponse$iv$iv.code();
                if (!httpResponse$iv$iv.isSuccessful()) {
                    throw new IllegalStateException("Request failed. statusCode=" + statusCode$iv$iv + ", httpResponse=" + httpResponse$iv$iv);
                }
                ResponseBody responseBody = httpResponse$iv$iv.body();
                object3 = HttpClientHelper.access$getGson((HttpClientHelper)this_$iv$iv).fromJson(responseBody != null ? responseBody.charStream() : null, SubmitResponse.class);
                if (object3 == null) {
                    throw new IllegalStateException("http request result must not be null");
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (JsonSyntaxException e$iv$iv) {
            HttpClientHelper.access$getLogger$p((HttpClientHelper)this_$iv$iv).e((Exception)((Object)e$iv$iv));
            throw new IllegalStateException("Request is failed. Something went wrong, please check request!");
        }
        SubmitResponse result = (SubmitResponse)object;
        return result;
    }
}

