/*
 * Decompiled with CFR 0.152.
 */
package ru.cian.huawei.publish.utils;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.BuiltArtifacts;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cian.huawei.publish.BuildFormat;
import ru.cian.huawei.publish.utils.BuildFileProvider;
import ru.cian.huawei.publish.utils.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lru/cian/huawei/publish/utils/BuildFileProvider;", "", "variant", "Lcom/android/build/api/variant/ApplicationVariant;", "logger", "Lru/cian/huawei/publish/utils/Logger;", "(Lcom/android/build/api/variant/ApplicationVariant;Lru/cian/huawei/publish/utils/Logger;)V", "getBuildFile", "Ljava/io/File;", "buildFormat", "Lru/cian/huawei/publish/BuildFormat;", "getFinalApkArtifactCompat", "", "getFinalBundleArtifactCompat", "plugin"})
@SourceDebugExtension(value={"SMAP\nBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildFileProvider.kt\nru/cian/huawei/publish/utils/BuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1549#2:37\n1620#2,3:38\n1549#2:41\n1620#2,3:42\n1549#2:45\n1620#2,3:46\n*S KotlinDebug\n*F\n+ 1 BuildFileProvider.kt\nru/cian/huawei/publish/utils/BuildFileProvider\n*L\n26#1:37\n26#1:38,3\n27#1:41\n27#1:42,3\n27#1:45\n27#1:46,3\n*E\n"})
public final class BuildFileProvider {
    @NotNull
    private final ApplicationVariant variant;
    @NotNull
    private final Logger logger;

    public BuildFileProvider(@NotNull ApplicationVariant variant, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.variant = variant;
        this.logger = logger2;
    }

    @Nullable
    public final File getBuildFile(@NotNull BuildFormat buildFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)buildFormat), (String)"buildFormat");
        return switch (WhenMappings.$EnumSwitchMapping$0[buildFormat.ordinal()]) {
            case 1 -> (File)CollectionsKt.singleOrNull(this.getFinalApkArtifactCompat(this.variant));
            case 2 -> (File)CollectionsKt.singleOrNull(this.getFinalBundleArtifactCompat(this.variant));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getFinalApkArtifactCompat(ApplicationVariant variant) {
        List list;
        Collection collection;
        Object object = variant.getArtifacts().get((SingleArtifact)SingleArtifact.APK.INSTANCE).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant.artifacts.get(SingleArtifact.APK).get()");
        Directory apkDirectory = (Directory)object;
        this.logger.v("Build File Directory: " + apkDirectory);
        BuiltArtifacts builtArtifacts = variant.getArtifacts().getBuiltArtifactsLoader().load(apkDirectory);
        if (builtArtifacts != null && (collection = builtArtifacts.getElements()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void element;
                BuiltArtifact builtArtifact = (BuiltArtifact)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new File(element.getOutputFile()));
            }
            list = (List)destination$iv$iv;
        } else {
            String it;
            Collection collection3;
            Iterable $this$mapTo$iv$iv;
            FileTree fileTree = apkDirectory.getAsFileTree().matching((Action)getFinalApkArtifactCompat.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"apkDirectory.asFileTree.\u2026hing { include(\"*.apk\") }");
            Iterable $this$map$iv = (Iterable)fileTree;
            boolean $i$f$map = false;
            Iterable destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File bl = (File)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl2 = false;
                collection3.add(((File)((Object)it)).getAbsolutePath());
            }
            $this$map$iv = (List)destination$iv$iv2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl = false;
                collection3.add(new File(it));
            }
            list = (List)destination$iv$iv2;
        }
        return list;
    }

    private final List<File> getFinalBundleArtifactCompat(ApplicationVariant variant) {
        File file = ((RegularFile)variant.getArtifacts().get((SingleArtifact)SingleArtifact.BUNDLE.INSTANCE).get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"variant.artifacts.get(Si\u2026fact.BUNDLE).get().asFile");
        File aabFile = file;
        return CollectionsKt.listOf((Object)aabFile);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuildFormat.values().length];
            try {
                nArray[BuildFormat.APK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildFormat.AAB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

