/*
 * Decompiled with CFR 0.152.
 */
package ru.cian.huawei.publish.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cian.huawei.publish.BuildFormat;
import ru.cian.huawei.publish.Credentials;
import ru.cian.huawei.publish.DeployType;
import ru.cian.huawei.publish.HuaweiPublishCliParam;
import ru.cian.huawei.publish.HuaweiPublishConfig;
import ru.cian.huawei.publish.HuaweiPublishExtensionConfig;
import ru.cian.huawei.publish.ReleaseNotesConfig;
import ru.cian.huawei.publish.ReleaseNotesDescriptionsConfig;
import ru.cian.huawei.publish.ReleaseNotesExtension;
import ru.cian.huawei.publish.ReleasePhaseConfig;
import ru.cian.huawei.publish.ReleasePhaseExtension;
import ru.cian.huawei.publish.models.Credential;
import ru.cian.huawei.publish.utils.BuildFileProvider;
import ru.cian.huawei.publish.utils.CredentialHelper;
import ru.cian.huawei.publish.utils.FileWrapper;
import ru.cian.huawei.publish.utils.KotlinExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lru/cian/huawei/publish/utils/ConfigProvider;", "", "extension", "Lru/cian/huawei/publish/HuaweiPublishExtensionConfig;", "cli", "Lru/cian/huawei/publish/HuaweiPublishCliParam;", "buildFileProvider", "Lru/cian/huawei/publish/utils/BuildFileProvider;", "releaseNotesFileProvider", "Lru/cian/huawei/publish/utils/FileWrapper;", "(Lru/cian/huawei/publish/HuaweiPublishExtensionConfig;Lru/cian/huawei/publish/HuaweiPublishCliParam;Lru/cian/huawei/publish/utils/BuildFileProvider;Lru/cian/huawei/publish/utils/FileWrapper;)V", "checkReleasePhaseData", "", "releasePhase", "Lru/cian/huawei/publish/ReleasePhaseConfig;", "getAppBasicInfoFile", "Ljava/io/File;", "getBuildFile", "customBuildFilePath", "", "artifactFormat", "Lru/cian/huawei/publish/BuildFormat;", "getConfig", "Lru/cian/huawei/publish/HuaweiPublishConfig;", "getCredentialsConfig", "Lru/cian/huawei/publish/Credentials;", "getReleaseNotesConfig", "Lru/cian/huawei/publish/ReleaseNotesConfig;", "getReleasePhaseConfig", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nConfigProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigProvider.kt\nru/cian/huawei/publish/utils/ConfigProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1549#2:253\n1620#2,3:254\n1549#2:257\n1620#2,3:258\n1549#2:261\n1620#2,3:262\n*S KotlinDebug\n*F\n+ 1 ConfigProvider.kt\nru/cian/huawei/publish/utils/ConfigProvider\n*L\n180#1:253\n180#1:254,3\n183#1:257\n183#1:258,3\n193#1:261\n193#1:262,3\n*E\n"})
public final class ConfigProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HuaweiPublishExtensionConfig extension;
    @NotNull
    private final HuaweiPublishCliParam cli;
    @NotNull
    private final BuildFileProvider buildFileProvider;
    @NotNull
    private final FileWrapper releaseNotesFileProvider;
    private static final int RELEASE_NOTES_MAX_LENGTH = 500;

    public ConfigProvider(@NotNull HuaweiPublishExtensionConfig extension, @NotNull HuaweiPublishCliParam cli, @NotNull BuildFileProvider buildFileProvider, @NotNull FileWrapper releaseNotesFileProvider) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)cli, (String)"cli");
        Intrinsics.checkNotNullParameter((Object)buildFileProvider, (String)"buildFileProvider");
        Intrinsics.checkNotNullParameter((Object)releaseNotesFileProvider, (String)"releaseNotesFileProvider");
        this.extension = extension;
        this.cli = cli;
        this.buildFileProvider = buildFileProvider;
        this.releaseNotesFileProvider = releaseNotesFileProvider;
    }

    @NotNull
    public final HuaweiPublishConfig getConfig() {
        BuildFormat buildFormat;
        String string;
        String customBuildFilePath;
        String string2;
        BuildFormat artifactFormat;
        DeployType deployType = this.cli.getDeployType();
        if (deployType == null) {
            deployType = this.extension.getDeployType();
        }
        DeployType deployType2 = deployType;
        String string3 = this.cli.getPublishTimeoutMs();
        long publishTimeoutMs = string3 != null ? Long.parseLong(string3) : this.extension.getPublishTimeoutMs();
        String string4 = this.cli.getPublishPeriodMs();
        long publishPeriodMs = string4 != null ? Long.parseLong(string4) : this.extension.getPublishPeriodMs();
        BuildFormat buildFormat2 = this.cli.getBuildFormat();
        if (buildFormat2 == null) {
            buildFormat2 = artifactFormat = this.extension.getBuildFormat();
        }
        if ((string2 = this.cli.getBuildFile()) == null) {
            string2 = customBuildFilePath = this.extension.getBuildFile();
        }
        if ((string = this.cli.getReleaseTime()) == null) {
            string = this.extension.getReleaseTime();
        }
        String releaseTime = string;
        ReleasePhaseConfig releasePhase = this.getReleasePhaseConfig();
        Credentials credentialsConfig = this.getCredentialsConfig();
        ReleaseNotesConfig releaseNotes = this.getReleaseNotesConfig();
        File appBasicInfoFile = this.getAppBasicInfoFile();
        File artifactFile = this.getBuildFile(customBuildFilePath, artifactFormat);
        String artifactFileExtension = FilesKt.getExtension((File)artifactFile);
        String string5 = artifactFileExtension;
        if (Intrinsics.areEqual((Object)string5, (Object)"apk")) {
            buildFormat = BuildFormat.APK;
        } else if (Intrinsics.areEqual((Object)string5, (Object)"aab")) {
            buildFormat = BuildFormat.AAB;
        } else {
            throw new IllegalArgumentException("Not allowed artifact file extension: `" + artifactFileExtension + "`. It should be `apk` or `aab`. ");
        }
        BuildFormat actualArtifactFormat = buildFormat;
        return new HuaweiPublishConfig(credentialsConfig, deployType2, actualArtifactFormat, artifactFile, publishTimeoutMs, publishPeriodMs, releaseTime, releasePhase, releaseNotes, appBasicInfoFile);
    }

    @NotNull
    public final File getBuildFile(@Nullable String customBuildFilePath, @NotNull BuildFormat artifactFormat) {
        File artifactFile;
        Intrinsics.checkNotNullParameter((Object)((Object)artifactFormat), (String)"artifactFormat");
        File file = artifactFile = customBuildFilePath != null ? new File(customBuildFilePath) : this.buildFileProvider.getBuildFile(artifactFormat);
        if (artifactFile == null || !artifactFile.exists()) {
            throw new FileNotFoundException(artifactFile + " (No such file or directory). Application build file is not found. Please run `assemble` or `bundle` task to build the application file before current task.");
        }
        if (!Intrinsics.areEqual((Object)artifactFormat.getFileExtension(), (Object)FilesKt.getExtension((File)artifactFile))) {
            boolean bl = false;
            String string = "Build file " + artifactFile.getAbsolutePath() + " has wrong file extension that doesn't match with announced buildFormat(" + artifactFormat + ") plugin extension param.";
            throw new IllegalArgumentException(string.toString());
        }
        return artifactFile;
    }

    @NotNull
    public final Credentials getCredentialsConfig() {
        String string = this.cli.getCredentialsPath();
        if (string == null) {
            string = this.extension.getCredentialsPath();
        }
        String credentialsFilePath = string;
        String clientIdPriority = this.cli.getClientId();
        String clientSecretPriority = this.cli.getClientSecret();
        Lazy credentials2 = LazyKt.lazy((Function0)((Function0)new Function0<Credential>(credentialsFilePath, this){
            final /* synthetic */ String $credentialsFilePath;
            final /* synthetic */ ConfigProvider this$0;
            {
                this.$credentialsFilePath = $credentialsFilePath;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Credential invoke() {
                CharSequence charSequence = this.$credentialsFilePath;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    throw new FileNotFoundException(ConfigProvider.access$getExtension$p(this.this$0) + " (File path for credentials is null or empty. See the `credentialsPath` param description.");
                }
                File credentialsFile = new File(this.$credentialsFilePath);
                if (!credentialsFile.exists()) {
                    throw new FileNotFoundException(ConfigProvider.access$getExtension$p(this.this$0) + " (File (" + credentialsFile.getAbsolutePath() + ") with 'client_id' and 'client_secret' for access to Huawei Publish API is not found)");
                }
                return CredentialHelper.INSTANCE.getCredentials(credentialsFile);
            }
        }));
        String string2 = clientIdPriority;
        if (string2 == null && (string2 = KotlinExtensionsKt.nullIfBlank(((Credential)credentials2.getValue()).getClientId())) == null) {
            throw new IllegalArgumentException("(Huawei credential `clientId` param is null or empty). Please check your credentials file content or as single parameter.");
        }
        String clientId = string2;
        String string3 = clientSecretPriority;
        if (string3 == null && (string3 = KotlinExtensionsKt.nullIfBlank(((Credential)credentials2.getValue()).getClientSecret())) == null) {
            throw new IllegalArgumentException("(Huawei credential `clientSecret` param is null or empty). Please check your credentials file content or as single parameter.");
        }
        String clientSecret = string3;
        return new Credentials(clientId, clientSecret);
    }

    @Nullable
    public final ReleasePhaseConfig getReleasePhaseConfig() {
        ReleasePhaseConfig releasePhase;
        Double releasePhasePercent;
        String string;
        String releasePhaseStartTime;
        String string2 = this.cli.getReleasePhaseStartTime();
        if (string2 == null) {
            ReleasePhaseExtension releasePhaseExtension = this.extension.getReleasePhase();
            string2 = releasePhaseStartTime = releasePhaseExtension != null ? releasePhaseExtension.getStartTime() : null;
        }
        if ((string = this.cli.getReleasePhaseEndTime()) == null) {
            ReleasePhaseExtension releasePhaseExtension = this.extension.getReleasePhase();
            string = releasePhaseExtension != null ? releasePhaseExtension.getEndTime() : null;
        }
        String releasePhaseEndTime = string;
        String string3 = this.cli.getReleasePhasePercent();
        if (string3 != null) {
            v5 = Double.parseDouble(string3);
        } else {
            ReleasePhaseExtension releasePhaseExtension = this.extension.getReleasePhase();
            v5 = releasePhasePercent = releasePhaseExtension != null ? releasePhaseExtension.getPercent() : null;
        }
        if (releasePhaseStartTime != null || releasePhaseEndTime != null || releasePhasePercent != null) {
            if (!(releasePhaseStartTime != null)) {
                boolean $i$a$-require-ConfigProvider$getReleasePhaseConfig$releasePhase$42 = false;
                String $i$a$-require-ConfigProvider$getReleasePhaseConfig$releasePhase$42 = "The `startTime` param must not be null if you choose publishing with Release Phase.";
                throw new IllegalArgumentException($i$a$-require-ConfigProvider$getReleasePhaseConfig$releasePhase$42.toString());
            }
            if (!(releasePhaseEndTime != null)) {
                boolean $i$a$-require-ConfigProvider$getReleasePhaseConfig$releasePhase$52 = false;
                String $i$a$-require-ConfigProvider$getReleasePhaseConfig$releasePhase$52 = "The `endTime` param must not be null if you choose publishing with Release Phase.";
                throw new IllegalArgumentException($i$a$-require-ConfigProvider$getReleasePhaseConfig$releasePhase$52.toString());
            }
            if (!(releasePhasePercent != null)) {
                boolean bl = false;
                String string4 = "The `percent` param must not be null if you choose publishing with Release Phase.";
                throw new IllegalArgumentException(string4.toString());
            }
            v7 = new ReleasePhaseConfig(releasePhaseStartTime, releasePhaseEndTime, releasePhasePercent);
        } else {
            v7 = releasePhase = null;
        }
        if (releasePhase != null) {
            this.checkReleasePhaseData(releasePhase);
        }
        return releasePhase;
    }

    private final void checkReleasePhaseData(ReleasePhaseConfig releasePhase) {
        if (!(releasePhase.getPercent() > 0.0 && releasePhase.getPercent() <= 100.0)) {
            boolean $i$a$-require-ConfigProvider$checkReleasePhaseData$42 = false;
            String $i$a$-require-ConfigProvider$checkReleasePhaseData$42 = "Wrong percent release phase value = '" + releasePhase.getPercent() + "'. Allowed values between 1 and 100 with up to two decimal places.";
            throw new IllegalArgumentException($i$a$-require-ConfigProvider$checkReleasePhaseData$42.toString());
        }
        Calendar nowCalendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ", Locale.getDefault());
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(sdf.parse(releasePhase.getEndTime()));
        if (!endCalendar.after(nowCalendar)) {
            boolean bl = false;
            String string = "Wrong endTime release phase value = '" + releasePhase.getEndTime() + "'. It less than current moment.";
            throw new IllegalArgumentException(string.toString());
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(sdf.parse(releasePhase.getStartTime()));
        if (!startCalendar.before(endCalendar)) {
            boolean bl = false;
            String string = "Wrong startTime release phase value = '" + releasePhase.getStartTime() + "'. It bigger than endTime = '" + releasePhase.getEndTime() + "'.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ReleaseNotesConfig getReleaseNotesConfig() {
        void $this$mapTo$iv$iv;
        boolean bl;
        List releaseNotePairs;
        Collection collection;
        String[] stringArray;
        Object object = this.cli.getReleaseNotes();
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{";"}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Iterator it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                var14_22 = new String[]{":"};
                List split = StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (String[])var14_22, (boolean)false, (int)0, (int)6, null);
                collection.add(TuplesKt.to(split.get(0), split.get(1)));
            }
            v1 = (List)destination$iv$iv;
        } else {
            Object object2 = this.extension.getReleaseNotes();
            if (object2 != null && (object2 = ((ReleaseNotesExtension)object2).getDescriptions()) != null) {
                void $this$mapTo$iv$iv3;
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable $i$f$mapTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it;
                    var14_22 = (String[])item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(TuplesKt.to((Object)it.getLang(), (Object)it.getFilePath()));
                }
                v1 = (List)destination$iv$iv;
            } else {
                v1 = releaseNotePairs = null;
            }
        }
        if (releaseNotePairs == null) {
            return null;
        }
        Boolean bl4 = this.cli.getRemoveHtmlTags();
        if (bl4 != null) {
            bl = bl4;
        } else {
            ReleaseNotesExtension releaseNotesExtension = this.extension.getReleaseNotes();
            Boolean bl5 = releaseNotesExtension != null ? releaseNotesExtension.getRemoveHtmlTags() : null;
            bl = bl5 != null ? bl5 : false;
        }
        boolean removeHtmlTags = bl;
        Iterable $this$map$iv = releaseNotePairs;
        boolean $i$f$map = false;
        Iterable $i$f$map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String newFeatures;
            void it;
            Pair $i$f$mapTo2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            String lang = (String)it.getFirst();
            String filePath = (String)it.getSecond();
            if (!(!StringsKt.isBlank((CharSequence)lang))) {
                boolean $i$a$-require-ConfigProvider$getReleaseNotesConfig$descriptions$1$42 = false;
                String $i$a$-require-ConfigProvider$getReleaseNotesConfig$descriptions$1$42 = "'lang' param must not be empty.";
                throw new IllegalArgumentException($i$a$-require-ConfigProvider$getReleaseNotesConfig$descriptions$1$42.toString());
            }
            File file = this.releaseNotesFileProvider.getFile(filePath);
            if (!file.exists()) {
                boolean bl7 = false;
                String string = "File '" + filePath + "' with Release Notes for '" + lang + "' language is not exist.";
                throw new IllegalArgumentException(string.toString());
            }
            if (removeHtmlTags) {
                CharSequence charSequence = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
                Regex regex = new Regex("\\<[^>]*>");
                String string = "";
                charSequence = regex.replace(charSequence, string);
                regex = new Regex("(&#)[^;]*;");
                string = "*";
                charSequence = regex.replace(charSequence, string);
                regex = new Regex("[\\s&&[^\\n]]+");
                string = " ";
                v7 = regex.replace(charSequence, string);
            } else {
                v7 = newFeatures = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
            }
            if (!(newFeatures.length() <= 500)) {
                boolean bl8 = false;
                String string = "Release notes from '" + filePath + "' for '" + lang + "' language must be less or equals to 500 sign.";
                throw new IllegalArgumentException(string.toString());
            }
            collection.add(new ReleaseNotesDescriptionsConfig(lang, newFeatures));
        }
        List descriptions = (List)destination$iv$iv;
        return new ReleaseNotesConfig(descriptions, removeHtmlTags);
    }

    private final File getAppBasicInfoFile() {
        String path;
        CharSequence charSequence;
        String string = this.cli.getAppBasicInfo();
        if (string == null) {
            string = this.extension.getAppBasicInfo();
        }
        if ((charSequence = (CharSequence)(path = string)) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            boolean bl = false;
            String string2 = "File '" + path + "' with AppBasicInfo is not exist.";
            throw new IllegalArgumentException(string2.toString());
        }
        return file;
    }

    public static final /* synthetic */ HuaweiPublishExtensionConfig access$getExtension$p(ConfigProvider $this) {
        return $this.extension;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/cian/huawei/publish/utils/ConfigProvider$Companion;", "", "()V", "RELEASE_NOTES_MAX_LENGTH", "", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

