/*
 * Decompiled with CFR 0.152.
 */
package ru.concerteza.util.buildnumber;

public class BuildNumber {
    private final String revision;
    private final String branch;
    private final String tag;
    private final String parent;
    private final int commitsCount;
    private final String commitDate;

    public BuildNumber(String revision, String branch, String tag, String parent, int commitsCount, String commitDate) {
        this.revision = revision;
        this.branch = branch;
        this.tag = tag;
        this.parent = parent;
        this.commitsCount = commitsCount;
        this.commitDate = commitDate;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getShortRevision() {
        if (null == this.revision) {
            return null;
        }
        if (this.revision.length() > 7) {
            return this.revision.substring(0, 7);
        }
        return this.revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getTag() {
        return this.tag;
    }

    public String getParent() {
        return this.parent;
    }

    public int getCommitsCount() {
        return this.commitsCount;
    }

    public String getCommitsCountAsString() {
        return Integer.toString(this.commitsCount);
    }

    public String getCommitDate() {
        return this.commitDate;
    }

    public String defaultBuildnumber() {
        String name = this.tag.length() > 0 ? this.tag : (this.branch.length() > 0 ? this.branch : "UNNAMED");
        return String.format("%s.%d.%s", name, this.commitsCount, this.getShortRevision());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JGitBuildNumber");
        sb.append("{revision='").append(this.revision).append('\'');
        sb.append(", branch='").append(this.branch).append('\'');
        sb.append(", tag='").append(this.tag).append('\'');
        sb.append(", parent='").append(this.parent).append('\'');
        sb.append(", commitsCount=").append(this.commitsCount);
        sb.append(", commitDate=").append(this.commitDate);
        sb.append('}');
        return sb.toString();
    }
}

