/*
 * Decompiled with CFR 0.152.
 */
package ru.concerteza.util.buildnumber;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.Project;
import ru.concerteza.util.buildnumber.BuildNumber;
import ru.concerteza.util.buildnumber.BuildNumberExtractor;

public class JGitBuildNumberAntTask {
    private Project project;

    public void setProject(Project project) {
        this.project = project;
    }

    public void execute() throws IOException {
        String repoDirString = this.project.getProperty("git.repositoryDirectory");
        File repoDir = null != repoDirString ? new File(repoDirString) : new File(".");
        BuildNumber bn = BuildNumberExtractor.extract(repoDir);
        this.project.setProperty("git.revision", bn.getRevision());
        this.project.setProperty("git.shortRevision", bn.getShortRevision());
        this.project.setProperty("git.branch", bn.getBranch());
        this.project.setProperty("git.tag", bn.getTag());
        this.project.setProperty("git.commitsCount", bn.getCommitsCountAsString());
        this.project.setProperty("git.buildnumber", bn.defaultBuildnumber());
    }
}

