/*
 * Decompiled with CFR 0.152.
 */
package ru.concerteza.util.buildnumber;

import java.io.File;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import ru.concerteza.util.buildnumber.BuildNumber;
import ru.concerteza.util.buildnumber.BuildNumberExtractor;

public class JGitBuildNumberMojo
extends AbstractMojo {
    private String revisionProperty = "git.revision";
    private String branchProperty = "git.branch";
    private String tagProperty = "git.tag";
    private String commitsCountProperty = "git.commitsCount";
    private String buildnumberProperty = "git.buildnumber";
    private String javaScriptBuildnumberCallback = null;
    private File baseDirectory;
    private File executionRootDirectory;
    private MavenProject project;
    private MavenProject parentProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties props = this.project.getProperties();
        try {
            if (this.executionRootDirectory.equals(this.baseDirectory)) {
                BuildNumber bn = BuildNumberExtractor.extract();
                props.setProperty(this.revisionProperty, bn.getRevision());
                props.setProperty(this.branchProperty, bn.getBranch());
                props.setProperty(this.tagProperty, bn.getTag());
                props.setProperty(this.commitsCountProperty, bn.getCommitsCountAsString());
                String composite = this.createBuildnumber(bn);
                props.setProperty(this.buildnumberProperty, composite);
                this.getLog().info((CharSequence)("Git info extracted, revision: '" + bn.getShortRevision() + "', branch: '" + bn.getBranch() + "', tag: '" + bn.getTag() + "', commitsCount: '" + bn.getCommitsCount() + "', buildnumber: '" + composite + "'"));
            } else if ("pom".equals(this.parentProject.getPackaging())) {
                Properties parentProps = this.parentProject.getProperties();
                props.setProperty(this.revisionProperty, parentProps.getProperty(this.revisionProperty));
                props.setProperty(this.branchProperty, parentProps.getProperty(this.branchProperty));
                props.setProperty(this.tagProperty, parentProps.getProperty(this.tagProperty));
                props.setProperty(this.commitsCountProperty, parentProps.getProperty(this.commitsCountProperty));
                props.setProperty(this.buildnumberProperty, parentProps.getProperty(this.buildnumberProperty));
            } else {
                this.getLog().warn((CharSequence)"Cannot extract JGit version: something wrong with build process, we're not in parent, not in subproject!");
                this.fillPropsUnknown(props);
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            this.fillPropsUnknown(props);
        }
    }

    private void fillPropsUnknown(Properties props) {
        props.setProperty(this.revisionProperty, "UNKNOWN_REVISION");
        props.setProperty(this.branchProperty, "UNKNOWN_BRANCH");
        props.setProperty(this.tagProperty, "UNKNOWN_TAG");
        props.setProperty(this.commitsCountProperty, "-1");
        props.setProperty(this.buildnumberProperty, "UNKNOWN_BUILDNUMBER");
    }

    private String createBuildnumber(BuildNumber bn) throws ScriptException {
        if (null != this.javaScriptBuildnumberCallback) {
            return this.buildnumberFromJS(bn);
        }
        return bn.defaultBuildnumber();
    }

    private String buildnumberFromJS(BuildNumber bn) throws ScriptException {
        ScriptEngine jsEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        jsEngine.put("tag", bn.getTag());
        jsEngine.put("branch", bn.getBranch());
        jsEngine.put("revision", bn.getRevision());
        jsEngine.put("shortRevision", bn.getShortRevision());
        jsEngine.put("commitsCount", bn.getCommitsCount());
        Object res = jsEngine.eval(this.javaScriptBuildnumberCallback);
        if (null == res) {
            throw new IllegalStateException("JS buildnumber callback returns null");
        }
        return res.toString();
    }
}

