/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ICallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicDataAccessor;
import ru.curs.celesta.dbutils.ILoggingManager;
import ru.curs.celesta.dbutils.IPermissionManager;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.score.Score;

public class CallContext
implements ICallContext {
    public static final int MAX_DATA_ACCESSORS = 1023;
    private static final Map<Connection, Integer> PIDSCACHE = Collections.synchronizedMap(new WeakHashMap());
    private final String userId;
    private ICelesta celesta;
    private Connection conn;
    private String procName;
    private int dbPid;
    private Date startTime;
    private long activationTime;
    private long closingTime;
    private BasicDataAccessor lastDataAccessor;
    private int dataAccessorsCount;
    private State state;

    public CallContext(String userId) {
        if (Objects.requireNonNull(userId).isEmpty()) {
            throw new CelestaException("Call context's user Id must not be empty");
        }
        this.userId = userId;
        this.state = State.NEW;
    }

    public CallContext(String userId, ICelesta celesta, String procName) {
        this(userId);
        this.activate(celesta, procName);
    }

    final int getDataAccessorsCount() {
        return this.dataAccessorsCount;
    }

    public void activate(ICelesta celesta, String procName) {
        Objects.requireNonNull(celesta);
        Objects.requireNonNull(procName);
        if (this.state != State.NEW) {
            throw new CelestaException("Cannot activate CallContext in %s state (NEW expected).", new Object[]{this.state});
        }
        this.celesta = celesta;
        this.procName = procName;
        this.state = State.ACTIVE;
        this.conn = celesta.getConnectionPool().get();
        this.dbPid = PIDSCACHE.computeIfAbsent(this.conn, arg_0 -> ((DBAdaptor)this.getDbAdaptor()).getDBPid(arg_0));
        this.startTime = new Date();
        this.activationTime = System.nanoTime();
    }

    public Connection getConn() {
        return this.conn;
    }

    public String getUserId() {
        return this.userId;
    }

    public void commit() {
        if (this.state == State.ACTIVE) {
            try {
                this.conn.commit();
            }
            catch (SQLException e) {
                throw new CelestaException(String.format("Commit unsuccessful: %s", e.getMessage()), (Throwable)e);
            }
        } else {
            throw new CelestaException("Not active context cannot be committed");
        }
    }

    public void rollback() {
        if (this.conn != null) {
            try {
                this.conn.rollback();
            }
            catch (SQLException e) {
                throw new CelestaException(String.format("Rollback unsuccessful: %s", e.getMessage()), (Throwable)e);
            }
        }
    }

    public ICelesta getCelesta() {
        return this.celesta;
    }

    public Score getScore() {
        return this.celesta.getScore();
    }

    public void setLastDataAccessor(BasicDataAccessor dataAccessor) {
        this.lastDataAccessor = dataAccessor;
    }

    public void incDataAccessorsCount() {
        if (this.dataAccessorsCount > 1023) {
            throw new CelestaException("Too many data accessors created in one Celesta procedure call. Check for leaks!");
        }
        ++this.dataAccessorsCount;
    }

    public void decDataAccessorsCount() {
        --this.dataAccessorsCount;
    }

    public BasicDataAccessor getLastDataAccessor() {
        return this.lastDataAccessor;
    }

    private void closeDataAccessors() {
        while (this.lastDataAccessor != null) {
            this.lastDataAccessor.close();
        }
    }

    public int getDBPid() {
        return this.dbPid;
    }

    public String getProcName() {
        return this.procName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public long getDurationNs() {
        switch (this.state) {
            case NEW: {
                return 0L;
            }
            case ACTIVE: {
                return System.nanoTime() - this.activationTime;
            }
        }
        return this.closingTime - this.activationTime;
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public IPermissionManager getPermissionManager() {
        return this.celesta.getPermissionManager();
    }

    public ILoggingManager getLoggingManager() {
        return this.celesta.getLoggingManager();
    }

    public DBAdaptor getDbAdaptor() {
        return this.celesta.getDBAdaptor();
    }

    public final void close() {
        try {
            this.closeDataAccessors();
            if (this.conn != null) {
                this.conn.close();
            }
            if (this.celesta != null) {
                this.celesta.getProfiler().logCall(this);
            }
            this.closingTime = System.nanoTime();
            this.state = State.CLOSED;
        }
        catch (Exception e) {
            throw new CelestaException("Can't close callContext", (Throwable)e);
        }
    }

    public CallContext getCopy() {
        CallContext cc = new CallContext(this.userId);
        cc.activate(this.celesta, this.procName);
        return cc;
    }

    private static enum State {
        NEW,
        ACTIVE,
        CLOSED;

    }
}

