/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.PermissionDeniedException;
import ru.curs.celesta.dbutils.Action;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.CursorGetHelper;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TableElement;

public abstract class MaterializedViewCursor
extends BasicCursor {
    private MaterializedView meta = null;
    private final CursorGetHelper getHelper;

    public MaterializedViewCursor(CallContext context) {
        super(context);
        CursorGetHelper.CursorGetHelperBuilder cghb = new CursorGetHelper.CursorGetHelperBuilder();
        cghb.withDb(this.db()).withConn(this.conn()).withMeta((TableElement)this.meta()).withTableName(this._objectName());
        this.getHelper = cghb.build();
    }

    public MaterializedViewCursor(CallContext context, ColumnMeta<?> ... columns) {
        this(context, Arrays.stream(columns).map(ColumnMeta::getName).collect(Collectors.toSet()));
    }

    public MaterializedViewCursor(CallContext context, Set<String> fields) {
        super(context, fields);
        CursorGetHelper.CursorGetHelperBuilder cghb = new CursorGetHelper.CursorGetHelperBuilder();
        cghb.withDb(this.db()).withConn(this.conn()).withMeta((TableElement)this.meta()).withTableName(this._objectName()).withFields(this.fieldsForStatement);
        this.getHelper = cghb.build();
    }

    public static MaterializedViewCursor create(MaterializedView view, CallContext callContext) {
        return (MaterializedViewCursor)BasicCursor.create((DataGrainElement)view, callContext);
    }

    public static MaterializedViewCursor create(MaterializedView view, CallContext callContext, Set<String> fields) {
        return (MaterializedViewCursor)BasicCursor.create((DataGrainElement)view, callContext, fields);
    }

    public MaterializedView meta() {
        if (this.meta == null) {
            try {
                this.meta = (MaterializedView)((CallContext)this.callContext()).getScore().getGrain(this._grainName()).getElement(this._objectName(), MaterializedView.class);
            }
            catch (ParseException e) {
                throw new CelestaException(e.getMessage());
            }
        }
        return this.meta;
    }

    @Override
    final void appendPK(List<String> l, List<Boolean> ol, Set<String> colNames) {
        for (String colName : this.meta().getPrimaryKey().keySet()) {
            if (colNames.contains(colName)) continue;
            l.add(String.format("\"%s\"", colName));
            ol.add(Boolean.FALSE);
        }
    }

    public final void get(Object ... values) {
        if (!this.tryGet(values)) {
            StringBuilder sb = new StringBuilder();
            for (Object value : values) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(value == null ? "null" : value.toString());
            }
            throw new CelestaException("There is no %s (%s).", new Object[]{this._objectName(), sb.toString()});
        }
    }

    public final boolean tryGet(Object ... values) {
        if (!this.canRead()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.READ);
        }
        return this.getHelper.internalGet(this::_parseResult, Optional.empty(), 0, values);
    }

    public final boolean tryGetCurrent() {
        if (!this.canRead()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.READ);
        }
        return this.getHelper.internalGet(this::_parseResult, Optional.empty(), 0, this._currentKeyValues());
    }

    public Object[] getCurrentKeyValues() {
        return this._currentKeyValues();
    }

    protected abstract Object[] _currentKeyValues();
}

