/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.ReadOnlyTable;

public abstract class ReadOnlyTableCursor
extends BasicCursor {
    private ReadOnlyTable meta = null;

    public ReadOnlyTableCursor(CallContext context) {
        super(context);
    }

    public ReadOnlyTableCursor(CallContext context, ColumnMeta<?> ... columns) {
        this(context, Arrays.stream(columns).map(ColumnMeta::getName).collect(Collectors.toSet()));
    }

    public ReadOnlyTableCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public static ReadOnlyTableCursor create(ReadOnlyTable table, CallContext callContext) {
        return (ReadOnlyTableCursor)BasicCursor.create((DataGrainElement)table, callContext);
    }

    public static ReadOnlyTableCursor create(ReadOnlyTable table, CallContext callContext, Set<String> fields) {
        return (ReadOnlyTableCursor)BasicCursor.create((DataGrainElement)table, callContext, fields);
    }

    public final ReadOnlyTable meta() {
        if (this.meta == null) {
            try {
                this.meta = (ReadOnlyTable)((CallContext)this.callContext()).getScore().getGrain(this._grainName()).getElement(this._objectName(), ReadOnlyTable.class);
            }
            catch (ParseException e) {
                throw new CelestaException(e.getMessage());
            }
        }
        return this.meta;
    }

    @Override
    final void appendPK(List<String> l, List<Boolean> ol, Set<String> colNames) {
        if (this.meta().getPrimaryKey().isEmpty() && colNames.isEmpty()) {
            l.add(String.format("\"%s\"", this.meta().getColumns().keySet().iterator().next()));
            ol.add(Boolean.FALSE);
        } else {
            for (String colName : this.meta().getPrimaryKey().keySet()) {
                if (colNames.contains(colName)) continue;
                l.add(String.format("\"%s\"", colName));
                ol.add(Boolean.FALSE);
            }
        }
    }
}

