/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicDataAccessor;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SequenceElement;

public abstract class Sequence
extends BasicDataAccessor {
    private SequenceElement meta = null;

    public Sequence(CallContext context) {
        super(context);
    }

    public static Sequence create(SequenceElement sequence, CallContext callContext) {
        try {
            String namespace = sequence.getGrain().getNamespace().getValue();
            String sequenceClassName = sequence.getName().substring(0, 1).toUpperCase() + sequence.getName().substring(1) + "Sequence";
            sequenceClassName = (namespace.isEmpty() ? "" : namespace + ".") + sequenceClassName;
            Class<?> sequenceClass = Class.forName(sequenceClassName, true, Thread.currentThread().getContextClassLoader());
            return (Sequence)((Object)sequenceClass.getConstructor(CallContext.class).newInstance(callContext));
        }
        catch (ReflectiveOperationException ex) {
            throw new CelestaException("Sequence creation failed for grain element: " + sequence.getName(), (Throwable)ex);
        }
    }

    public final long nextValue() {
        return this.db().nextSequenceValue(this.conn(), this.meta());
    }

    public void clear() {
    }

    public final SequenceElement meta() {
        if (this.meta == null) {
            try {
                this.meta = (SequenceElement)((CallContext)this.callContext()).getScore().getGrain(this._grainName()).getElement(this._objectName(), SequenceElement.class);
            }
            catch (ParseException e) {
                throw new CelestaException(e.getMessage());
            }
        }
        return this.meta;
    }
}

