/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.InFilterHolder;
import ru.curs.celesta.dbutils.InFilterSupport;
import ru.curs.celesta.dbutils.filter.In;
import ru.curs.celesta.dbutils.filter.value.FieldsLookup;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.View;

public abstract class ViewCursor
extends BasicCursor
implements InFilterSupport {
    private View meta = null;
    private InFilterHolder inFilterHolder = new InFilterHolder(this);

    public ViewCursor(CallContext context) {
        super(context);
    }

    public ViewCursor(CallContext context, ColumnMeta<?> ... columns) {
        this(context, Arrays.stream(columns).map(ColumnMeta::getName).collect(Collectors.toSet()));
    }

    public ViewCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public static ViewCursor create(View view, CallContext callContext) {
        return (ViewCursor)BasicCursor.create((DataGrainElement)view, callContext);
    }

    public static ViewCursor create(View view, CallContext callContext, Set<String> fields) {
        return (ViewCursor)BasicCursor.create((DataGrainElement)view, callContext, fields);
    }

    public View meta() {
        if (this.meta == null) {
            try {
                this.meta = (View)((CallContext)this.callContext()).getScore().getGrain(this._grainName()).getElement(this._objectName(), View.class);
            }
            catch (ParseException e) {
                throw new CelestaException(e.getMessage());
            }
        }
        return this.meta;
    }

    @Override
    final void appendPK(List<String> l, List<Boolean> ol, Set<String> colNames) {
        if (colNames.isEmpty()) {
            l.add(String.format("\"%s\"", this.meta().getColumns().keySet().iterator().next()));
            ol.add(Boolean.FALSE);
        }
    }

    @Override
    public FieldsLookup setIn(BasicCursor otherCursor) {
        return this.inFilterHolder.setIn(otherCursor);
    }

    @Override
    public In getIn() {
        return this.inFilterHolder.getIn();
    }

    @Override
    protected void resetSpecificState() {
        this.inFilterHolder = new InFilterHolder(this);
    }

    @Override
    protected void clearSpecificState() {
        this.inFilterHolder = new InFilterHolder(this);
    }

    @Override
    protected void copySpecificFiltersFrom(BasicCursor bc) {
        ViewCursor c = (ViewCursor)bc;
        this.inFilterHolder = c.inFilterHolder;
    }

    @Override
    boolean isEquivalentSpecific(BasicCursor bc) {
        ViewCursor c = (ViewCursor)bc;
        return Objects.equals(this.inFilterHolder, c.inFilterHolder);
    }
}

