/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.filter;

import java.util.HashMap;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.filter.AbstractFilter;
import ru.curs.celesta.dbutils.filter.FilterParser;
import ru.curs.celesta.score.ColumnMeta;

public final class Filter
extends AbstractFilter {
    private static final HashMap<String, FilterParser.FilterType> C2F = new HashMap();
    private final String value;
    private final FilterParser.FilterType ftype;

    public Filter(String value, ColumnMeta<?> c) {
        this.value = value;
        this.ftype = C2F.getOrDefault(c.getCelestaType(), FilterParser.FilterType.OTHER);
    }

    public String toString() {
        return this.value;
    }

    public String makeWhereClause(String quotedName, QueryBuildingHelper dba) {
        String result = FilterParser.translateFilter(this.ftype, quotedName, this.value, arg_0 -> ((QueryBuildingHelper)dba).translateDate(arg_0));
        return result;
    }

    public boolean filterEquals(AbstractFilter f) {
        if (f instanceof Filter) {
            String v2 = ((Filter)f).value;
            return this.value == null ? v2 == null : this.value.equals(v2);
        }
        return false;
    }

    static {
        C2F.put("INT", FilterParser.FilterType.NUMERIC);
        C2F.put("REAL", FilterParser.FilterType.NUMERIC);
        C2F.put("DATETIME", FilterParser.FilterType.DATETIME);
        C2F.put("VARCHAR", FilterParser.FilterType.TEXT);
        C2F.put("TEXT", FilterParser.FilterType.TEXT);
    }
}

