/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.DBType;

public abstract class BaseAppSettings {
    public static final String H2_IN_MEMORY_URL = "jdbc:h2:mem:celesta;DB_CLOSE_DELAY=-1";
    private final Properties properties;
    private final String scorePath;
    private final DBType dbType;
    private final String databaseConnection;
    private final boolean h2ReferentialIntegrity;
    private final int h2Port;
    private final String login;
    private final String password;
    private final Logger logger = Logger.getLogger("ru.curs.flute");
    private final boolean skipDBUpdate;
    private final boolean forceDBInitialize;
    private final boolean logLogins;

    public BaseAppSettings(Properties properties) {
        String lf;
        this.logger.setLevel(Level.INFO);
        this.properties = properties;
        StringBuffer sb = new StringBuffer();
        this.scorePath = properties.getProperty("score.path", "").trim();
        if (!this.scorePath.isEmpty()) {
            BaseAppSettings.checkEntries(this.scorePath, "score.path", sb);
        }
        this.h2ReferentialIntegrity = Boolean.parseBoolean(properties.getProperty("h2.referential.integrity", "false"));
        boolean h2InMemory = Boolean.parseBoolean(properties.getProperty("h2.in-memory", "false"));
        int h2PortTmp = 0;
        try {
            h2PortTmp = Integer.parseInt(properties.getProperty("h2.port", "0"));
        }
        catch (NumberFormatException e) {
            sb.append("h2.port should contain a port number.\n");
        }
        this.h2Port = h2PortTmp;
        if (h2InMemory) {
            this.databaseConnection = this.h2Port > 0 ? String.format("jdbc:h2:tcp://localhost:%d/mem:celesta", this.h2Port) : H2_IN_MEMORY_URL;
            this.login = "";
            this.password = "";
        } else {
            String url = properties.getProperty("database.connection", "").trim();
            if ("".equals(url)) {
                url = properties.getProperty("rdbms.connection.url", "").trim();
            }
            this.databaseConnection = url;
            this.login = properties.getProperty("rdbms.connection.username", "").trim();
            this.password = properties.getProperty("rdbms.connection.password", "").trim();
            if ("".equals(this.databaseConnection)) {
                sb.append("No JDBC URL given (rdbms.connection.url).\n");
            }
        }
        this.dbType = DBType.resolveByJdbcUrl((String)this.databaseConnection);
        if (this.dbType == DBType.UNKNOWN) {
            sb.append("Cannot recognize RDBMS type or unsupported database.");
        }
        if ((lf = properties.getProperty("log.file")) != null) {
            try {
                FileHandler fh = new FileHandler(lf, true);
                fh.setFormatter(new SimpleFormatter());
                this.logger.addHandler(fh);
            }
            catch (IOException e) {
                sb.append("Could not access or create log file ").append(lf).append('\n');
            }
        }
        this.skipDBUpdate = Boolean.parseBoolean(properties.getProperty("skip.dbupdate", "").trim());
        this.forceDBInitialize = Boolean.parseBoolean(properties.getProperty("force.dbinitialize", "").trim());
        this.logLogins = Boolean.parseBoolean(properties.getProperty("log.logins", "").trim());
        if (sb.length() > 0) {
            throw new CelestaException(sb.toString());
        }
    }

    protected static void checkEntries(String path, String propertyName, StringBuffer sb) {
        if (!path.isEmpty()) {
            for (String pathEntry : path.split(File.pathSeparator)) {
                File pathFile = new File(pathEntry);
                if (pathFile.isDirectory() && pathFile.canRead()) continue;
                sb.append(String.format("Invalid %s entry: %s%n", propertyName, pathEntry));
            }
        }
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean getSkipDBUpdate() {
        return this.skipDBUpdate;
    }

    public boolean getForceDBInitialize() {
        return this.forceDBInitialize;
    }

    public boolean getLogLogins() {
        return this.logLogins;
    }

    public String getScorePath() {
        return this.scorePath;
    }

    public String getDbClassName() {
        return this.dbType.getDriverClassName();
    }

    public String getDatabaseConnection() {
        return this.databaseConnection;
    }

    public boolean isH2ReferentialIntegrity() {
        return this.h2ReferentialIntegrity;
    }

    public String getDBLogin() {
        return this.login;
    }

    public String getDBPassword() {
        return this.password;
    }

    public Properties getSetupProperties() {
        return this.properties;
    }

    public int getH2Port() {
        return this.h2Port;
    }
}

